# CNI Governance

This document defines project governance for the project.

## Voting

The CNI project employs "organization voting" to ensure no single organization can dominate the project.

Individuals not associated with or employed by a company or organization are allowed one organization vote.
Each company or organization (regardless of the number of maintainers associated with or employed by that company/organization) receives one organization vote.

In other words, if two maintainers are employed by Company X, two by Company Y, two by Company Z, and one maintainer is an un-affiliated individual, a total of four "organization votes" are possible; one for X, one for Y, one for Z, and one for the un-affiliated individual.

Any maintainer from an organization may cast the vote for that organization.

For formal votes, a specific statement of what is being voted on should be added to the relevant github issue or PR, and a link to that issue or PR added to the maintainers meeting agenda document.
Maintainers should indicate their yes/no vote on that issue or PR, and after a suitable period of time, the votes will be tallied and the outcome noted.

## Changes in Maintainership

New maintainers are proposed by an existing maintainer and are elected by a 2/3 majority organization vote.

Maintainers can be removed by a 2/3 majority organization vote.

## Approving PRs

Non-specification-related PRs may be merged after receiving at least two organization votes.

Changes to the CNI Specification also follow the normal PR approval process (eg, 2 organization votes), but any maintainer can request that the approval require a 2/3 majority organization vote.

## Github Project Administration

Maintainers will be added to the containernetworking GitHub organization and added to the GitHub cni-maintainers team, and made a GitHub maintainer of that team.

After 6 months a maintainer will be made an "owner" of the GitHub organization.

## Changes in Governance

All changes in Governance require a 2/3 majority organization vote.

## Other Changes

Unless specified above, all other changes to the project require a 2/3 majority organization vote.
Additionally, any maintainer may request that any change require a 2/3 majority organization vote.
