// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.3
// source: google/cloud/asset/v1/asset_service.proto

package asset

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	_ "google.golang.org/genproto/googleapis/type/expr"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Asset content type.
type ContentType int32

const (
	// Unspecified content type.
	ContentType_CONTENT_TYPE_UNSPECIFIED ContentType = 0
	// Resource metadata.
	ContentType_RESOURCE ContentType = 1
	// The actual IAM policy set on a resource.
	ContentType_IAM_POLICY ContentType = 2
	// The Cloud Organization Policy set on an asset.
	ContentType_ORG_POLICY ContentType = 4
	// The Cloud Access context mananger Policy set on an asset.
	ContentType_ACCESS_POLICY ContentType = 5
)

// Enum value maps for ContentType.
var (
	ContentType_name = map[int32]string{
		0: "CONTENT_TYPE_UNSPECIFIED",
		1: "RESOURCE",
		2: "IAM_POLICY",
		4: "ORG_POLICY",
		5: "ACCESS_POLICY",
	}
	ContentType_value = map[string]int32{
		"CONTENT_TYPE_UNSPECIFIED": 0,
		"RESOURCE":                 1,
		"IAM_POLICY":               2,
		"ORG_POLICY":               4,
		"ACCESS_POLICY":            5,
	}
)

func (x ContentType) Enum() *ContentType {
	p := new(ContentType)
	*p = x
	return p
}

func (x ContentType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ContentType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_asset_v1_asset_service_proto_enumTypes[0].Descriptor()
}

func (ContentType) Type() protoreflect.EnumType {
	return &file_google_cloud_asset_v1_asset_service_proto_enumTypes[0]
}

func (x ContentType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ContentType.Descriptor instead.
func (ContentType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{0}
}

// Export asset request.
type ExportAssetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The relative name of the root asset. This can only be an
	// organization number (such as "organizations/123"), a project ID (such as
	// "projects/my-project-id"), or a project number (such as "projects/12345"),
	// or a folder number (such as "folders/123").
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Timestamp to take an asset snapshot. This can only be set to a timestamp
	// between the current time and the current time minus 35 days (inclusive).
	// If not specified, the current time will be used. Due to delays in resource
	// data collection and indexing, there is a volatile window during which
	// running the same query may get different results.
	ReadTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// A list of asset types of which to take a snapshot for. For example:
	// "compute.googleapis.com/Disk". If specified, only matching assets will be
	// returned. See [Introduction to Cloud Asset
	// Inventory](https://cloud.google.com/asset-inventory/docs/overview)
	// for all supported asset types.
	AssetTypes []string `protobuf:"bytes,3,rep,name=asset_types,json=assetTypes,proto3" json:"asset_types,omitempty"`
	// Asset content type. If not specified, no content but the asset name will be
	// returned.
	ContentType ContentType `protobuf:"varint,4,opt,name=content_type,json=contentType,proto3,enum=google.cloud.asset.v1.ContentType" json:"content_type,omitempty"`
	// Required. Output configuration indicating where the results will be output
	// to. All results will be in newline delimited JSON format.
	OutputConfig *OutputConfig `protobuf:"bytes,5,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
}

func (x *ExportAssetsRequest) Reset() {
	*x = ExportAssetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportAssetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportAssetsRequest) ProtoMessage() {}

func (x *ExportAssetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportAssetsRequest.ProtoReflect.Descriptor instead.
func (*ExportAssetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{0}
}

func (x *ExportAssetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ExportAssetsRequest) GetReadTime() *timestamp.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

func (x *ExportAssetsRequest) GetAssetTypes() []string {
	if x != nil {
		return x.AssetTypes
	}
	return nil
}

func (x *ExportAssetsRequest) GetContentType() ContentType {
	if x != nil {
		return x.ContentType
	}
	return ContentType_CONTENT_TYPE_UNSPECIFIED
}

func (x *ExportAssetsRequest) GetOutputConfig() *OutputConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

// The export asset response. This message is returned by the
// [google.longrunning.Operations.GetOperation][google.longrunning.Operations.GetOperation]
// method in the returned
// [google.longrunning.Operation.response][google.longrunning.Operation.response]
// field.
type ExportAssetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time the snapshot was taken.
	ReadTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// Output configuration indicating where the results were output to.
	// All results are in JSON format.
	OutputConfig *OutputConfig `protobuf:"bytes,2,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
}

func (x *ExportAssetsResponse) Reset() {
	*x = ExportAssetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportAssetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportAssetsResponse) ProtoMessage() {}

func (x *ExportAssetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportAssetsResponse.ProtoReflect.Descriptor instead.
func (*ExportAssetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{1}
}

func (x *ExportAssetsResponse) GetReadTime() *timestamp.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

func (x *ExportAssetsResponse) GetOutputConfig() *OutputConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

// Batch get assets history request.
type BatchGetAssetsHistoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The relative name of the root asset. It can only be an
	// organization number (such as "organizations/123"), a project ID (such as
	// "projects/my-project-id")", or a project number (such as "projects/12345").
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// A list of the full names of the assets. For example:
	// `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
	// See [Resource
	// Names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
	// and [Resource Name
	// Format](https://cloud.google.com/asset-inventory/docs/resource-name-format)
	// for more info.
	//
	// The request becomes a no-op if the asset name list is empty, and the max
	// size of the asset name list is 100 in one request.
	AssetNames []string `protobuf:"bytes,2,rep,name=asset_names,json=assetNames,proto3" json:"asset_names,omitempty"`
	// Optional. The content type.
	ContentType ContentType `protobuf:"varint,3,opt,name=content_type,json=contentType,proto3,enum=google.cloud.asset.v1.ContentType" json:"content_type,omitempty"`
	// Optional. The time window for the asset history. Both start_time and
	// end_time are optional and if set, it must be after the current time minus
	// 35 days. If end_time is not set, it is default to current timestamp.
	// If start_time is not set, the snapshot of the assets at end_time will be
	// returned. The returned results contain all temporal assets whose time
	// window overlap with read_time_window.
	ReadTimeWindow *TimeWindow `protobuf:"bytes,4,opt,name=read_time_window,json=readTimeWindow,proto3" json:"read_time_window,omitempty"`
}

func (x *BatchGetAssetsHistoryRequest) Reset() {
	*x = BatchGetAssetsHistoryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchGetAssetsHistoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetAssetsHistoryRequest) ProtoMessage() {}

func (x *BatchGetAssetsHistoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetAssetsHistoryRequest.ProtoReflect.Descriptor instead.
func (*BatchGetAssetsHistoryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{2}
}

func (x *BatchGetAssetsHistoryRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchGetAssetsHistoryRequest) GetAssetNames() []string {
	if x != nil {
		return x.AssetNames
	}
	return nil
}

func (x *BatchGetAssetsHistoryRequest) GetContentType() ContentType {
	if x != nil {
		return x.ContentType
	}
	return ContentType_CONTENT_TYPE_UNSPECIFIED
}

func (x *BatchGetAssetsHistoryRequest) GetReadTimeWindow() *TimeWindow {
	if x != nil {
		return x.ReadTimeWindow
	}
	return nil
}

// Batch get assets history response.
type BatchGetAssetsHistoryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of assets with valid time windows.
	Assets []*TemporalAsset `protobuf:"bytes,1,rep,name=assets,proto3" json:"assets,omitempty"`
}

func (x *BatchGetAssetsHistoryResponse) Reset() {
	*x = BatchGetAssetsHistoryResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchGetAssetsHistoryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetAssetsHistoryResponse) ProtoMessage() {}

func (x *BatchGetAssetsHistoryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetAssetsHistoryResponse.ProtoReflect.Descriptor instead.
func (*BatchGetAssetsHistoryResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{3}
}

func (x *BatchGetAssetsHistoryResponse) GetAssets() []*TemporalAsset {
	if x != nil {
		return x.Assets
	}
	return nil
}

// Create asset feed request.
type CreateFeedRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project/folder/organization where this feed
	// should be created in. It can only be an organization number (such as
	// "organizations/123"), a folder number (such as "folders/123"), a project ID
	// (such as "projects/my-project-id")", or a project number (such as
	// "projects/12345").
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. This is the client-assigned asset feed identifier and it needs to
	// be unique under a specific parent project/folder/organization.
	FeedId string `protobuf:"bytes,2,opt,name=feed_id,json=feedId,proto3" json:"feed_id,omitempty"`
	// Required. The feed details. The field `name` must be empty and it will be
	// generated in the format of: projects/project_number/feeds/feed_id
	// folders/folder_number/feeds/feed_id
	// organizations/organization_number/feeds/feed_id
	Feed *Feed `protobuf:"bytes,3,opt,name=feed,proto3" json:"feed,omitempty"`
}

func (x *CreateFeedRequest) Reset() {
	*x = CreateFeedRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateFeedRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateFeedRequest) ProtoMessage() {}

func (x *CreateFeedRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateFeedRequest.ProtoReflect.Descriptor instead.
func (*CreateFeedRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{4}
}

func (x *CreateFeedRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateFeedRequest) GetFeedId() string {
	if x != nil {
		return x.FeedId
	}
	return ""
}

func (x *CreateFeedRequest) GetFeed() *Feed {
	if x != nil {
		return x.Feed
	}
	return nil
}

// Get asset feed request.
type GetFeedRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Feed and it must be in the format of:
	// projects/project_number/feeds/feed_id
	// folders/folder_number/feeds/feed_id
	// organizations/organization_number/feeds/feed_id
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetFeedRequest) Reset() {
	*x = GetFeedRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetFeedRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFeedRequest) ProtoMessage() {}

func (x *GetFeedRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFeedRequest.ProtoReflect.Descriptor instead.
func (*GetFeedRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{5}
}

func (x *GetFeedRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// List asset feeds request.
type ListFeedsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent project/folder/organization whose feeds are to be
	// listed. It can only be using project/folder/organization number (such as
	// "folders/12345")", or a project ID (such as "projects/my-project-id").
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *ListFeedsRequest) Reset() {
	*x = ListFeedsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFeedsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFeedsRequest) ProtoMessage() {}

func (x *ListFeedsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFeedsRequest.ProtoReflect.Descriptor instead.
func (*ListFeedsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{6}
}

func (x *ListFeedsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

type ListFeedsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of feeds.
	Feeds []*Feed `protobuf:"bytes,1,rep,name=feeds,proto3" json:"feeds,omitempty"`
}

func (x *ListFeedsResponse) Reset() {
	*x = ListFeedsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFeedsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFeedsResponse) ProtoMessage() {}

func (x *ListFeedsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFeedsResponse.ProtoReflect.Descriptor instead.
func (*ListFeedsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{7}
}

func (x *ListFeedsResponse) GetFeeds() []*Feed {
	if x != nil {
		return x.Feeds
	}
	return nil
}

// Update asset feed request.
type UpdateFeedRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The new values of feed details. It must match an existing feed
	// and the field `name` must be in the format of:
	// projects/project_number/feeds/feed_id or
	// folders/folder_number/feeds/feed_id or
	// organizations/organization_number/feeds/feed_id.
	Feed *Feed `protobuf:"bytes,1,opt,name=feed,proto3" json:"feed,omitempty"`
	// Required. Only updates the `feed` fields indicated by this mask.
	// The field mask must not be empty, and it must not contain fields that
	// are immutable or only set by the server.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateFeedRequest) Reset() {
	*x = UpdateFeedRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateFeedRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateFeedRequest) ProtoMessage() {}

func (x *UpdateFeedRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateFeedRequest.ProtoReflect.Descriptor instead.
func (*UpdateFeedRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{8}
}

func (x *UpdateFeedRequest) GetFeed() *Feed {
	if x != nil {
		return x.Feed
	}
	return nil
}

func (x *UpdateFeedRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

type DeleteFeedRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the feed and it must be in the format of:
	// projects/project_number/feeds/feed_id
	// folders/folder_number/feeds/feed_id
	// organizations/organization_number/feeds/feed_id
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteFeedRequest) Reset() {
	*x = DeleteFeedRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteFeedRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteFeedRequest) ProtoMessage() {}

func (x *DeleteFeedRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteFeedRequest.ProtoReflect.Descriptor instead.
func (*DeleteFeedRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{9}
}

func (x *DeleteFeedRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Output configuration for export assets destination.
type OutputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Asset export destination.
	//
	// Types that are assignable to Destination:
	//	*OutputConfig_GcsDestination
	//	*OutputConfig_BigqueryDestination
	Destination isOutputConfig_Destination `protobuf_oneof:"destination"`
}

func (x *OutputConfig) Reset() {
	*x = OutputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutputConfig) ProtoMessage() {}

func (x *OutputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutputConfig.ProtoReflect.Descriptor instead.
func (*OutputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{10}
}

func (m *OutputConfig) GetDestination() isOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *OutputConfig) GetGcsDestination() *GcsDestination {
	if x, ok := x.GetDestination().(*OutputConfig_GcsDestination); ok {
		return x.GcsDestination
	}
	return nil
}

func (x *OutputConfig) GetBigqueryDestination() *BigQueryDestination {
	if x, ok := x.GetDestination().(*OutputConfig_BigqueryDestination); ok {
		return x.BigqueryDestination
	}
	return nil
}

type isOutputConfig_Destination interface {
	isOutputConfig_Destination()
}

type OutputConfig_GcsDestination struct {
	// Destination on Cloud Storage.
	GcsDestination *GcsDestination `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3,oneof"`
}

type OutputConfig_BigqueryDestination struct {
	// Destination on BigQuery. The output table stores the fields in asset
	// proto as columns in BigQuery. The resource/iam_policy field is converted
	// to a record with each field to a column, except metadata to a single JSON
	// string.
	BigqueryDestination *BigQueryDestination `protobuf:"bytes,2,opt,name=bigquery_destination,json=bigqueryDestination,proto3,oneof"`
}

func (*OutputConfig_GcsDestination) isOutputConfig_Destination() {}

func (*OutputConfig_BigqueryDestination) isOutputConfig_Destination() {}

// A Cloud Storage location.
type GcsDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	//
	// Types that are assignable to ObjectUri:
	//	*GcsDestination_Uri
	//	*GcsDestination_UriPrefix
	ObjectUri isGcsDestination_ObjectUri `protobuf_oneof:"object_uri"`
}

func (x *GcsDestination) Reset() {
	*x = GcsDestination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcsDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsDestination) ProtoMessage() {}

func (x *GcsDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsDestination.ProtoReflect.Descriptor instead.
func (*GcsDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{11}
}

func (m *GcsDestination) GetObjectUri() isGcsDestination_ObjectUri {
	if m != nil {
		return m.ObjectUri
	}
	return nil
}

func (x *GcsDestination) GetUri() string {
	if x, ok := x.GetObjectUri().(*GcsDestination_Uri); ok {
		return x.Uri
	}
	return ""
}

func (x *GcsDestination) GetUriPrefix() string {
	if x, ok := x.GetObjectUri().(*GcsDestination_UriPrefix); ok {
		return x.UriPrefix
	}
	return ""
}

type isGcsDestination_ObjectUri interface {
	isGcsDestination_ObjectUri()
}

type GcsDestination_Uri struct {
	// The uri of the Cloud Storage object. It's the same uri that is used by
	// gsutil. For example: "gs://bucket_name/object_name". See [Viewing and
	// Editing Object
	// Metadata](https://cloud.google.com/storage/docs/viewing-editing-metadata)
	// for more information.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3,oneof"`
}

type GcsDestination_UriPrefix struct {
	// The uri prefix of all generated Cloud Storage objects. For example:
	// "gs://bucket_name/object_name_prefix". Each object uri is in format:
	// "gs://bucket_name/object_name_prefix/<asset type>/<shard number> and only
	// contains assets for that type. <shard number> starts from 0. For example:
	// "gs://bucket_name/object_name_prefix/compute.googleapis.com/Disk/0" is
	// the first shard of output objects containing all
	// compute.googleapis.com/Disk assets. An INVALID_ARGUMENT error will be
	// returned if file with the same name "gs://bucket_name/object_name_prefix"
	// already exists.
	UriPrefix string `protobuf:"bytes,2,opt,name=uri_prefix,json=uriPrefix,proto3,oneof"`
}

func (*GcsDestination_Uri) isGcsDestination_ObjectUri() {}

func (*GcsDestination_UriPrefix) isGcsDestination_ObjectUri() {}

// A BigQuery destination.
type BigQueryDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The BigQuery dataset in format
	// "projects/projectId/datasets/datasetId", to which the snapshot result
	// should be exported. If this dataset does not exist, the export call returns
	// an INVALID_ARGUMENT error.
	Dataset string `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// Required. The BigQuery table to which the snapshot result should be
	// written. If this table does not exist, a new table with the given name
	// will be created.
	Table string `protobuf:"bytes,2,opt,name=table,proto3" json:"table,omitempty"`
	// If the destination table already exists and this flag is `TRUE`, the
	// table will be overwritten by the contents of assets snapshot. If the flag
	// is `FALSE` or unset and the destination table already exists, the export
	// call returns an INVALID_ARGUMEMT error.
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *BigQueryDestination) Reset() {
	*x = BigQueryDestination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryDestination) ProtoMessage() {}

func (x *BigQueryDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryDestination.ProtoReflect.Descriptor instead.
func (*BigQueryDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{12}
}

func (x *BigQueryDestination) GetDataset() string {
	if x != nil {
		return x.Dataset
	}
	return ""
}

func (x *BigQueryDestination) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *BigQueryDestination) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// A Pub/Sub destination.
type PubsubDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the Pub/Sub topic to publish to.
	// For example: `projects/PROJECT_ID/topics/TOPIC_ID`.
	Topic string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
}

func (x *PubsubDestination) Reset() {
	*x = PubsubDestination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PubsubDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PubsubDestination) ProtoMessage() {}

func (x *PubsubDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PubsubDestination.ProtoReflect.Descriptor instead.
func (*PubsubDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{13}
}

func (x *PubsubDestination) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

// Output configuration for asset feed destination.
type FeedOutputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Asset feed destination.
	//
	// Types that are assignable to Destination:
	//	*FeedOutputConfig_PubsubDestination
	Destination isFeedOutputConfig_Destination `protobuf_oneof:"destination"`
}

func (x *FeedOutputConfig) Reset() {
	*x = FeedOutputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FeedOutputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeedOutputConfig) ProtoMessage() {}

func (x *FeedOutputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeedOutputConfig.ProtoReflect.Descriptor instead.
func (*FeedOutputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{14}
}

func (m *FeedOutputConfig) GetDestination() isFeedOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *FeedOutputConfig) GetPubsubDestination() *PubsubDestination {
	if x, ok := x.GetDestination().(*FeedOutputConfig_PubsubDestination); ok {
		return x.PubsubDestination
	}
	return nil
}

type isFeedOutputConfig_Destination interface {
	isFeedOutputConfig_Destination()
}

type FeedOutputConfig_PubsubDestination struct {
	// Destination on Pub/Sub.
	PubsubDestination *PubsubDestination `protobuf:"bytes,1,opt,name=pubsub_destination,json=pubsubDestination,proto3,oneof"`
}

func (*FeedOutputConfig_PubsubDestination) isFeedOutputConfig_Destination() {}

// An asset feed used to export asset updates to a destinations.
// An asset feed filter controls what updates are exported.
// The asset feed must be created within a project, organization, or
// folder. Supported destinations are:
// Pub/Sub topics.
type Feed struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The format will be
	// projects/{project_number}/feeds/{client-assigned_feed_identifier} or
	// folders/{folder_number}/feeds/{client-assigned_feed_identifier} or
	// organizations/{organization_number}/feeds/{client-assigned_feed_identifier}
	//
	// The client-assigned feed identifier must be unique within the parent
	// project/folder/organization.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A list of the full names of the assets to receive updates. You must specify
	// either or both of asset_names and asset_types. Only asset updates matching
	// specified asset_names and asset_types are exported to the feed. For
	// example:
	// `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
	// See [Resource
	// Names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
	// for more info.
	AssetNames []string `protobuf:"bytes,2,rep,name=asset_names,json=assetNames,proto3" json:"asset_names,omitempty"`
	// A list of types of the assets to receive updates. You must specify either
	// or both of asset_names and asset_types. Only asset updates matching
	// specified asset_names and asset_types are exported to the feed.
	// For example: `"compute.googleapis.com/Disk"`
	//
	// See [this
	// topic](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
	// for a list of all supported asset types.
	AssetTypes []string `protobuf:"bytes,3,rep,name=asset_types,json=assetTypes,proto3" json:"asset_types,omitempty"`
	// Asset content type. If not specified, no content but the asset name and
	// type will be returned.
	ContentType ContentType `protobuf:"varint,4,opt,name=content_type,json=contentType,proto3,enum=google.cloud.asset.v1.ContentType" json:"content_type,omitempty"`
	// Required. Feed output configuration defining where the asset updates are
	// published to.
	FeedOutputConfig *FeedOutputConfig `protobuf:"bytes,5,opt,name=feed_output_config,json=feedOutputConfig,proto3" json:"feed_output_config,omitempty"`
}

func (x *Feed) Reset() {
	*x = Feed{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Feed) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Feed) ProtoMessage() {}

func (x *Feed) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Feed.ProtoReflect.Descriptor instead.
func (*Feed) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{15}
}

func (x *Feed) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Feed) GetAssetNames() []string {
	if x != nil {
		return x.AssetNames
	}
	return nil
}

func (x *Feed) GetAssetTypes() []string {
	if x != nil {
		return x.AssetTypes
	}
	return nil
}

func (x *Feed) GetContentType() ContentType {
	if x != nil {
		return x.ContentType
	}
	return ContentType_CONTENT_TYPE_UNSPECIFIED
}

func (x *Feed) GetFeedOutputConfig() *FeedOutputConfig {
	if x != nil {
		return x.FeedOutputConfig
	}
	return nil
}

// Search all resources request.
type SearchAllResourcesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A scope can be a project, a folder or an organization. The search
	// is limited to the resources within the `scope`.
	//
	// The allowed values are:
	//
	// * projects/{PROJECT_ID}
	// * projects/{PROJECT_NUMBER}
	// * folders/{FOLDER_NUMBER}
	// * organizations/{ORGANIZATION_NUMBER}
	Scope string `protobuf:"bytes,1,opt,name=scope,proto3" json:"scope,omitempty"`
	// Optional. The query statement. An empty query can be specified to search
	// all the resources of certain `asset_types` within the given `scope`.
	//
	// Examples:
	//
	// * `name : "Important"` to find Cloud resources whose name contains
	//   "Important" as a word.
	// * `displayName : "Impor*"` to find Cloud resources whose display name
	//   contains "Impor" as a word prefix.
	// * `description : "*por*"` to find Cloud resources whose description
	//   contains "por" as a substring.
	// * `location : "us-west*"` to find Cloud resources whose location is
	//   prefixed with "us-west".
	// * `labels : "prod"` to find Cloud resources whose labels contain "prod" as
	//   a key or value.
	// * `labels.env : "prod"` to find Cloud resources which have a label "env"
	//   and its value is "prod".
	// * `labels.env : *` to find Cloud resources which have a label "env".
	// * `"Important"` to find Cloud resources which contain "Important" as a word
	//   in any of the searchable fields.
	// * `"Impor*"` to find Cloud resources which contain "Impor" as a word prefix
	//   in any of the searchable fields.
	// * `"*por*"` to find Cloud resources which contain "por" as a substring in
	//   any of the searchable fields.
	// * `("Important" AND location : ("us-west1" OR "global"))` to find Cloud
	//   resources which contain "Important" as a word in any of the searchable
	//   fields and are also located in the "us-west1" region or the "global"
	//   location.
	//
	// See [how to construct a
	// query](https://cloud.google.com/asset-inventory/docs/searching-resources#how_to_construct_a_query)
	// for more details.
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Optional. A list of asset types that this request searches for. If empty,
	// it will search all the [searchable asset
	// types](https://cloud.google.com/asset-inventory/docs/supported-asset-types#searchable_asset_types).
	AssetTypes []string `protobuf:"bytes,3,rep,name=asset_types,json=assetTypes,proto3" json:"asset_types,omitempty"`
	// Optional. The page size for search result pagination. Page size is capped
	// at 500 even if a larger value is given. If set to zero, server will pick an
	// appropriate default. Returned results may be fewer than requested. When
	// this happens, there could be more results as long as `next_page_token` is
	// returned.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. If present, then retrieve the next batch of results from the
	// preceding call to this method. `page_token` must be the value of
	// `next_page_token` from the previous response. The values of all other
	// method parameters, must be identical to those in the previous call.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. A comma separated list of fields specifying the sorting order of
	// the results. The default order is ascending. Add " DESC" after the field
	// name to indicate descending order. Redundant space characters are ignored.
	// Example: "location DESC, name". See [supported resource metadata
	// fields](https://cloud.google.com/asset-inventory/docs/searching-resources#query_on_resource_metadata_fields)
	// for more details.
	OrderBy string `protobuf:"bytes,6,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *SearchAllResourcesRequest) Reset() {
	*x = SearchAllResourcesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchAllResourcesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchAllResourcesRequest) ProtoMessage() {}

func (x *SearchAllResourcesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchAllResourcesRequest.ProtoReflect.Descriptor instead.
func (*SearchAllResourcesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{16}
}

func (x *SearchAllResourcesRequest) GetScope() string {
	if x != nil {
		return x.Scope
	}
	return ""
}

func (x *SearchAllResourcesRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchAllResourcesRequest) GetAssetTypes() []string {
	if x != nil {
		return x.AssetTypes
	}
	return nil
}

func (x *SearchAllResourcesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchAllResourcesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SearchAllResourcesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Search all resources response.
type SearchAllResourcesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of Resources that match the search query. It contains the resource
	// standard metadata information.
	Results []*ResourceSearchResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// If there are more results than those appearing in this response, then
	// `next_page_token` is included. To get the next set of results, call this
	// method again using the value of `next_page_token` as `page_token`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchAllResourcesResponse) Reset() {
	*x = SearchAllResourcesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchAllResourcesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchAllResourcesResponse) ProtoMessage() {}

func (x *SearchAllResourcesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchAllResourcesResponse.ProtoReflect.Descriptor instead.
func (*SearchAllResourcesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{17}
}

func (x *SearchAllResourcesResponse) GetResults() []*ResourceSearchResult {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *SearchAllResourcesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Search all IAM policies request.
type SearchAllIamPoliciesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A scope can be a project, a folder or an organization. The search
	// is limited to the IAM policies within the `scope`.
	//
	// The allowed values are:
	//
	// * projects/{PROJECT_ID}
	// * projects/{PROJECT_NUMBER}
	// * folders/{FOLDER_NUMBER}
	// * organizations/{ORGANIZATION_NUMBER}
	Scope string `protobuf:"bytes,1,opt,name=scope,proto3" json:"scope,omitempty"`
	// Optional. The query statement. An empty query can be specified to search
	// all the IAM policies within the given `scope`.
	//
	// Examples:
	//
	// * `policy : "amy@gmail.com"` to find Cloud IAM policy bindings that
	//   specify user "amy@gmail.com".
	// * `policy : "roles/compute.admin"` to find Cloud IAM policy bindings that
	//   specify the Compute Admin role.
	// * `policy.role.permissions : "storage.buckets.update"` to find Cloud IAM
	//   policy bindings that specify a role containing "storage.buckets.update"
	//   permission.
	// * `resource : "organizations/123"` to find Cloud IAM policy bindings that
	//   are set on "organizations/123".
	// * `(resource : ("organizations/123" OR "folders/1234") AND policy : "amy")`
	//   to find Cloud IAM policy bindings that are set on "organizations/123" or
	//   "folders/1234", and also specify user "amy".
	//
	// See [how to construct a
	// query](https://cloud.google.com/asset-inventory/docs/searching-iam-policies#how_to_construct_a_query)
	// for more details.
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Optional. The page size for search result pagination. Page size is capped
	// at 500 even if a larger value is given. If set to zero, server will pick an
	// appropriate default. Returned results may be fewer than requested. When
	// this happens, there could be more results as long as `next_page_token` is
	// returned.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. If present, retrieve the next batch of results from the preceding
	// call to this method. `page_token` must be the value of `next_page_token`
	// from the previous response. The values of all other method parameters must
	// be identical to those in the previous call.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *SearchAllIamPoliciesRequest) Reset() {
	*x = SearchAllIamPoliciesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchAllIamPoliciesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchAllIamPoliciesRequest) ProtoMessage() {}

func (x *SearchAllIamPoliciesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchAllIamPoliciesRequest.ProtoReflect.Descriptor instead.
func (*SearchAllIamPoliciesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{18}
}

func (x *SearchAllIamPoliciesRequest) GetScope() string {
	if x != nil {
		return x.Scope
	}
	return ""
}

func (x *SearchAllIamPoliciesRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchAllIamPoliciesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchAllIamPoliciesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Search all IAM policies response.
type SearchAllIamPoliciesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of IamPolicy that match the search query. Related information such
	// as the associated resource is returned along with the policy.
	Results []*IamPolicySearchResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// Set if there are more results than those appearing in this response; to get
	// the next set of results, call this method again, using this value as the
	// `page_token`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchAllIamPoliciesResponse) Reset() {
	*x = SearchAllIamPoliciesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchAllIamPoliciesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchAllIamPoliciesResponse) ProtoMessage() {}

func (x *SearchAllIamPoliciesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchAllIamPoliciesResponse.ProtoReflect.Descriptor instead.
func (*SearchAllIamPoliciesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{19}
}

func (x *SearchAllIamPoliciesResponse) GetResults() []*IamPolicySearchResult {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *SearchAllIamPoliciesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_google_cloud_asset_v1_asset_service_proto protoreflect.FileDescriptor

var file_google_cloud_asset_v1_asset_service_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x15, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e,
	0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x65, 0x78, 0x70, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc6, 0x02, 0x0a, 0x13, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x12, 0x1f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x37, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08,
	0x72, 0x65, 0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x45, 0x0a, 0x0c, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x4d, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22,
	0x99, 0x01, 0x0a, 0x14, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x48, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x9e, 0x02, 0x0a, 0x1c,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x48, 0x69,
	0x73, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x21, 0x12, 0x1f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1f, 0x0a,
	0x0b, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0a, 0x61, 0x73, 0x73, 0x65, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x4a,
	0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x50, 0x0a, 0x10, 0x72, 0x65,
	0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x72, 0x65,
	0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x22, 0x5d, 0x0a, 0x1d,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x48, 0x69,
	0x73, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3c, 0x0a,
	0x06, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x52, 0x06, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x22, 0x84, 0x01, 0x0a, 0x11,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x65, 0x65, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1c,
	0x0a, 0x07, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x66, 0x65, 0x65, 0x64, 0x49, 0x64, 0x12, 0x34, 0x0a, 0x04,
	0x66, 0x65, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x46, 0x65, 0x65, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x66, 0x65,
	0x65, 0x64, 0x22, 0x4c, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x46, 0x65, 0x65, 0x64, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x65, 0x64, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x2f, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x65, 0x65, 0x64, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x22, 0x46, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x65, 0x65, 0x64, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x31, 0x0a, 0x05, 0x66, 0x65, 0x65, 0x64, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65,
	0x65, 0x64, 0x52, 0x05, 0x66, 0x65, 0x65, 0x64, 0x73, 0x22, 0x8b, 0x01, 0x0a, 0x11, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x46, 0x65, 0x65, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x34, 0x0a, 0x04, 0x66, 0x65, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x65, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x04, 0x66, 0x65, 0x65, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x4f, 0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x46, 0x65, 0x65, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65,
	0x65, 0x64, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd0, 0x01, 0x0a, 0x0c, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x50, 0x0a, 0x0f, 0x67, 0x63, 0x73,
	0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x63, 0x73, 0x44, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0e, 0x67, 0x63, 0x73,
	0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5f, 0x0a, 0x14, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x13, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0d, 0x0a, 0x0b,
	0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x53, 0x0a, 0x0e, 0x47,
	0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a,
	0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x03, 0x75, 0x72,
	0x69, 0x12, 0x1f, 0x0a, 0x0a, 0x75, 0x72, 0x69, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x75, 0x72, 0x69, 0x50, 0x72, 0x65, 0x66,
	0x69, 0x78, 0x42, 0x0c, 0x0a, 0x0a, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x75, 0x72, 0x69,
	0x22, 0x65, 0x0a, 0x13, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0x29, 0x0a, 0x11, 0x50, 0x75, 0x62, 0x73, 0x75,
	0x62, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05,
	0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x70,
	0x69, 0x63, 0x22, 0x7c, 0x0a, 0x10, 0x46, 0x65, 0x65, 0x64, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x59, 0x0a, 0x12, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62,
	0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x73, 0x75,
	0x62, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x11,
	0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x98, 0x03, 0x0a, 0x04, 0x46, 0x65, 0x65, 0x64, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x73, 0x73, 0x65, 0x74, 0x4e, 0x61,
	0x6d, 0x65, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x73, 0x73, 0x65, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x73, 0x12, 0x45, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x5a, 0x0a, 0x12, 0x66,
	0x65, 0x65, 0x64, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x46, 0x65, 0x65, 0x64, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x66, 0x65, 0x65, 0x64, 0x4f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x3a, 0x91, 0x01, 0xea, 0x41, 0x8d, 0x01, 0x0a, 0x1e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x65, 0x64, 0x12, 0x1f,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x66, 0x65, 0x65, 0x64, 0x73, 0x2f, 0x7b, 0x66, 0x65, 0x65, 0x64, 0x7d, 0x12,
	0x1d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x7d, 0x2f, 0x66, 0x65, 0x65, 0x64, 0x73, 0x2f, 0x7b, 0x66, 0x65, 0x65, 0x64, 0x7d, 0x12, 0x29,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x66, 0x65, 0x65,
	0x64, 0x73, 0x2f, 0x7b, 0x66, 0x65, 0x65, 0x64, 0x7d, 0x20, 0x01, 0x22, 0xdd, 0x01, 0x0a, 0x19,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x19, 0x0a, 0x05, 0x73, 0x63, 0x6f,
	0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73,
	0x63, 0x6f, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12,
	0x24, 0x0a, 0x0b, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1e, 0x0a, 0x08, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0x8b, 0x01, 0x0a, 0x1a,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x07, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x99, 0x01, 0x0a, 0x1b, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x41, 0x6c, 0x6c, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x19, 0x0a, 0x05, 0x73, 0x63, 0x6f,
	0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73,
	0x63, 0x6f, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12,
	0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8e, 0x01, 0x0a, 0x1c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x41, 0x6c, 0x6c, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x46, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x2a, 0x6c, 0x0a, 0x0b, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x43, 0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x10,
	0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x49, 0x41, 0x4d, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x10,
	0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x4f, 0x52, 0x47, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x10,
	0x04, 0x12, 0x11, 0x0a, 0x0d, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x50, 0x4f, 0x4c, 0x49,
	0x43, 0x59, 0x10, 0x05, 0x32, 0xf0, 0x0b, 0x0a, 0x0c, 0x41, 0x73, 0x73, 0x65, 0x74, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xde, 0x01, 0x0a, 0x0c, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x12, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x82, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x22, 0x22, 0x1d, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x3a, 0x65, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x3a, 0x01, 0x2a, 0xca, 0x41, 0x57, 0x0a,
	0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x29, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0xb2, 0x01, 0x0a, 0x15, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x47, 0x65, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79,
	0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65,
	0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61,
	0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x48, 0x69, 0x73, 0x74,
	0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x2e, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x28, 0x12, 0x26, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x73, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x7f, 0x0a, 0x0a, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x65, 0x65, 0x64, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x65, 0x65, 0x64, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x65, 0x64,
	0x22, 0x2a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1b, 0x22, 0x16, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x65, 0x65, 0x64, 0x73,
	0x3a, 0x01, 0x2a, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x74, 0x0a, 0x07,
	0x47, 0x65, 0x74, 0x46, 0x65, 0x65, 0x64, 0x12, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x46, 0x65, 0x65, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x65, 0x64, 0x22, 0x25, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x18, 0x12, 0x16, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x2a,
	0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x65, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x87, 0x01, 0x0a, 0x09, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x65, 0x65, 0x64, 0x73,
	0x12, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x65, 0x65,
	0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x65, 0x65, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x27, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x18, 0x12, 0x16, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x65,
	0x65, 0x64, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x82, 0x01, 0x0a,
	0x0a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x65, 0x65, 0x64, 0x12, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x65, 0x65, 0x64, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65,
	0x65, 0x64, 0x22, 0x2d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x20, 0x32, 0x1b, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x66, 0x65, 0x65, 0x64, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x2a, 0x2f, 0x2a, 0x2f, 0x66,
	0x65, 0x65, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x01, 0x2a, 0xda, 0x41, 0x04, 0x66, 0x65, 0x65,
	0x64, 0x12, 0x75, 0x0a, 0x0a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x65, 0x65, 0x64, 0x12,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x65,
	0x65, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x22, 0x25, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x18, 0x2a, 0x16, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x2a, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x65, 0x64, 0x73, 0x2f, 0x2a,
	0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xbf, 0x01, 0x0a, 0x12, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6c,
	0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x41, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x44, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x24, 0x12, 0x22, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0xda, 0x41, 0x17, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x2c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2c, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x12, 0xbb, 0x01, 0x0a, 0x14, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6c, 0x6c, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x69, 0x65, 0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x41, 0x6c, 0x6c, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6c, 0x6c, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3a, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x26, 0x12, 0x24, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x63, 0x6f, 0x70, 0x65,
	0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6c, 0x6c, 0x49,
	0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0xda, 0x41, 0x0b, 0x73, 0x63, 0x6f,
	0x70, 0x65, 0x2c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x1a, 0x4d, 0xca, 0x41, 0x19, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
	0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x9c, 0x01, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x2e, 0x76, 0x31, 0x42, 0x11, 0x41, 0x73, 0x73, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3a, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65,
	0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2f, 0x76, 0x31,
	0x3b, 0x61, 0x73, 0x73, 0x65, 0x74, 0xaa, 0x02, 0x15, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x56, 0x31, 0xca, 0x02,
	0x15, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x5c, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_asset_v1_asset_service_proto_rawDescOnce sync.Once
	file_google_cloud_asset_v1_asset_service_proto_rawDescData = file_google_cloud_asset_v1_asset_service_proto_rawDesc
)

func file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP() []byte {
	file_google_cloud_asset_v1_asset_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_asset_v1_asset_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_asset_v1_asset_service_proto_rawDescData)
	})
	return file_google_cloud_asset_v1_asset_service_proto_rawDescData
}

var file_google_cloud_asset_v1_asset_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_asset_v1_asset_service_proto_msgTypes = make([]protoimpl.MessageInfo, 20)
var file_google_cloud_asset_v1_asset_service_proto_goTypes = []interface{}{
	(ContentType)(0),                      // 0: google.cloud.asset.v1.ContentType
	(*ExportAssetsRequest)(nil),           // 1: google.cloud.asset.v1.ExportAssetsRequest
	(*ExportAssetsResponse)(nil),          // 2: google.cloud.asset.v1.ExportAssetsResponse
	(*BatchGetAssetsHistoryRequest)(nil),  // 3: google.cloud.asset.v1.BatchGetAssetsHistoryRequest
	(*BatchGetAssetsHistoryResponse)(nil), // 4: google.cloud.asset.v1.BatchGetAssetsHistoryResponse
	(*CreateFeedRequest)(nil),             // 5: google.cloud.asset.v1.CreateFeedRequest
	(*GetFeedRequest)(nil),                // 6: google.cloud.asset.v1.GetFeedRequest
	(*ListFeedsRequest)(nil),              // 7: google.cloud.asset.v1.ListFeedsRequest
	(*ListFeedsResponse)(nil),             // 8: google.cloud.asset.v1.ListFeedsResponse
	(*UpdateFeedRequest)(nil),             // 9: google.cloud.asset.v1.UpdateFeedRequest
	(*DeleteFeedRequest)(nil),             // 10: google.cloud.asset.v1.DeleteFeedRequest
	(*OutputConfig)(nil),                  // 11: google.cloud.asset.v1.OutputConfig
	(*GcsDestination)(nil),                // 12: google.cloud.asset.v1.GcsDestination
	(*BigQueryDestination)(nil),           // 13: google.cloud.asset.v1.BigQueryDestination
	(*PubsubDestination)(nil),             // 14: google.cloud.asset.v1.PubsubDestination
	(*FeedOutputConfig)(nil),              // 15: google.cloud.asset.v1.FeedOutputConfig
	(*Feed)(nil),                          // 16: google.cloud.asset.v1.Feed
	(*SearchAllResourcesRequest)(nil),     // 17: google.cloud.asset.v1.SearchAllResourcesRequest
	(*SearchAllResourcesResponse)(nil),    // 18: google.cloud.asset.v1.SearchAllResourcesResponse
	(*SearchAllIamPoliciesRequest)(nil),   // 19: google.cloud.asset.v1.SearchAllIamPoliciesRequest
	(*SearchAllIamPoliciesResponse)(nil),  // 20: google.cloud.asset.v1.SearchAllIamPoliciesResponse
	(*timestamp.Timestamp)(nil),           // 21: google.protobuf.Timestamp
	(*TimeWindow)(nil),                    // 22: google.cloud.asset.v1.TimeWindow
	(*TemporalAsset)(nil),                 // 23: google.cloud.asset.v1.TemporalAsset
	(*field_mask.FieldMask)(nil),          // 24: google.protobuf.FieldMask
	(*ResourceSearchResult)(nil),          // 25: google.cloud.asset.v1.ResourceSearchResult
	(*IamPolicySearchResult)(nil),         // 26: google.cloud.asset.v1.IamPolicySearchResult
	(*longrunning.Operation)(nil),         // 27: google.longrunning.Operation
	(*empty.Empty)(nil),                   // 28: google.protobuf.Empty
}
var file_google_cloud_asset_v1_asset_service_proto_depIdxs = []int32{
	21, // 0: google.cloud.asset.v1.ExportAssetsRequest.read_time:type_name -> google.protobuf.Timestamp
	0,  // 1: google.cloud.asset.v1.ExportAssetsRequest.content_type:type_name -> google.cloud.asset.v1.ContentType
	11, // 2: google.cloud.asset.v1.ExportAssetsRequest.output_config:type_name -> google.cloud.asset.v1.OutputConfig
	21, // 3: google.cloud.asset.v1.ExportAssetsResponse.read_time:type_name -> google.protobuf.Timestamp
	11, // 4: google.cloud.asset.v1.ExportAssetsResponse.output_config:type_name -> google.cloud.asset.v1.OutputConfig
	0,  // 5: google.cloud.asset.v1.BatchGetAssetsHistoryRequest.content_type:type_name -> google.cloud.asset.v1.ContentType
	22, // 6: google.cloud.asset.v1.BatchGetAssetsHistoryRequest.read_time_window:type_name -> google.cloud.asset.v1.TimeWindow
	23, // 7: google.cloud.asset.v1.BatchGetAssetsHistoryResponse.assets:type_name -> google.cloud.asset.v1.TemporalAsset
	16, // 8: google.cloud.asset.v1.CreateFeedRequest.feed:type_name -> google.cloud.asset.v1.Feed
	16, // 9: google.cloud.asset.v1.ListFeedsResponse.feeds:type_name -> google.cloud.asset.v1.Feed
	16, // 10: google.cloud.asset.v1.UpdateFeedRequest.feed:type_name -> google.cloud.asset.v1.Feed
	24, // 11: google.cloud.asset.v1.UpdateFeedRequest.update_mask:type_name -> google.protobuf.FieldMask
	12, // 12: google.cloud.asset.v1.OutputConfig.gcs_destination:type_name -> google.cloud.asset.v1.GcsDestination
	13, // 13: google.cloud.asset.v1.OutputConfig.bigquery_destination:type_name -> google.cloud.asset.v1.BigQueryDestination
	14, // 14: google.cloud.asset.v1.FeedOutputConfig.pubsub_destination:type_name -> google.cloud.asset.v1.PubsubDestination
	0,  // 15: google.cloud.asset.v1.Feed.content_type:type_name -> google.cloud.asset.v1.ContentType
	15, // 16: google.cloud.asset.v1.Feed.feed_output_config:type_name -> google.cloud.asset.v1.FeedOutputConfig
	25, // 17: google.cloud.asset.v1.SearchAllResourcesResponse.results:type_name -> google.cloud.asset.v1.ResourceSearchResult
	26, // 18: google.cloud.asset.v1.SearchAllIamPoliciesResponse.results:type_name -> google.cloud.asset.v1.IamPolicySearchResult
	1,  // 19: google.cloud.asset.v1.AssetService.ExportAssets:input_type -> google.cloud.asset.v1.ExportAssetsRequest
	3,  // 20: google.cloud.asset.v1.AssetService.BatchGetAssetsHistory:input_type -> google.cloud.asset.v1.BatchGetAssetsHistoryRequest
	5,  // 21: google.cloud.asset.v1.AssetService.CreateFeed:input_type -> google.cloud.asset.v1.CreateFeedRequest
	6,  // 22: google.cloud.asset.v1.AssetService.GetFeed:input_type -> google.cloud.asset.v1.GetFeedRequest
	7,  // 23: google.cloud.asset.v1.AssetService.ListFeeds:input_type -> google.cloud.asset.v1.ListFeedsRequest
	9,  // 24: google.cloud.asset.v1.AssetService.UpdateFeed:input_type -> google.cloud.asset.v1.UpdateFeedRequest
	10, // 25: google.cloud.asset.v1.AssetService.DeleteFeed:input_type -> google.cloud.asset.v1.DeleteFeedRequest
	17, // 26: google.cloud.asset.v1.AssetService.SearchAllResources:input_type -> google.cloud.asset.v1.SearchAllResourcesRequest
	19, // 27: google.cloud.asset.v1.AssetService.SearchAllIamPolicies:input_type -> google.cloud.asset.v1.SearchAllIamPoliciesRequest
	27, // 28: google.cloud.asset.v1.AssetService.ExportAssets:output_type -> google.longrunning.Operation
	4,  // 29: google.cloud.asset.v1.AssetService.BatchGetAssetsHistory:output_type -> google.cloud.asset.v1.BatchGetAssetsHistoryResponse
	16, // 30: google.cloud.asset.v1.AssetService.CreateFeed:output_type -> google.cloud.asset.v1.Feed
	16, // 31: google.cloud.asset.v1.AssetService.GetFeed:output_type -> google.cloud.asset.v1.Feed
	8,  // 32: google.cloud.asset.v1.AssetService.ListFeeds:output_type -> google.cloud.asset.v1.ListFeedsResponse
	16, // 33: google.cloud.asset.v1.AssetService.UpdateFeed:output_type -> google.cloud.asset.v1.Feed
	28, // 34: google.cloud.asset.v1.AssetService.DeleteFeed:output_type -> google.protobuf.Empty
	18, // 35: google.cloud.asset.v1.AssetService.SearchAllResources:output_type -> google.cloud.asset.v1.SearchAllResourcesResponse
	20, // 36: google.cloud.asset.v1.AssetService.SearchAllIamPolicies:output_type -> google.cloud.asset.v1.SearchAllIamPoliciesResponse
	28, // [28:37] is the sub-list for method output_type
	19, // [19:28] is the sub-list for method input_type
	19, // [19:19] is the sub-list for extension type_name
	19, // [19:19] is the sub-list for extension extendee
	0,  // [0:19] is the sub-list for field type_name
}

func init() { file_google_cloud_asset_v1_asset_service_proto_init() }
func file_google_cloud_asset_v1_asset_service_proto_init() {
	if File_google_cloud_asset_v1_asset_service_proto != nil {
		return
	}
	file_google_cloud_asset_v1_assets_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportAssetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportAssetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchGetAssetsHistoryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BatchGetAssetsHistoryResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateFeedRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetFeedRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFeedsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListFeedsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateFeedRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteFeedRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OutputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GcsDestination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BigQueryDestination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PubsubDestination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FeedOutputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Feed); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchAllResourcesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchAllResourcesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchAllIamPoliciesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchAllIamPoliciesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_asset_v1_asset_service_proto_msgTypes[10].OneofWrappers = []interface{}{
		(*OutputConfig_GcsDestination)(nil),
		(*OutputConfig_BigqueryDestination)(nil),
	}
	file_google_cloud_asset_v1_asset_service_proto_msgTypes[11].OneofWrappers = []interface{}{
		(*GcsDestination_Uri)(nil),
		(*GcsDestination_UriPrefix)(nil),
	}
	file_google_cloud_asset_v1_asset_service_proto_msgTypes[14].OneofWrappers = []interface{}{
		(*FeedOutputConfig_PubsubDestination)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_asset_v1_asset_service_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   20,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_asset_v1_asset_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_asset_v1_asset_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_asset_v1_asset_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_asset_v1_asset_service_proto_msgTypes,
	}.Build()
	File_google_cloud_asset_v1_asset_service_proto = out.File
	file_google_cloud_asset_v1_asset_service_proto_rawDesc = nil
	file_google_cloud_asset_v1_asset_service_proto_goTypes = nil
	file_google_cloud_asset_v1_asset_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AssetServiceClient is the client API for AssetService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AssetServiceClient interface {
	// Exports assets with time and resource types to a given Cloud Storage
	// location. The output format is newline-delimited JSON.
	// This API implements the
	// [google.longrunning.Operation][google.longrunning.Operation] API allowing
	// you to keep track of the export.
	ExportAssets(ctx context.Context, in *ExportAssetsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Batch gets the update history of assets that overlap a time window.
	// For RESOURCE content, this API outputs history with asset in both
	// non-delete or deleted status.
	// For IAM_POLICY content, this API outputs history when the asset and its
	// attached IAM POLICY both exist. This can create gaps in the output history.
	// If a specified asset does not exist, this API returns an INVALID_ARGUMENT
	// error.
	BatchGetAssetsHistory(ctx context.Context, in *BatchGetAssetsHistoryRequest, opts ...grpc.CallOption) (*BatchGetAssetsHistoryResponse, error)
	// Creates a feed in a parent project/folder/organization to listen to its
	// asset updates.
	CreateFeed(ctx context.Context, in *CreateFeedRequest, opts ...grpc.CallOption) (*Feed, error)
	// Gets details about an asset feed.
	GetFeed(ctx context.Context, in *GetFeedRequest, opts ...grpc.CallOption) (*Feed, error)
	// Lists all asset feeds in a parent project/folder/organization.
	ListFeeds(ctx context.Context, in *ListFeedsRequest, opts ...grpc.CallOption) (*ListFeedsResponse, error)
	// Updates an asset feed configuration.
	UpdateFeed(ctx context.Context, in *UpdateFeedRequest, opts ...grpc.CallOption) (*Feed, error)
	// Deletes an asset feed.
	DeleteFeed(ctx context.Context, in *DeleteFeedRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Searches all the resources within the given accessible scope (e.g., a
	// project, a folder or an organization). Callers should have
	// cloud.assets.SearchAllResources permission upon the requested scope,
	// otherwise the request will be rejected.
	SearchAllResources(ctx context.Context, in *SearchAllResourcesRequest, opts ...grpc.CallOption) (*SearchAllResourcesResponse, error)
	// Searches all the IAM policies within the given accessible scope (e.g., a
	// project, a folder or an organization). Callers should have
	// cloud.assets.SearchAllIamPolicies permission upon the requested scope,
	// otherwise the request will be rejected.
	SearchAllIamPolicies(ctx context.Context, in *SearchAllIamPoliciesRequest, opts ...grpc.CallOption) (*SearchAllIamPoliciesResponse, error)
}

type assetServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAssetServiceClient(cc grpc.ClientConnInterface) AssetServiceClient {
	return &assetServiceClient{cc}
}

func (c *assetServiceClient) ExportAssets(ctx context.Context, in *ExportAssetsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/ExportAssets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) BatchGetAssetsHistory(ctx context.Context, in *BatchGetAssetsHistoryRequest, opts ...grpc.CallOption) (*BatchGetAssetsHistoryResponse, error) {
	out := new(BatchGetAssetsHistoryResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/BatchGetAssetsHistory", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) CreateFeed(ctx context.Context, in *CreateFeedRequest, opts ...grpc.CallOption) (*Feed, error) {
	out := new(Feed)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/CreateFeed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) GetFeed(ctx context.Context, in *GetFeedRequest, opts ...grpc.CallOption) (*Feed, error) {
	out := new(Feed)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/GetFeed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) ListFeeds(ctx context.Context, in *ListFeedsRequest, opts ...grpc.CallOption) (*ListFeedsResponse, error) {
	out := new(ListFeedsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/ListFeeds", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) UpdateFeed(ctx context.Context, in *UpdateFeedRequest, opts ...grpc.CallOption) (*Feed, error) {
	out := new(Feed)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/UpdateFeed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) DeleteFeed(ctx context.Context, in *DeleteFeedRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/DeleteFeed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) SearchAllResources(ctx context.Context, in *SearchAllResourcesRequest, opts ...grpc.CallOption) (*SearchAllResourcesResponse, error) {
	out := new(SearchAllResourcesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/SearchAllResources", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) SearchAllIamPolicies(ctx context.Context, in *SearchAllIamPoliciesRequest, opts ...grpc.CallOption) (*SearchAllIamPoliciesResponse, error) {
	out := new(SearchAllIamPoliciesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/SearchAllIamPolicies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AssetServiceServer is the server API for AssetService service.
type AssetServiceServer interface {
	// Exports assets with time and resource types to a given Cloud Storage
	// location. The output format is newline-delimited JSON.
	// This API implements the
	// [google.longrunning.Operation][google.longrunning.Operation] API allowing
	// you to keep track of the export.
	ExportAssets(context.Context, *ExportAssetsRequest) (*longrunning.Operation, error)
	// Batch gets the update history of assets that overlap a time window.
	// For RESOURCE content, this API outputs history with asset in both
	// non-delete or deleted status.
	// For IAM_POLICY content, this API outputs history when the asset and its
	// attached IAM POLICY both exist. This can create gaps in the output history.
	// If a specified asset does not exist, this API returns an INVALID_ARGUMENT
	// error.
	BatchGetAssetsHistory(context.Context, *BatchGetAssetsHistoryRequest) (*BatchGetAssetsHistoryResponse, error)
	// Creates a feed in a parent project/folder/organization to listen to its
	// asset updates.
	CreateFeed(context.Context, *CreateFeedRequest) (*Feed, error)
	// Gets details about an asset feed.
	GetFeed(context.Context, *GetFeedRequest) (*Feed, error)
	// Lists all asset feeds in a parent project/folder/organization.
	ListFeeds(context.Context, *ListFeedsRequest) (*ListFeedsResponse, error)
	// Updates an asset feed configuration.
	UpdateFeed(context.Context, *UpdateFeedRequest) (*Feed, error)
	// Deletes an asset feed.
	DeleteFeed(context.Context, *DeleteFeedRequest) (*empty.Empty, error)
	// Searches all the resources within the given accessible scope (e.g., a
	// project, a folder or an organization). Callers should have
	// cloud.assets.SearchAllResources permission upon the requested scope,
	// otherwise the request will be rejected.
	SearchAllResources(context.Context, *SearchAllResourcesRequest) (*SearchAllResourcesResponse, error)
	// Searches all the IAM policies within the given accessible scope (e.g., a
	// project, a folder or an organization). Callers should have
	// cloud.assets.SearchAllIamPolicies permission upon the requested scope,
	// otherwise the request will be rejected.
	SearchAllIamPolicies(context.Context, *SearchAllIamPoliciesRequest) (*SearchAllIamPoliciesResponse, error)
}

// UnimplementedAssetServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAssetServiceServer struct {
}

func (*UnimplementedAssetServiceServer) ExportAssets(context.Context, *ExportAssetsRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportAssets not implemented")
}
func (*UnimplementedAssetServiceServer) BatchGetAssetsHistory(context.Context, *BatchGetAssetsHistoryRequest) (*BatchGetAssetsHistoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchGetAssetsHistory not implemented")
}
func (*UnimplementedAssetServiceServer) CreateFeed(context.Context, *CreateFeedRequest) (*Feed, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateFeed not implemented")
}
func (*UnimplementedAssetServiceServer) GetFeed(context.Context, *GetFeedRequest) (*Feed, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFeed not implemented")
}
func (*UnimplementedAssetServiceServer) ListFeeds(context.Context, *ListFeedsRequest) (*ListFeedsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFeeds not implemented")
}
func (*UnimplementedAssetServiceServer) UpdateFeed(context.Context, *UpdateFeedRequest) (*Feed, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateFeed not implemented")
}
func (*UnimplementedAssetServiceServer) DeleteFeed(context.Context, *DeleteFeedRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteFeed not implemented")
}
func (*UnimplementedAssetServiceServer) SearchAllResources(context.Context, *SearchAllResourcesRequest) (*SearchAllResourcesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchAllResources not implemented")
}
func (*UnimplementedAssetServiceServer) SearchAllIamPolicies(context.Context, *SearchAllIamPoliciesRequest) (*SearchAllIamPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchAllIamPolicies not implemented")
}

func RegisterAssetServiceServer(s *grpc.Server, srv AssetServiceServer) {
	s.RegisterService(&_AssetService_serviceDesc, srv)
}

func _AssetService_ExportAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).ExportAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/ExportAssets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).ExportAssets(ctx, req.(*ExportAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_BatchGetAssetsHistory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchGetAssetsHistoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).BatchGetAssetsHistory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/BatchGetAssetsHistory",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).BatchGetAssetsHistory(ctx, req.(*BatchGetAssetsHistoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_CreateFeed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFeedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).CreateFeed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/CreateFeed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).CreateFeed(ctx, req.(*CreateFeedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_GetFeed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFeedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).GetFeed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/GetFeed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).GetFeed(ctx, req.(*GetFeedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_ListFeeds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFeedsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).ListFeeds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/ListFeeds",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).ListFeeds(ctx, req.(*ListFeedsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_UpdateFeed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFeedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).UpdateFeed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/UpdateFeed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).UpdateFeed(ctx, req.(*UpdateFeedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_DeleteFeed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFeedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).DeleteFeed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/DeleteFeed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).DeleteFeed(ctx, req.(*DeleteFeedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_SearchAllResources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchAllResourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).SearchAllResources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/SearchAllResources",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).SearchAllResources(ctx, req.(*SearchAllResourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_SearchAllIamPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchAllIamPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).SearchAllIamPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/SearchAllIamPolicies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).SearchAllIamPolicies(ctx, req.(*SearchAllIamPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AssetService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.asset.v1.AssetService",
	HandlerType: (*AssetServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ExportAssets",
			Handler:    _AssetService_ExportAssets_Handler,
		},
		{
			MethodName: "BatchGetAssetsHistory",
			Handler:    _AssetService_BatchGetAssetsHistory_Handler,
		},
		{
			MethodName: "CreateFeed",
			Handler:    _AssetService_CreateFeed_Handler,
		},
		{
			MethodName: "GetFeed",
			Handler:    _AssetService_GetFeed_Handler,
		},
		{
			MethodName: "ListFeeds",
			Handler:    _AssetService_ListFeeds_Handler,
		},
		{
			MethodName: "UpdateFeed",
			Handler:    _AssetService_UpdateFeed_Handler,
		},
		{
			MethodName: "DeleteFeed",
			Handler:    _AssetService_DeleteFeed_Handler,
		},
		{
			MethodName: "SearchAllResources",
			Handler:    _AssetService_SearchAllResources_Handler,
		},
		{
			MethodName: "SearchAllIamPolicies",
			Handler:    _AssetService_SearchAllIamPolicies_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/asset/v1/asset_service.proto",
}
