// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/k8snetworkplumbingwg/sriov-network-operator/api/v1"
	"github.com/k8snetworkplumbingwg/sriov-network-operator/pkg/client/clientset/versioned/scheme"
	rest "k8s.io/client-go/rest"
)

type SriovnetworkV1Interface interface {
	RESTClient() rest.Interface
	SriovNetworksGetter
	SriovNetworkNodePoliciesGetter
	SriovNetworkNodeStatesGetter
	SriovOperatorConfigsGetter
}

// SriovnetworkV1Client is used to interact with features provided by the sriovnetwork.openshift.io group.
type SriovnetworkV1Client struct {
	restClient rest.Interface
}

func (c *SriovnetworkV1Client) SriovNetworks(namespace string) SriovNetworkInterface {
	return newSriovNetworks(c, namespace)
}

func (c *SriovnetworkV1Client) SriovNetworkNodePolicies(namespace string) SriovNetworkNodePolicyInterface {
	return newSriovNetworkNodePolicies(c, namespace)
}

func (c *SriovnetworkV1Client) SriovNetworkNodeStates(namespace string) SriovNetworkNodeStateInterface {
	return newSriovNetworkNodeStates(c, namespace)
}

func (c *SriovnetworkV1Client) SriovOperatorConfigs(namespace string) SriovOperatorConfigInterface {
	return newSriovOperatorConfigs(c, namespace)
}

// NewForConfig creates a new SriovnetworkV1Client for the given config.
func NewForConfig(c *rest.Config) (*SriovnetworkV1Client, error) {
	config := *c
	if err := setConfigDefaults(&config); err != nil {
		return nil, err
	}
	client, err := rest.RESTClientFor(&config)
	if err != nil {
		return nil, err
	}
	return &SriovnetworkV1Client{client}, nil
}

// NewForConfigOrDie creates a new SriovnetworkV1Client for the given config and
// panics if there is an error in the config.
func NewForConfigOrDie(c *rest.Config) *SriovnetworkV1Client {
	client, err := NewForConfig(c)
	if err != nil {
		panic(err)
	}
	return client
}

// New creates a new SriovnetworkV1Client for the given RESTClient.
func New(c rest.Interface) *SriovnetworkV1Client {
	return &SriovnetworkV1Client{c}
}

func setConfigDefaults(config *rest.Config) error {
	gv := v1.SchemeGroupVersion
	config.GroupVersion = &gv
	config.APIPath = "/apis"
	config.NegotiatedSerializer = scheme.Codecs.WithoutConversion()

	if config.UserAgent == "" {
		config.UserAgent = rest.DefaultKubernetesUserAgent()
	}

	return nil
}

// RESTClient returns a RESTClient that is used to communicate
// with API server by this client implementation.
func (c *SriovnetworkV1Client) RESTClient() rest.Interface {
	if c == nil {
		return nil
	}
	return c.restClient
}
