// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package transcribeservice

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateVocabulary = "CreateVocabulary"

// CreateVocabularyRequest generates a "aws/request.Request" representing the
// client's request for the CreateVocabulary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVocabulary for more information on using the CreateVocabulary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateVocabularyRequest method.
//    req, resp := client.CreateVocabularyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateVocabulary
func (c *TranscribeService) CreateVocabularyRequest(input *CreateVocabularyInput) (req *request.Request, output *CreateVocabularyOutput) {
	op := &request.Operation{
		Name:       opCreateVocabulary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVocabularyInput{}
	}

	output = &CreateVocabularyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVocabulary API operation for Amazon Transcribe Service.
//
// Creates a new custom vocabulary that you can use to change the way Amazon
// Transcribe handles transcription of an audio file.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation CreateVocabulary for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Your request didn't pass one or more validation tests. For example, if the
//   transcription you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * ErrCodeConflictException "ConflictException"
//   When you are using the StartTranscriptionJob operation, the JobName field
//   is a duplicate of a previously entered job name. Resend your request with
//   a different name.
//
//   When you are using the UpdateVocabulary operation, there are two jobs running
//   at the same time. Resend the second request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateVocabulary
func (c *TranscribeService) CreateVocabulary(input *CreateVocabularyInput) (*CreateVocabularyOutput, error) {
	req, out := c.CreateVocabularyRequest(input)
	return out, req.Send()
}

// CreateVocabularyWithContext is the same as CreateVocabulary with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVocabulary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) CreateVocabularyWithContext(ctx aws.Context, input *CreateVocabularyInput, opts ...request.Option) (*CreateVocabularyOutput, error) {
	req, out := c.CreateVocabularyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTranscriptionJob = "DeleteTranscriptionJob"

// DeleteTranscriptionJobRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTranscriptionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTranscriptionJob for more information on using the DeleteTranscriptionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTranscriptionJobRequest method.
//    req, resp := client.DeleteTranscriptionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteTranscriptionJob
func (c *TranscribeService) DeleteTranscriptionJobRequest(input *DeleteTranscriptionJobInput) (req *request.Request, output *DeleteTranscriptionJobOutput) {
	op := &request.Operation{
		Name:       opDeleteTranscriptionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTranscriptionJobInput{}
	}

	output = &DeleteTranscriptionJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTranscriptionJob API operation for Amazon Transcribe Service.
//
// Deletes a previously submitted transcription job along with any other generated
// results such as the transcription, models, and so on.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation DeleteTranscriptionJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   Your request didn't pass one or more validation tests. For example, if the
//   transcription you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal error. Check the error message and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteTranscriptionJob
func (c *TranscribeService) DeleteTranscriptionJob(input *DeleteTranscriptionJobInput) (*DeleteTranscriptionJobOutput, error) {
	req, out := c.DeleteTranscriptionJobRequest(input)
	return out, req.Send()
}

// DeleteTranscriptionJobWithContext is the same as DeleteTranscriptionJob with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTranscriptionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) DeleteTranscriptionJobWithContext(ctx aws.Context, input *DeleteTranscriptionJobInput, opts ...request.Option) (*DeleteTranscriptionJobOutput, error) {
	req, out := c.DeleteTranscriptionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVocabulary = "DeleteVocabulary"

// DeleteVocabularyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVocabulary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVocabulary for more information on using the DeleteVocabulary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVocabularyRequest method.
//    req, resp := client.DeleteVocabularyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteVocabulary
func (c *TranscribeService) DeleteVocabularyRequest(input *DeleteVocabularyInput) (req *request.Request, output *DeleteVocabularyOutput) {
	op := &request.Operation{
		Name:       opDeleteVocabulary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVocabularyInput{}
	}

	output = &DeleteVocabularyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVocabulary API operation for Amazon Transcribe Service.
//
// Deletes a vocabulary from Amazon Transcribe.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation DeleteVocabulary for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   We can't find the requested resource. Check the name and try your request
//   again.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   Your request didn't pass one or more validation tests. For example, if the
//   transcription you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal error. Check the error message and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteVocabulary
func (c *TranscribeService) DeleteVocabulary(input *DeleteVocabularyInput) (*DeleteVocabularyOutput, error) {
	req, out := c.DeleteVocabularyRequest(input)
	return out, req.Send()
}

// DeleteVocabularyWithContext is the same as DeleteVocabulary with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVocabulary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) DeleteVocabularyWithContext(ctx aws.Context, input *DeleteVocabularyInput, opts ...request.Option) (*DeleteVocabularyOutput, error) {
	req, out := c.DeleteVocabularyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTranscriptionJob = "GetTranscriptionJob"

// GetTranscriptionJobRequest generates a "aws/request.Request" representing the
// client's request for the GetTranscriptionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTranscriptionJob for more information on using the GetTranscriptionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTranscriptionJobRequest method.
//    req, resp := client.GetTranscriptionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetTranscriptionJob
func (c *TranscribeService) GetTranscriptionJobRequest(input *GetTranscriptionJobInput) (req *request.Request, output *GetTranscriptionJobOutput) {
	op := &request.Operation{
		Name:       opGetTranscriptionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTranscriptionJobInput{}
	}

	output = &GetTranscriptionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTranscriptionJob API operation for Amazon Transcribe Service.
//
// Returns information about a transcription job. To see the status of the job,
// check the TranscriptionJobStatus field. If the status is COMPLETED, the job
// is finished and you can find the results at the location specified in the
// TranscriptionFileUri field.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation GetTranscriptionJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Your request didn't pass one or more validation tests. For example, if the
//   transcription you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   We can't find the requested resource. Check the name and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetTranscriptionJob
func (c *TranscribeService) GetTranscriptionJob(input *GetTranscriptionJobInput) (*GetTranscriptionJobOutput, error) {
	req, out := c.GetTranscriptionJobRequest(input)
	return out, req.Send()
}

// GetTranscriptionJobWithContext is the same as GetTranscriptionJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetTranscriptionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) GetTranscriptionJobWithContext(ctx aws.Context, input *GetTranscriptionJobInput, opts ...request.Option) (*GetTranscriptionJobOutput, error) {
	req, out := c.GetTranscriptionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVocabulary = "GetVocabulary"

// GetVocabularyRequest generates a "aws/request.Request" representing the
// client's request for the GetVocabulary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVocabulary for more information on using the GetVocabulary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetVocabularyRequest method.
//    req, resp := client.GetVocabularyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetVocabulary
func (c *TranscribeService) GetVocabularyRequest(input *GetVocabularyInput) (req *request.Request, output *GetVocabularyOutput) {
	op := &request.Operation{
		Name:       opGetVocabulary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetVocabularyInput{}
	}

	output = &GetVocabularyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVocabulary API operation for Amazon Transcribe Service.
//
// Gets information about a vocabulary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation GetVocabulary for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNotFoundException "NotFoundException"
//   We can't find the requested resource. Check the name and try your request
//   again.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * ErrCodeBadRequestException "BadRequestException"
//   Your request didn't pass one or more validation tests. For example, if the
//   transcription you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetVocabulary
func (c *TranscribeService) GetVocabulary(input *GetVocabularyInput) (*GetVocabularyOutput, error) {
	req, out := c.GetVocabularyRequest(input)
	return out, req.Send()
}

// GetVocabularyWithContext is the same as GetVocabulary with the addition of
// the ability to pass a context and additional request options.
//
// See GetVocabulary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) GetVocabularyWithContext(ctx aws.Context, input *GetVocabularyInput, opts ...request.Option) (*GetVocabularyOutput, error) {
	req, out := c.GetVocabularyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTranscriptionJobs = "ListTranscriptionJobs"

// ListTranscriptionJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListTranscriptionJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTranscriptionJobs for more information on using the ListTranscriptionJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTranscriptionJobsRequest method.
//    req, resp := client.ListTranscriptionJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTranscriptionJobs
func (c *TranscribeService) ListTranscriptionJobsRequest(input *ListTranscriptionJobsInput) (req *request.Request, output *ListTranscriptionJobsOutput) {
	op := &request.Operation{
		Name:       opListTranscriptionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTranscriptionJobsInput{}
	}

	output = &ListTranscriptionJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTranscriptionJobs API operation for Amazon Transcribe Service.
//
// Lists transcription jobs with the specified status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation ListTranscriptionJobs for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Your request didn't pass one or more validation tests. For example, if the
//   transcription you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal error. Check the error message and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTranscriptionJobs
func (c *TranscribeService) ListTranscriptionJobs(input *ListTranscriptionJobsInput) (*ListTranscriptionJobsOutput, error) {
	req, out := c.ListTranscriptionJobsRequest(input)
	return out, req.Send()
}

// ListTranscriptionJobsWithContext is the same as ListTranscriptionJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListTranscriptionJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListTranscriptionJobsWithContext(ctx aws.Context, input *ListTranscriptionJobsInput, opts ...request.Option) (*ListTranscriptionJobsOutput, error) {
	req, out := c.ListTranscriptionJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTranscriptionJobsPages iterates over the pages of a ListTranscriptionJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTranscriptionJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTranscriptionJobs operation.
//    pageNum := 0
//    err := client.ListTranscriptionJobsPages(params,
//        func(page *ListTranscriptionJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *TranscribeService) ListTranscriptionJobsPages(input *ListTranscriptionJobsInput, fn func(*ListTranscriptionJobsOutput, bool) bool) error {
	return c.ListTranscriptionJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTranscriptionJobsPagesWithContext same as ListTranscriptionJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListTranscriptionJobsPagesWithContext(ctx aws.Context, input *ListTranscriptionJobsInput, fn func(*ListTranscriptionJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTranscriptionJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTranscriptionJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListTranscriptionJobsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opListVocabularies = "ListVocabularies"

// ListVocabulariesRequest generates a "aws/request.Request" representing the
// client's request for the ListVocabularies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVocabularies for more information on using the ListVocabularies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListVocabulariesRequest method.
//    req, resp := client.ListVocabulariesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularies
func (c *TranscribeService) ListVocabulariesRequest(input *ListVocabulariesInput) (req *request.Request, output *ListVocabulariesOutput) {
	op := &request.Operation{
		Name:       opListVocabularies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVocabulariesInput{}
	}

	output = &ListVocabulariesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVocabularies API operation for Amazon Transcribe Service.
//
// Returns a list of vocabularies that match the specified criteria. If no criteria
// are specified, returns the entire list of vocabularies.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation ListVocabularies for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Your request didn't pass one or more validation tests. For example, if the
//   transcription you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal error. Check the error message and try your request
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularies
func (c *TranscribeService) ListVocabularies(input *ListVocabulariesInput) (*ListVocabulariesOutput, error) {
	req, out := c.ListVocabulariesRequest(input)
	return out, req.Send()
}

// ListVocabulariesWithContext is the same as ListVocabularies with the addition of
// the ability to pass a context and additional request options.
//
// See ListVocabularies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListVocabulariesWithContext(ctx aws.Context, input *ListVocabulariesInput, opts ...request.Option) (*ListVocabulariesOutput, error) {
	req, out := c.ListVocabulariesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVocabulariesPages iterates over the pages of a ListVocabularies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVocabularies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListVocabularies operation.
//    pageNum := 0
//    err := client.ListVocabulariesPages(params,
//        func(page *ListVocabulariesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *TranscribeService) ListVocabulariesPages(input *ListVocabulariesInput, fn func(*ListVocabulariesOutput, bool) bool) error {
	return c.ListVocabulariesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVocabulariesPagesWithContext same as ListVocabulariesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListVocabulariesPagesWithContext(ctx aws.Context, input *ListVocabulariesInput, fn func(*ListVocabulariesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVocabulariesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVocabulariesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListVocabulariesOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opStartTranscriptionJob = "StartTranscriptionJob"

// StartTranscriptionJobRequest generates a "aws/request.Request" representing the
// client's request for the StartTranscriptionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartTranscriptionJob for more information on using the StartTranscriptionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartTranscriptionJobRequest method.
//    req, resp := client.StartTranscriptionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartTranscriptionJob
func (c *TranscribeService) StartTranscriptionJobRequest(input *StartTranscriptionJobInput) (req *request.Request, output *StartTranscriptionJobOutput) {
	op := &request.Operation{
		Name:       opStartTranscriptionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartTranscriptionJobInput{}
	}

	output = &StartTranscriptionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartTranscriptionJob API operation for Amazon Transcribe Service.
//
// Starts an asynchronous job to transcribe speech to text.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation StartTranscriptionJob for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Your request didn't pass one or more validation tests. For example, if the
//   transcription you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * ErrCodeConflictException "ConflictException"
//   When you are using the StartTranscriptionJob operation, the JobName field
//   is a duplicate of a previously entered job name. Resend your request with
//   a different name.
//
//   When you are using the UpdateVocabulary operation, there are two jobs running
//   at the same time. Resend the second request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartTranscriptionJob
func (c *TranscribeService) StartTranscriptionJob(input *StartTranscriptionJobInput) (*StartTranscriptionJobOutput, error) {
	req, out := c.StartTranscriptionJobRequest(input)
	return out, req.Send()
}

// StartTranscriptionJobWithContext is the same as StartTranscriptionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartTranscriptionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) StartTranscriptionJobWithContext(ctx aws.Context, input *StartTranscriptionJobInput, opts ...request.Option) (*StartTranscriptionJobOutput, error) {
	req, out := c.StartTranscriptionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVocabulary = "UpdateVocabulary"

// UpdateVocabularyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVocabulary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVocabulary for more information on using the UpdateVocabulary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateVocabularyRequest method.
//    req, resp := client.UpdateVocabularyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateVocabulary
func (c *TranscribeService) UpdateVocabularyRequest(input *UpdateVocabularyInput) (req *request.Request, output *UpdateVocabularyOutput) {
	op := &request.Operation{
		Name:       opUpdateVocabulary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateVocabularyInput{}
	}

	output = &UpdateVocabularyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVocabulary API operation for Amazon Transcribe Service.
//
// Updates an existing vocabulary with new values. The UpdateVocabulary operation
// overwrites all of the existing information with the values that you provide
// in the request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation UpdateVocabulary for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   Your request didn't pass one or more validation tests. For example, if the
//   transcription you're trying to delete doesn't exist or if it is in a non-terminal
//   state (for example, it's "in progress"). See the exception Message field
//   for more information.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   Either you have sent too many requests or your input file is too long. Wait
//   before you resend your request, or use a smaller file and resend the request.
//
//   * ErrCodeInternalFailureException "InternalFailureException"
//   There was an internal error. Check the error message and try your request
//   again.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   We can't find the requested resource. Check the name and try your request
//   again.
//
//   * ErrCodeConflictException "ConflictException"
//   When you are using the StartTranscriptionJob operation, the JobName field
//   is a duplicate of a previously entered job name. Resend your request with
//   a different name.
//
//   When you are using the UpdateVocabulary operation, there are two jobs running
//   at the same time. Resend the second request later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateVocabulary
func (c *TranscribeService) UpdateVocabulary(input *UpdateVocabularyInput) (*UpdateVocabularyOutput, error) {
	req, out := c.UpdateVocabularyRequest(input)
	return out, req.Send()
}

// UpdateVocabularyWithContext is the same as UpdateVocabulary with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVocabulary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) UpdateVocabularyWithContext(ctx aws.Context, input *UpdateVocabularyInput, opts ...request.Option) (*UpdateVocabularyOutput, error) {
	req, out := c.UpdateVocabularyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateVocabularyInput struct {
	_ struct{} `type:"structure"`

	// The language code of the vocabulary entries.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// An array of strings that contains the vocabulary entries.
	Phrases []*string `type:"list"`

	// The S3 location of the text file that contains the definition of the custom
	// vocabulary. The URI must be in the same region as the API endpoint that you
	// are calling. The general form is
	//
	// https://s3-<aws-region>.amazonaws.com/<bucket-name>/<keyprefix>/<objectkey>
	//
	// For example:
	//
	// https://s3-us-east-1.amazonaws.com/examplebucket/vocab.txt
	//
	// For more information about S3 object names, see Object Keys (http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys)
	// in the Amazon S3 Developer Guide.
	//
	// For more information about custom vocabularies, see Custom Vocabularies (http://docs.aws.amazon.com/transcribe/latest/dg/how-it-works.html#how-vocabulary).
	VocabularyFileUri *string `min:"1" type:"string"`

	// The name of the vocabulary. The name must be unique within an AWS account.
	// The name is case-sensitive.
	//
	// VocabularyName is a required field
	VocabularyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateVocabularyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVocabularyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVocabularyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVocabularyInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.VocabularyFileUri != nil && len(*s.VocabularyFileUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFileUri", 1))
	}
	if s.VocabularyName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyName"))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CreateVocabularyInput) SetLanguageCode(v string) *CreateVocabularyInput {
	s.LanguageCode = &v
	return s
}

// SetPhrases sets the Phrases field's value.
func (s *CreateVocabularyInput) SetPhrases(v []*string) *CreateVocabularyInput {
	s.Phrases = v
	return s
}

// SetVocabularyFileUri sets the VocabularyFileUri field's value.
func (s *CreateVocabularyInput) SetVocabularyFileUri(v string) *CreateVocabularyInput {
	s.VocabularyFileUri = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *CreateVocabularyInput) SetVocabularyName(v string) *CreateVocabularyInput {
	s.VocabularyName = &v
	return s
}

type CreateVocabularyOutput struct {
	_ struct{} `type:"structure"`

	// If the VocabularyState field is FAILED, this field contains information about
	// why the job failed.
	FailureReason *string `type:"string"`

	// The language code of the vocabulary entries.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time that the vocabulary was created.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the vocabulary.
	VocabularyName *string `min:"1" type:"string"`

	// The processing state of the vocabulary. When the VocabularyState field contains
	// READY the vocabulary is ready to be used in a StartTranscriptionJob request.
	VocabularyState *string `type:"string" enum:"VocabularyState"`
}

// String returns the string representation
func (s CreateVocabularyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVocabularyOutput) GoString() string {
	return s.String()
}

// SetFailureReason sets the FailureReason field's value.
func (s *CreateVocabularyOutput) SetFailureReason(v string) *CreateVocabularyOutput {
	s.FailureReason = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CreateVocabularyOutput) SetLanguageCode(v string) *CreateVocabularyOutput {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *CreateVocabularyOutput) SetLastModifiedTime(v time.Time) *CreateVocabularyOutput {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *CreateVocabularyOutput) SetVocabularyName(v string) *CreateVocabularyOutput {
	s.VocabularyName = &v
	return s
}

// SetVocabularyState sets the VocabularyState field's value.
func (s *CreateVocabularyOutput) SetVocabularyState(v string) *CreateVocabularyOutput {
	s.VocabularyState = &v
	return s
}

type DeleteTranscriptionJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the transcription job to be deleted.
	//
	// TranscriptionJobName is a required field
	TranscriptionJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteTranscriptionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTranscriptionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTranscriptionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTranscriptionJobInput"}
	if s.TranscriptionJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("TranscriptionJobName"))
	}
	if s.TranscriptionJobName != nil && len(*s.TranscriptionJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TranscriptionJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTranscriptionJobName sets the TranscriptionJobName field's value.
func (s *DeleteTranscriptionJobInput) SetTranscriptionJobName(v string) *DeleteTranscriptionJobInput {
	s.TranscriptionJobName = &v
	return s
}

type DeleteTranscriptionJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTranscriptionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTranscriptionJobOutput) GoString() string {
	return s.String()
}

type DeleteVocabularyInput struct {
	_ struct{} `type:"structure"`

	// The name of the vocabulary to delete.
	//
	// VocabularyName is a required field
	VocabularyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVocabularyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVocabularyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVocabularyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVocabularyInput"}
	if s.VocabularyName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyName"))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *DeleteVocabularyInput) SetVocabularyName(v string) *DeleteVocabularyInput {
	s.VocabularyName = &v
	return s
}

type DeleteVocabularyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVocabularyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVocabularyOutput) GoString() string {
	return s.String()
}

type GetTranscriptionJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the job.
	//
	// TranscriptionJobName is a required field
	TranscriptionJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetTranscriptionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTranscriptionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTranscriptionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTranscriptionJobInput"}
	if s.TranscriptionJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("TranscriptionJobName"))
	}
	if s.TranscriptionJobName != nil && len(*s.TranscriptionJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TranscriptionJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTranscriptionJobName sets the TranscriptionJobName field's value.
func (s *GetTranscriptionJobInput) SetTranscriptionJobName(v string) *GetTranscriptionJobInput {
	s.TranscriptionJobName = &v
	return s
}

type GetTranscriptionJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the results of the transcription job.
	TranscriptionJob *TranscriptionJob `type:"structure"`
}

// String returns the string representation
func (s GetTranscriptionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTranscriptionJobOutput) GoString() string {
	return s.String()
}

// SetTranscriptionJob sets the TranscriptionJob field's value.
func (s *GetTranscriptionJobOutput) SetTranscriptionJob(v *TranscriptionJob) *GetTranscriptionJobOutput {
	s.TranscriptionJob = v
	return s
}

type GetVocabularyInput struct {
	_ struct{} `type:"structure"`

	// The name of the vocabulary to return information about. The name is case-sensitive.
	//
	// VocabularyName is a required field
	VocabularyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetVocabularyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVocabularyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVocabularyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVocabularyInput"}
	if s.VocabularyName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyName"))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *GetVocabularyInput) SetVocabularyName(v string) *GetVocabularyInput {
	s.VocabularyName = &v
	return s
}

type GetVocabularyOutput struct {
	_ struct{} `type:"structure"`

	// The S3 location where the vocabulary is stored. Use this URI to get the contents
	// of the vocabulary. The URI is available for a limited time.
	DownloadUri *string `min:"1" type:"string"`

	// If the VocabularyState field is FAILED, this field contains information about
	// why the job failed.
	FailureReason *string `type:"string"`

	// The language code of the vocabulary entries.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time that the vocabulary was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the vocabulary to return.
	VocabularyName *string `min:"1" type:"string"`

	// The processing state of the vocabulary.
	VocabularyState *string `type:"string" enum:"VocabularyState"`
}

// String returns the string representation
func (s GetVocabularyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVocabularyOutput) GoString() string {
	return s.String()
}

// SetDownloadUri sets the DownloadUri field's value.
func (s *GetVocabularyOutput) SetDownloadUri(v string) *GetVocabularyOutput {
	s.DownloadUri = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *GetVocabularyOutput) SetFailureReason(v string) *GetVocabularyOutput {
	s.FailureReason = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *GetVocabularyOutput) SetLanguageCode(v string) *GetVocabularyOutput {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *GetVocabularyOutput) SetLastModifiedTime(v time.Time) *GetVocabularyOutput {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *GetVocabularyOutput) SetVocabularyName(v string) *GetVocabularyOutput {
	s.VocabularyName = &v
	return s
}

// SetVocabularyState sets the VocabularyState field's value.
func (s *GetVocabularyOutput) SetVocabularyState(v string) *GetVocabularyOutput {
	s.VocabularyState = &v
	return s
}

type ListTranscriptionJobsInput struct {
	_ struct{} `type:"structure"`

	// When specified, the jobs returned in the list are limited to jobs whose name
	// contains the specified string.
	JobNameContains *string `min:"1" type:"string"`

	// The maximum number of jobs to return in the response. If there are fewer
	// results in the list, this response contains only the actual results.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the result of the previous request to ListTranscriptionJobs was truncated,
	// include the NextToken to fetch the next set of jobs.
	NextToken *string `type:"string"`

	// When specified, returns only transcription jobs with the specified status.
	// Jobs are ordered by creation date, with the newest jobs returned first. If
	// you don’t specify a status, Amazon Transcribe returns all transcription jobs
	// ordered by creation date.
	Status *string `type:"string" enum:"TranscriptionJobStatus"`
}

// String returns the string representation
func (s ListTranscriptionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTranscriptionJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTranscriptionJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTranscriptionJobsInput"}
	if s.JobNameContains != nil && len(*s.JobNameContains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobNameContains", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobNameContains sets the JobNameContains field's value.
func (s *ListTranscriptionJobsInput) SetJobNameContains(v string) *ListTranscriptionJobsInput {
	s.JobNameContains = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTranscriptionJobsInput) SetMaxResults(v int64) *ListTranscriptionJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTranscriptionJobsInput) SetNextToken(v string) *ListTranscriptionJobsInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListTranscriptionJobsInput) SetStatus(v string) *ListTranscriptionJobsInput {
	s.Status = &v
	return s
}

type ListTranscriptionJobsOutput struct {
	_ struct{} `type:"structure"`

	// The ListTranscriptionJobs operation returns a page of jobs at a time. The
	// maximum size of the page is set by the MaxResults parameter. If there are
	// more jobs in the list than the page size, Amazon Transcribe returns the NextPage
	// token. Include the token in the next request to the ListTranscriptionJobs
	// operation to return in the next page of jobs.
	NextToken *string `type:"string"`

	// The requested status of the jobs returned.
	Status *string `type:"string" enum:"TranscriptionJobStatus"`

	// A list of objects containing summary information for a transcription job.
	TranscriptionJobSummaries []*TranscriptionJobSummary `type:"list"`
}

// String returns the string representation
func (s ListTranscriptionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTranscriptionJobsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTranscriptionJobsOutput) SetNextToken(v string) *ListTranscriptionJobsOutput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListTranscriptionJobsOutput) SetStatus(v string) *ListTranscriptionJobsOutput {
	s.Status = &v
	return s
}

// SetTranscriptionJobSummaries sets the TranscriptionJobSummaries field's value.
func (s *ListTranscriptionJobsOutput) SetTranscriptionJobSummaries(v []*TranscriptionJobSummary) *ListTranscriptionJobsOutput {
	s.TranscriptionJobSummaries = v
	return s
}

type ListVocabulariesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of vocabularies to return in the response. If there are
	// fewer results in the list, this response contains only the actual results.
	MaxResults *int64 `min:"1" type:"integer"`

	// When specified, the vocabularies returned in the list are limited to vocabularies
	// whose name contains the specified string. The search is case-insensitive,
	// ListVocabularies will return both "vocabularyname" and "VocabularyName" in
	// the response list.
	NameContains *string `min:"1" type:"string"`

	// If the result of the previous request to ListVocabularies was truncated,
	// include the NextToken to fetch the next set of jobs.
	NextToken *string `type:"string"`

	// When specified, only returns vocabularies with the VocabularyState field
	// equal to the specified state.
	StateEquals *string `type:"string" enum:"VocabularyState"`
}

// String returns the string representation
func (s ListVocabulariesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVocabulariesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVocabulariesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVocabulariesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NameContains != nil && len(*s.NameContains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NameContains", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListVocabulariesInput) SetMaxResults(v int64) *ListVocabulariesInput {
	s.MaxResults = &v
	return s
}

// SetNameContains sets the NameContains field's value.
func (s *ListVocabulariesInput) SetNameContains(v string) *ListVocabulariesInput {
	s.NameContains = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVocabulariesInput) SetNextToken(v string) *ListVocabulariesInput {
	s.NextToken = &v
	return s
}

// SetStateEquals sets the StateEquals field's value.
func (s *ListVocabulariesInput) SetStateEquals(v string) *ListVocabulariesInput {
	s.StateEquals = &v
	return s
}

type ListVocabulariesOutput struct {
	_ struct{} `type:"structure"`

	// The ListVocabularies operation returns a page of vocabularies at a time.
	// The maximum size of the page is set by the MaxResults parameter. If there
	// are more jobs in the list than the page size, Amazon Transcribe returns the
	// NextPage token. Include the token in the next request to the ListVocabularies
	// operation to return in the next page of jobs.
	NextToken *string `type:"string"`

	// The requested vocabulary state.
	Status *string `type:"string" enum:"TranscriptionJobStatus"`

	// A list of objects that describe the vocabularies that match the search criteria
	// in the request.
	Vocabularies []*VocabularyInfo `type:"list"`
}

// String returns the string representation
func (s ListVocabulariesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVocabulariesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListVocabulariesOutput) SetNextToken(v string) *ListVocabulariesOutput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListVocabulariesOutput) SetStatus(v string) *ListVocabulariesOutput {
	s.Status = &v
	return s
}

// SetVocabularies sets the Vocabularies field's value.
func (s *ListVocabulariesOutput) SetVocabularies(v []*VocabularyInfo) *ListVocabulariesOutput {
	s.Vocabularies = v
	return s
}

// Describes the input media file in a transcription request.
type Media struct {
	_ struct{} `type:"structure"`

	// The S3 location of the input media file. The URI must be in the same region
	// as the API endpoint that you are calling. The general form is:
	//
	// https://s3-<aws-region>.amazonaws.com/<bucket-name>/<keyprefix>/<objectkey>
	//
	// For example:
	//
	// https://s3-us-east-1.amazonaws.com/examplebucket/example.mp4
	//
	// https://s3-us-east-1.amazonaws.com/examplebucket/mediadocs/example.mp4
	//
	// For more information about S3 object names, see Object Keys (http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys)
	// in the Amazon S3 Developer Guide.
	MediaFileUri *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Media) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Media) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Media) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Media"}
	if s.MediaFileUri != nil && len(*s.MediaFileUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MediaFileUri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMediaFileUri sets the MediaFileUri field's value.
func (s *Media) SetMediaFileUri(v string) *Media {
	s.MediaFileUri = &v
	return s
}

// Provides optional settings for the StartTranscriptionJob operation.
type Settings struct {
	_ struct{} `type:"structure"`

	// Instructs Amazon Transcribe to process each audio channel separately and
	// then merge the transcription output of each channel into a single transcription.
	//
	// Amazon Transcribe also produces a transcription of each item detected on
	// an audio channel, including the start time and end time of the item and alternative
	// transcriptions of the item including the confidence that Amazon Transcribe
	// has in the transcription.
	//
	// You can't set both ShowSpeakerLabels and ChannelIdentification in the same
	// request. If you set both, your request returns a BadRequestException.
	ChannelIdentification *bool `type:"boolean"`

	// The maximum number of speakers to identify in the input audio. If there are
	// more speakers in the audio than this number, multiple speakers will be identified
	// as a single speaker. If you specify the MaxSpeakerLabels field, you must
	// set the ShowSpeakerLabels field to true.
	MaxSpeakerLabels *int64 `min:"2" type:"integer"`

	// Determines whether the transcription job uses speaker recognition to identify
	// different speakers in the input audio. Speaker recognition labels individual
	// speakers in the audio file. If you set the ShowSpeakerLabels field to true,
	// you must also set the maximum number of speaker labels MaxSpeakerLabels field.
	//
	// You can't set both ShowSpeakerLabels and ChannelIdentification in the same
	// request. If you set both, your request returns a BadRequestException.
	ShowSpeakerLabels *bool `type:"boolean"`

	// The name of a vocabulary to use when processing the transcription job.
	VocabularyName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Settings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Settings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Settings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Settings"}
	if s.MaxSpeakerLabels != nil && *s.MaxSpeakerLabels < 2 {
		invalidParams.Add(request.NewErrParamMinValue("MaxSpeakerLabels", 2))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelIdentification sets the ChannelIdentification field's value.
func (s *Settings) SetChannelIdentification(v bool) *Settings {
	s.ChannelIdentification = &v
	return s
}

// SetMaxSpeakerLabels sets the MaxSpeakerLabels field's value.
func (s *Settings) SetMaxSpeakerLabels(v int64) *Settings {
	s.MaxSpeakerLabels = &v
	return s
}

// SetShowSpeakerLabels sets the ShowSpeakerLabels field's value.
func (s *Settings) SetShowSpeakerLabels(v bool) *Settings {
	s.ShowSpeakerLabels = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *Settings) SetVocabularyName(v string) *Settings {
	s.VocabularyName = &v
	return s
}

type StartTranscriptionJobInput struct {
	_ struct{} `type:"structure"`

	// The language code for the language used in the input media file.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// An object that describes the input media for a transcription job.
	//
	// Media is a required field
	Media *Media `type:"structure" required:"true"`

	// The format of the input media file.
	//
	// MediaFormat is a required field
	MediaFormat *string `type:"string" required:"true" enum:"MediaFormat"`

	// The sample rate, in Hertz, of the audio track in the input media file.
	MediaSampleRateHertz *int64 `min:"8000" type:"integer"`

	// The location where the transcription is stored.
	//
	// If you set the OutputBucketName, Amazon Transcribe puts the transcription
	// in the specified S3 bucket. When you call the GetTranscriptionJob operation,
	// the operation returns this location in the TranscriptFileUri field. The S3
	// bucket must have permissions that allow Amazon Transcribe to put files in
	// the bucket. For more information, see Permissions Required for IAM User Roles
	// (https://docs.aws.amazon.com/transcribe/latest/dg/access-control-managing-permissions.html#auth-role-iam-user).
	//
	// Amazon Transcribe uses the default Amazon S3 key for server-side encryption
	// of transcripts that are placed in your S3 bucket. You can't specify your
	// own encryption key.
	//
	// If you don't set the OutputBucketName, Amazon Transcribe generates a pre-signed
	// URL, a shareable URL that provides secure access to your transcription, and
	// returns it in the TranscriptFileUri field. Use this URL to download the transcription.
	OutputBucketName *string `type:"string"`

	// A Settings object that provides optional settings for a transcription job.
	Settings *Settings `type:"structure"`

	// The name of the job. Note that you can't use the strings "." or ".." by themselves
	// as the job name. The name must also be unique within an AWS account.
	//
	// TranscriptionJobName is a required field
	TranscriptionJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartTranscriptionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartTranscriptionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartTranscriptionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartTranscriptionJobInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.Media == nil {
		invalidParams.Add(request.NewErrParamRequired("Media"))
	}
	if s.MediaFormat == nil {
		invalidParams.Add(request.NewErrParamRequired("MediaFormat"))
	}
	if s.MediaSampleRateHertz != nil && *s.MediaSampleRateHertz < 8000 {
		invalidParams.Add(request.NewErrParamMinValue("MediaSampleRateHertz", 8000))
	}
	if s.TranscriptionJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("TranscriptionJobName"))
	}
	if s.TranscriptionJobName != nil && len(*s.TranscriptionJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TranscriptionJobName", 1))
	}
	if s.Media != nil {
		if err := s.Media.Validate(); err != nil {
			invalidParams.AddNested("Media", err.(request.ErrInvalidParams))
		}
	}
	if s.Settings != nil {
		if err := s.Settings.Validate(); err != nil {
			invalidParams.AddNested("Settings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *StartTranscriptionJobInput) SetLanguageCode(v string) *StartTranscriptionJobInput {
	s.LanguageCode = &v
	return s
}

// SetMedia sets the Media field's value.
func (s *StartTranscriptionJobInput) SetMedia(v *Media) *StartTranscriptionJobInput {
	s.Media = v
	return s
}

// SetMediaFormat sets the MediaFormat field's value.
func (s *StartTranscriptionJobInput) SetMediaFormat(v string) *StartTranscriptionJobInput {
	s.MediaFormat = &v
	return s
}

// SetMediaSampleRateHertz sets the MediaSampleRateHertz field's value.
func (s *StartTranscriptionJobInput) SetMediaSampleRateHertz(v int64) *StartTranscriptionJobInput {
	s.MediaSampleRateHertz = &v
	return s
}

// SetOutputBucketName sets the OutputBucketName field's value.
func (s *StartTranscriptionJobInput) SetOutputBucketName(v string) *StartTranscriptionJobInput {
	s.OutputBucketName = &v
	return s
}

// SetSettings sets the Settings field's value.
func (s *StartTranscriptionJobInput) SetSettings(v *Settings) *StartTranscriptionJobInput {
	s.Settings = v
	return s
}

// SetTranscriptionJobName sets the TranscriptionJobName field's value.
func (s *StartTranscriptionJobInput) SetTranscriptionJobName(v string) *StartTranscriptionJobInput {
	s.TranscriptionJobName = &v
	return s
}

type StartTranscriptionJobOutput struct {
	_ struct{} `type:"structure"`

	// An object containing details of the asynchronous transcription job.
	TranscriptionJob *TranscriptionJob `type:"structure"`
}

// String returns the string representation
func (s StartTranscriptionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartTranscriptionJobOutput) GoString() string {
	return s.String()
}

// SetTranscriptionJob sets the TranscriptionJob field's value.
func (s *StartTranscriptionJobOutput) SetTranscriptionJob(v *TranscriptionJob) *StartTranscriptionJobOutput {
	s.TranscriptionJob = v
	return s
}

// Identifies the location of a transcription.
type Transcript struct {
	_ struct{} `type:"structure"`

	// The location where the transcription is stored.
	//
	// Use this URI to access the transcription. If you specified an S3 bucket in
	// the OutputBucketName field when you created the job, this is the URI of that
	// bucket. If you chose to store the transcription in Amazon Transcribe, this
	// is a shareable URL that provides secure access to that location.
	TranscriptFileUri *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Transcript) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Transcript) GoString() string {
	return s.String()
}

// SetTranscriptFileUri sets the TranscriptFileUri field's value.
func (s *Transcript) SetTranscriptFileUri(v string) *Transcript {
	s.TranscriptFileUri = &v
	return s
}

// Describes an asynchronous transcription job that was created with the StartTranscriptionJob
// operation.
type TranscriptionJob struct {
	_ struct{} `type:"structure"`

	// A timestamp that shows when the job was completed.
	CompletionTime *time.Time `type:"timestamp"`

	// A timestamp that shows when the job was created.
	CreationTime *time.Time `type:"timestamp"`

	// If the TranscriptionJobStatus field is FAILED, this field contains information
	// about why the job failed.
	//
	// The FailureReason field can contain one of the following values:
	//
	//    * Unsupported media format - The media format specified in the MediaFormat
	//    field of the request isn't valid. See the description of the MediaFormat
	//    field for a list of valid values.
	//
	//    * The media format provided does not match the detected media format -
	//    The media format of the audio file doesn't match the format specified
	//    in the MediaFormat field in the request. Check the media format of your
	//    media file and make sure that the two values match.
	//
	//    * Invalid sample rate for audio file - The sample rate specified in the
	//    MediaSampleRateHertz of the request isn't valid. The sample rate must
	//    be between 8000 and 48000 Hertz.
	//
	//    * The sample rate provided does not match the detected sample rate - The
	//    sample rate in the audio file doesn't match the sample rate specified
	//    in the MediaSampleRateHertz field in the request. Check the sample rate
	//    of your media file and make sure that the two values match.
	//
	//    * Invalid file size: file size too large - The size of your audio file
	//    is larger than Amazon Transcribe can process. For more information, see
	//    Limits (https://docs.aws.amazon.com/transcribe/latest/dg/limits-guidelines.html#limits)
	//    in the Amazon Transcribe Developer Guide.
	//
	//    * Invalid number of channels: number of channels too large - Your audio
	//    contains more channels than Amazon Transcribe is configured to process.
	//    To request additional channels, see Amazon Transcribe Limits (https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits-amazon-transcribe)
	//    in the Amazon Web Services General Reference.
	FailureReason *string `type:"string"`

	// The language code for the input speech.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// An object that describes the input media for the transcription job.
	Media *Media `type:"structure"`

	// The format of the input media file.
	MediaFormat *string `type:"string" enum:"MediaFormat"`

	// The sample rate, in Hertz, of the audio track in the input media file.
	MediaSampleRateHertz *int64 `min:"8000" type:"integer"`

	// Optional settings for the transcription job. Use these settings to turn on
	// speaker recognition, to set the maximum number of speakers that should be
	// identified and to specify a custom vocabulary to use when processing the
	// transcription job.
	Settings *Settings `type:"structure"`

	// An object that describes the output of the transcription job.
	Transcript *Transcript `type:"structure"`

	// The name of the transcription job.
	TranscriptionJobName *string `min:"1" type:"string"`

	// The status of the transcription job.
	TranscriptionJobStatus *string `type:"string" enum:"TranscriptionJobStatus"`
}

// String returns the string representation
func (s TranscriptionJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TranscriptionJob) GoString() string {
	return s.String()
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *TranscriptionJob) SetCompletionTime(v time.Time) *TranscriptionJob {
	s.CompletionTime = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *TranscriptionJob) SetCreationTime(v time.Time) *TranscriptionJob {
	s.CreationTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *TranscriptionJob) SetFailureReason(v string) *TranscriptionJob {
	s.FailureReason = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *TranscriptionJob) SetLanguageCode(v string) *TranscriptionJob {
	s.LanguageCode = &v
	return s
}

// SetMedia sets the Media field's value.
func (s *TranscriptionJob) SetMedia(v *Media) *TranscriptionJob {
	s.Media = v
	return s
}

// SetMediaFormat sets the MediaFormat field's value.
func (s *TranscriptionJob) SetMediaFormat(v string) *TranscriptionJob {
	s.MediaFormat = &v
	return s
}

// SetMediaSampleRateHertz sets the MediaSampleRateHertz field's value.
func (s *TranscriptionJob) SetMediaSampleRateHertz(v int64) *TranscriptionJob {
	s.MediaSampleRateHertz = &v
	return s
}

// SetSettings sets the Settings field's value.
func (s *TranscriptionJob) SetSettings(v *Settings) *TranscriptionJob {
	s.Settings = v
	return s
}

// SetTranscript sets the Transcript field's value.
func (s *TranscriptionJob) SetTranscript(v *Transcript) *TranscriptionJob {
	s.Transcript = v
	return s
}

// SetTranscriptionJobName sets the TranscriptionJobName field's value.
func (s *TranscriptionJob) SetTranscriptionJobName(v string) *TranscriptionJob {
	s.TranscriptionJobName = &v
	return s
}

// SetTranscriptionJobStatus sets the TranscriptionJobStatus field's value.
func (s *TranscriptionJob) SetTranscriptionJobStatus(v string) *TranscriptionJob {
	s.TranscriptionJobStatus = &v
	return s
}

// Provides a summary of information about a transcription job. .
type TranscriptionJobSummary struct {
	_ struct{} `type:"structure"`

	// A timestamp that shows when the job was completed.
	CompletionTime *time.Time `type:"timestamp"`

	// A timestamp that shows when the job was created.
	CreationTime *time.Time `type:"timestamp"`

	// If the TranscriptionJobStatus field is FAILED, a description of the error.
	FailureReason *string `type:"string"`

	// The language code for the input speech.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// Indicates the location of the output of the transcription job.
	//
	// If the value is CUSTOMER_BUCKET then the location is the S3 bucket specified
	// in the outputBucketName field when the transcription job was started with
	// the StartTranscriptionJob operation.
	//
	// If the value is SERVICE_BUCKET then the output is stored by Amazon Transcribe
	// and can be retrieved using the URI in the GetTranscriptionJob response's
	// TranscriptFileUri field.
	OutputLocationType *string `type:"string" enum:"OutputLocationType"`

	// The name of the transcription job.
	TranscriptionJobName *string `min:"1" type:"string"`

	// The status of the transcription job. When the status is COMPLETED, use the
	// GetTranscriptionJob operation to get the results of the transcription.
	TranscriptionJobStatus *string `type:"string" enum:"TranscriptionJobStatus"`
}

// String returns the string representation
func (s TranscriptionJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TranscriptionJobSummary) GoString() string {
	return s.String()
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *TranscriptionJobSummary) SetCompletionTime(v time.Time) *TranscriptionJobSummary {
	s.CompletionTime = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *TranscriptionJobSummary) SetCreationTime(v time.Time) *TranscriptionJobSummary {
	s.CreationTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *TranscriptionJobSummary) SetFailureReason(v string) *TranscriptionJobSummary {
	s.FailureReason = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *TranscriptionJobSummary) SetLanguageCode(v string) *TranscriptionJobSummary {
	s.LanguageCode = &v
	return s
}

// SetOutputLocationType sets the OutputLocationType field's value.
func (s *TranscriptionJobSummary) SetOutputLocationType(v string) *TranscriptionJobSummary {
	s.OutputLocationType = &v
	return s
}

// SetTranscriptionJobName sets the TranscriptionJobName field's value.
func (s *TranscriptionJobSummary) SetTranscriptionJobName(v string) *TranscriptionJobSummary {
	s.TranscriptionJobName = &v
	return s
}

// SetTranscriptionJobStatus sets the TranscriptionJobStatus field's value.
func (s *TranscriptionJobSummary) SetTranscriptionJobStatus(v string) *TranscriptionJobSummary {
	s.TranscriptionJobStatus = &v
	return s
}

type UpdateVocabularyInput struct {
	_ struct{} `type:"structure"`

	// The language code of the vocabulary entries.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// An array of strings containing the vocabulary entries.
	Phrases []*string `type:"list"`

	// The S3 location of the text file that contains the definition of the custom
	// vocabulary. The URI must be in the same region as the API endpoint that you
	// are calling. The general form is
	//
	// https://s3-<aws-region>.amazonaws.com/<bucket-name>/<keyprefix>/<objectkey>
	//
	// For example:
	//
	// https://s3-us-east-1.amazonaws.com/examplebucket/vocab.txt
	//
	// For more information about S3 object names, see Object Keys (http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html#object-keys)
	// in the Amazon S3 Developer Guide.
	//
	// For more information about custom vocabularies, see Custom Vocabularies (http://docs.aws.amazon.com/transcribe/latest/dg/how-it-works.html#how-vocabulary).
	VocabularyFileUri *string `min:"1" type:"string"`

	// The name of the vocabulary to update. The name is case-sensitive.
	//
	// VocabularyName is a required field
	VocabularyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateVocabularyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVocabularyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVocabularyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVocabularyInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.VocabularyFileUri != nil && len(*s.VocabularyFileUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFileUri", 1))
	}
	if s.VocabularyName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyName"))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *UpdateVocabularyInput) SetLanguageCode(v string) *UpdateVocabularyInput {
	s.LanguageCode = &v
	return s
}

// SetPhrases sets the Phrases field's value.
func (s *UpdateVocabularyInput) SetPhrases(v []*string) *UpdateVocabularyInput {
	s.Phrases = v
	return s
}

// SetVocabularyFileUri sets the VocabularyFileUri field's value.
func (s *UpdateVocabularyInput) SetVocabularyFileUri(v string) *UpdateVocabularyInput {
	s.VocabularyFileUri = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *UpdateVocabularyInput) SetVocabularyName(v string) *UpdateVocabularyInput {
	s.VocabularyName = &v
	return s
}

type UpdateVocabularyOutput struct {
	_ struct{} `type:"structure"`

	// The language code of the vocabulary entries.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time that the vocabulary was updated.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the vocabulary that was updated.
	VocabularyName *string `min:"1" type:"string"`

	// The processing state of the vocabulary. When the VocabularyState field contains
	// READY the vocabulary is ready to be used in a StartTranscriptionJob request.
	VocabularyState *string `type:"string" enum:"VocabularyState"`
}

// String returns the string representation
func (s UpdateVocabularyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVocabularyOutput) GoString() string {
	return s.String()
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *UpdateVocabularyOutput) SetLanguageCode(v string) *UpdateVocabularyOutput {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *UpdateVocabularyOutput) SetLastModifiedTime(v time.Time) *UpdateVocabularyOutput {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *UpdateVocabularyOutput) SetVocabularyName(v string) *UpdateVocabularyOutput {
	s.VocabularyName = &v
	return s
}

// SetVocabularyState sets the VocabularyState field's value.
func (s *UpdateVocabularyOutput) SetVocabularyState(v string) *UpdateVocabularyOutput {
	s.VocabularyState = &v
	return s
}

// Provides information about a custom vocabulary.
type VocabularyInfo struct {
	_ struct{} `type:"structure"`

	// The language code of the vocabulary entries.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time that the vocabulary was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the vocabulary.
	VocabularyName *string `min:"1" type:"string"`

	// The processing state of the vocabulary. If the state is READY you can use
	// the vocabulary in a StartTranscriptionJob request.
	VocabularyState *string `type:"string" enum:"VocabularyState"`
}

// String returns the string representation
func (s VocabularyInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VocabularyInfo) GoString() string {
	return s.String()
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *VocabularyInfo) SetLanguageCode(v string) *VocabularyInfo {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *VocabularyInfo) SetLastModifiedTime(v time.Time) *VocabularyInfo {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *VocabularyInfo) SetVocabularyName(v string) *VocabularyInfo {
	s.VocabularyName = &v
	return s
}

// SetVocabularyState sets the VocabularyState field's value.
func (s *VocabularyInfo) SetVocabularyState(v string) *VocabularyInfo {
	s.VocabularyState = &v
	return s
}

const (
	// LanguageCodeEnUs is a LanguageCode enum value
	LanguageCodeEnUs = "en-US"

	// LanguageCodeEsUs is a LanguageCode enum value
	LanguageCodeEsUs = "es-US"

	// LanguageCodeEnAu is a LanguageCode enum value
	LanguageCodeEnAu = "en-AU"

	// LanguageCodeFrCa is a LanguageCode enum value
	LanguageCodeFrCa = "fr-CA"

	// LanguageCodeEnGb is a LanguageCode enum value
	LanguageCodeEnGb = "en-GB"

	// LanguageCodeDeDe is a LanguageCode enum value
	LanguageCodeDeDe = "de-DE"

	// LanguageCodePtBr is a LanguageCode enum value
	LanguageCodePtBr = "pt-BR"

	// LanguageCodeFrFr is a LanguageCode enum value
	LanguageCodeFrFr = "fr-FR"

	// LanguageCodeItIt is a LanguageCode enum value
	LanguageCodeItIt = "it-IT"

	// LanguageCodeKoKr is a LanguageCode enum value
	LanguageCodeKoKr = "ko-KR"
)

const (
	// MediaFormatMp3 is a MediaFormat enum value
	MediaFormatMp3 = "mp3"

	// MediaFormatMp4 is a MediaFormat enum value
	MediaFormatMp4 = "mp4"

	// MediaFormatWav is a MediaFormat enum value
	MediaFormatWav = "wav"

	// MediaFormatFlac is a MediaFormat enum value
	MediaFormatFlac = "flac"
)

const (
	// OutputLocationTypeCustomerBucket is a OutputLocationType enum value
	OutputLocationTypeCustomerBucket = "CUSTOMER_BUCKET"

	// OutputLocationTypeServiceBucket is a OutputLocationType enum value
	OutputLocationTypeServiceBucket = "SERVICE_BUCKET"
)

const (
	// TranscriptionJobStatusInProgress is a TranscriptionJobStatus enum value
	TranscriptionJobStatusInProgress = "IN_PROGRESS"

	// TranscriptionJobStatusFailed is a TranscriptionJobStatus enum value
	TranscriptionJobStatusFailed = "FAILED"

	// TranscriptionJobStatusCompleted is a TranscriptionJobStatus enum value
	TranscriptionJobStatusCompleted = "COMPLETED"
)

const (
	// VocabularyStatePending is a VocabularyState enum value
	VocabularyStatePending = "PENDING"

	// VocabularyStateReady is a VocabularyState enum value
	VocabularyStateReady = "READY"

	// VocabularyStateFailed is a VocabularyState enum value
	VocabularyStateFailed = "FAILED"
)
