package resources

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/resources/mgmt/2017-05-10/resources"

// DeploymentMode enumerates the values for deployment mode.
type DeploymentMode string

const (
	// Complete ...
	Complete DeploymentMode = "Complete"
	// Incremental ...
	Incremental DeploymentMode = "Incremental"
)

// PossibleDeploymentModeValues returns an array of possible values for the DeploymentMode const type.
func PossibleDeploymentModeValues() []DeploymentMode {
	return []DeploymentMode{Complete, Incremental}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// SystemAssigned ...
	SystemAssigned ResourceIdentityType = "SystemAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{SystemAssigned}
}

// AliasPathType the type of the paths for alias.
type AliasPathType struct {
	// Path - The path of an alias.
	Path *string `json:"path,omitempty"`
	// APIVersions - The API versions.
	APIVersions *[]string `json:"apiVersions,omitempty"`
}

// AliasType the alias type.
type AliasType struct {
	// Name - The alias name.
	Name *string `json:"name,omitempty"`
	// Paths - The paths for an alias.
	Paths *[]AliasPathType `json:"paths,omitempty"`
}

// BasicDependency deployment dependency information.
type BasicDependency struct {
	// ID - The ID of the dependency.
	ID *string `json:"id,omitempty"`
	// ResourceType - The dependency resource type.
	ResourceType *string `json:"resourceType,omitempty"`
	// ResourceName - The dependency resource name.
	ResourceName *string `json:"resourceName,omitempty"`
}

// CreateOrUpdateByIDFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CreateOrUpdateByIDFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *CreateOrUpdateByIDFuture) Result(client Client) (gr GenericResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.CreateOrUpdateByIDFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("resources.CreateOrUpdateByIDFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if gr.Response.Response, err = future.GetResult(sender); err == nil && gr.Response.Response.StatusCode != http.StatusNoContent {
		gr, err = client.CreateOrUpdateByIDResponder(gr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resources.CreateOrUpdateByIDFuture", "Result", gr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *CreateOrUpdateFuture) Result(client Client) (gr GenericResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.CreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("resources.CreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if gr.Response.Response, err = future.GetResult(sender); err == nil && gr.Response.Response.StatusCode != http.StatusNoContent {
		gr, err = client.CreateOrUpdateResponder(gr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resources.CreateOrUpdateFuture", "Result", gr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DebugSetting ...
type DebugSetting struct {
	// DetailLevel - Specifies the type of information to log for debugging. The permitted values are none, requestContent, responseContent, or both requestContent and responseContent separated by a comma. The default is none. When setting this value, carefully consider the type of information you are passing in during deployment. By logging information about the request or response, you could potentially expose sensitive data that is retrieved through the deployment operations.
	DetailLevel *string `json:"detailLevel,omitempty"`
}

// DeleteByIDFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type DeleteByIDFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DeleteByIDFuture) Result(client Client) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.DeleteByIDFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("resources.DeleteByIDFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type DeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DeleteFuture) Result(client Client) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.DeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("resources.DeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Dependency deployment dependency information.
type Dependency struct {
	// DependsOn - The list of dependencies.
	DependsOn *[]BasicDependency `json:"dependsOn,omitempty"`
	// ID - The ID of the dependency.
	ID *string `json:"id,omitempty"`
	// ResourceType - The dependency resource type.
	ResourceType *string `json:"resourceType,omitempty"`
	// ResourceName - The dependency resource name.
	ResourceName *string `json:"resourceName,omitempty"`
}

// Deployment deployment operation parameters.
type Deployment struct {
	// Properties - The deployment properties.
	Properties *DeploymentProperties `json:"properties,omitempty"`
}

// DeploymentExportResult the deployment export result.
type DeploymentExportResult struct {
	autorest.Response `json:"-"`
	// Template - The template content.
	Template interface{} `json:"template,omitempty"`
}

// DeploymentExtended deployment information.
type DeploymentExtended struct {
	autorest.Response `json:"-"`
	// ID - The ID of the deployment.
	ID *string `json:"id,omitempty"`
	// Name - The name of the deployment.
	Name *string `json:"name,omitempty"`
	// Properties - Deployment properties.
	Properties *DeploymentPropertiesExtended `json:"properties,omitempty"`
}

// DeploymentExtendedFilter deployment filter.
type DeploymentExtendedFilter struct {
	// ProvisioningState - The provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// DeploymentListResult list of deployments.
type DeploymentListResult struct {
	autorest.Response `json:"-"`
	// Value - An array of deployments.
	Value *[]DeploymentExtended `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// DeploymentListResultIterator provides access to a complete listing of DeploymentExtended values.
type DeploymentListResultIterator struct {
	i    int
	page DeploymentListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeploymentListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeploymentListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DeploymentListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeploymentListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeploymentListResultIterator) Response() DeploymentListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeploymentListResultIterator) Value() DeploymentExtended {
	if !iter.page.NotDone() {
		return DeploymentExtended{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DeploymentListResultIterator type.
func NewDeploymentListResultIterator(page DeploymentListResultPage) DeploymentListResultIterator {
	return DeploymentListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dlr DeploymentListResult) IsEmpty() bool {
	return dlr.Value == nil || len(*dlr.Value) == 0
}

// deploymentListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dlr DeploymentListResult) deploymentListResultPreparer(ctx context.Context) (*http.Request, error) {
	if dlr.NextLink == nil || len(to.String(dlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dlr.NextLink)))
}

// DeploymentListResultPage contains a page of DeploymentExtended values.
type DeploymentListResultPage struct {
	fn  func(context.Context, DeploymentListResult) (DeploymentListResult, error)
	dlr DeploymentListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeploymentListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeploymentListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.dlr)
	if err != nil {
		return err
	}
	page.dlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DeploymentListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeploymentListResultPage) NotDone() bool {
	return !page.dlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeploymentListResultPage) Response() DeploymentListResult {
	return page.dlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeploymentListResultPage) Values() []DeploymentExtended {
	if page.dlr.IsEmpty() {
		return nil
	}
	return *page.dlr.Value
}

// Creates a new instance of the DeploymentListResultPage type.
func NewDeploymentListResultPage(getNextPage func(context.Context, DeploymentListResult) (DeploymentListResult, error)) DeploymentListResultPage {
	return DeploymentListResultPage{fn: getNextPage}
}

// DeploymentOperation deployment operation information.
type DeploymentOperation struct {
	autorest.Response `json:"-"`
	// ID - Full deployment operation ID.
	ID *string `json:"id,omitempty"`
	// OperationID - Deployment operation ID.
	OperationID *string `json:"operationId,omitempty"`
	// Properties - Deployment properties.
	Properties *DeploymentOperationProperties `json:"properties,omitempty"`
}

// DeploymentOperationProperties deployment operation properties.
type DeploymentOperationProperties struct {
	// ProvisioningState - The state of the provisioning.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// Timestamp - The date and time of the operation.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// ServiceRequestID - Deployment operation service request id.
	ServiceRequestID *string `json:"serviceRequestId,omitempty"`
	// StatusCode - Operation status code.
	StatusCode *string `json:"statusCode,omitempty"`
	// StatusMessage - Operation status message.
	StatusMessage interface{} `json:"statusMessage,omitempty"`
	// TargetResource - The target resource.
	TargetResource *TargetResource `json:"targetResource,omitempty"`
	// Request - The HTTP request message.
	Request *HTTPMessage `json:"request,omitempty"`
	// Response - The HTTP response message.
	Response *HTTPMessage `json:"response,omitempty"`
}

// DeploymentOperationsListResult list of deployment operations.
type DeploymentOperationsListResult struct {
	autorest.Response `json:"-"`
	// Value - An array of deployment operations.
	Value *[]DeploymentOperation `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// DeploymentOperationsListResultIterator provides access to a complete listing of DeploymentOperation
// values.
type DeploymentOperationsListResultIterator struct {
	i    int
	page DeploymentOperationsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeploymentOperationsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeploymentOperationsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DeploymentOperationsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeploymentOperationsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeploymentOperationsListResultIterator) Response() DeploymentOperationsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeploymentOperationsListResultIterator) Value() DeploymentOperation {
	if !iter.page.NotDone() {
		return DeploymentOperation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DeploymentOperationsListResultIterator type.
func NewDeploymentOperationsListResultIterator(page DeploymentOperationsListResultPage) DeploymentOperationsListResultIterator {
	return DeploymentOperationsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dolr DeploymentOperationsListResult) IsEmpty() bool {
	return dolr.Value == nil || len(*dolr.Value) == 0
}

// deploymentOperationsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dolr DeploymentOperationsListResult) deploymentOperationsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if dolr.NextLink == nil || len(to.String(dolr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dolr.NextLink)))
}

// DeploymentOperationsListResultPage contains a page of DeploymentOperation values.
type DeploymentOperationsListResultPage struct {
	fn   func(context.Context, DeploymentOperationsListResult) (DeploymentOperationsListResult, error)
	dolr DeploymentOperationsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeploymentOperationsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeploymentOperationsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.dolr)
	if err != nil {
		return err
	}
	page.dolr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DeploymentOperationsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeploymentOperationsListResultPage) NotDone() bool {
	return !page.dolr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeploymentOperationsListResultPage) Response() DeploymentOperationsListResult {
	return page.dolr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeploymentOperationsListResultPage) Values() []DeploymentOperation {
	if page.dolr.IsEmpty() {
		return nil
	}
	return *page.dolr.Value
}

// Creates a new instance of the DeploymentOperationsListResultPage type.
func NewDeploymentOperationsListResultPage(getNextPage func(context.Context, DeploymentOperationsListResult) (DeploymentOperationsListResult, error)) DeploymentOperationsListResultPage {
	return DeploymentOperationsListResultPage{fn: getNextPage}
}

// DeploymentProperties deployment properties.
type DeploymentProperties struct {
	// Template - The template content. You use this element when you want to pass the template syntax directly in the request rather than link to an existing template. It can be a JObject or well-formed JSON string. Use either the templateLink property or the template property, but not both.
	Template interface{} `json:"template,omitempty"`
	// TemplateLink - The URI of the template. Use either the templateLink property or the template property, but not both.
	TemplateLink *TemplateLink `json:"templateLink,omitempty"`
	// Parameters - Name and value pairs that define the deployment parameters for the template. You use this element when you want to provide the parameter values directly in the request rather than link to an existing parameter file. Use either the parametersLink property or the parameters property, but not both. It can be a JObject or a well formed JSON string.
	Parameters interface{} `json:"parameters,omitempty"`
	// ParametersLink - The URI of parameters file. You use this element to link to an existing parameters file. Use either the parametersLink property or the parameters property, but not both.
	ParametersLink *ParametersLink `json:"parametersLink,omitempty"`
	// Mode - The mode that is used to deploy resources. This value can be either Incremental or Complete. In Incremental mode, resources are deployed without deleting existing resources that are not included in the template. In Complete mode, resources are deployed and existing resources in the resource group that are not included in the template are deleted. Be careful when using Complete mode as you may unintentionally delete resources. Possible values include: 'Incremental', 'Complete'
	Mode DeploymentMode `json:"mode,omitempty"`
	// DebugSetting - The debug setting of the deployment.
	DebugSetting *DebugSetting `json:"debugSetting,omitempty"`
}

// DeploymentPropertiesExtended deployment properties with additional details.
type DeploymentPropertiesExtended struct {
	// ProvisioningState - The state of the provisioning.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// CorrelationID - The correlation ID of the deployment.
	CorrelationID *string `json:"correlationId,omitempty"`
	// Timestamp - The timestamp of the template deployment.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Outputs - Key/value pairs that represent deploymentoutput.
	Outputs interface{} `json:"outputs,omitempty"`
	// Providers - The list of resource providers needed for the deployment.
	Providers *[]Provider `json:"providers,omitempty"`
	// Dependencies - The list of deployment dependencies.
	Dependencies *[]Dependency `json:"dependencies,omitempty"`
	// Template - The template content. Use only one of Template or TemplateLink.
	Template interface{} `json:"template,omitempty"`
	// TemplateLink - The URI referencing the template. Use only one of Template or TemplateLink.
	TemplateLink *TemplateLink `json:"templateLink,omitempty"`
	// Parameters - Deployment parameters. Use only one of Parameters or ParametersLink.
	Parameters interface{} `json:"parameters,omitempty"`
	// ParametersLink - The URI referencing the parameters. Use only one of Parameters or ParametersLink.
	ParametersLink *ParametersLink `json:"parametersLink,omitempty"`
	// Mode - The deployment mode. Possible values are Incremental and Complete. Possible values include: 'Incremental', 'Complete'
	Mode DeploymentMode `json:"mode,omitempty"`
	// DebugSetting - The debug setting of the deployment.
	DebugSetting *DebugSetting `json:"debugSetting,omitempty"`
}

// DeploymentsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DeploymentsCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DeploymentsCreateOrUpdateFuture) Result(client DeploymentsClient) (de DeploymentExtended, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.DeploymentsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("resources.DeploymentsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if de.Response.Response, err = future.GetResult(sender); err == nil && de.Response.Response.StatusCode != http.StatusNoContent {
		de, err = client.CreateOrUpdateResponder(de.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resources.DeploymentsCreateOrUpdateFuture", "Result", de.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DeploymentsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DeploymentsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *DeploymentsDeleteFuture) Result(client DeploymentsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.DeploymentsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("resources.DeploymentsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DeploymentValidateResult information from validate template deployment response.
type DeploymentValidateResult struct {
	autorest.Response `json:"-"`
	// Error - Validation error.
	Error *ManagementErrorWithDetails `json:"error,omitempty"`
	// Properties - The template deployment properties.
	Properties *DeploymentPropertiesExtended `json:"properties,omitempty"`
}

// ExportTemplateRequest export resource group template request parameters.
type ExportTemplateRequest struct {
	// ResourcesProperty - The IDs of the resources. The only supported string currently is '*' (all resources). Future updates will support exporting specific resources.
	ResourcesProperty *[]string `json:"resources,omitempty"`
	// Options - The export template options. Supported values include 'IncludeParameterDefaultValue', 'IncludeComments' or 'IncludeParameterDefaultValue, IncludeComments
	Options *string `json:"options,omitempty"`
}

// GenericResource resource information.
type GenericResource struct {
	autorest.Response `json:"-"`
	// Plan - The plan of the resource.
	Plan *Plan `json:"plan,omitempty"`
	// Properties - The resource properties.
	Properties interface{} `json:"properties,omitempty"`
	// Kind - The kind of the resource.
	Kind *string `json:"kind,omitempty"`
	// ManagedBy - ID of the resource that manages this resource.
	ManagedBy *string `json:"managedBy,omitempty"`
	// Sku - The SKU of the resource.
	Sku *Sku `json:"sku,omitempty"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// ID - Resource ID
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for GenericResource.
func (gr GenericResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gr.Plan != nil {
		objectMap["plan"] = gr.Plan
	}
	if gr.Properties != nil {
		objectMap["properties"] = gr.Properties
	}
	if gr.Kind != nil {
		objectMap["kind"] = gr.Kind
	}
	if gr.ManagedBy != nil {
		objectMap["managedBy"] = gr.ManagedBy
	}
	if gr.Sku != nil {
		objectMap["sku"] = gr.Sku
	}
	if gr.Identity != nil {
		objectMap["identity"] = gr.Identity
	}
	if gr.ID != nil {
		objectMap["id"] = gr.ID
	}
	if gr.Name != nil {
		objectMap["name"] = gr.Name
	}
	if gr.Type != nil {
		objectMap["type"] = gr.Type
	}
	if gr.Location != nil {
		objectMap["location"] = gr.Location
	}
	if gr.Tags != nil {
		objectMap["tags"] = gr.Tags
	}
	return json.Marshal(objectMap)
}

// GenericResourceFilter resource filter.
type GenericResourceFilter struct {
	// ResourceType - The resource type.
	ResourceType *string `json:"resourceType,omitempty"`
	// Tagname - The tag name.
	Tagname *string `json:"tagname,omitempty"`
	// Tagvalue - The tag value.
	Tagvalue *string `json:"tagvalue,omitempty"`
}

// Group resource group information.
type Group struct {
	autorest.Response `json:"-"`
	// ID - The ID of the resource group.
	ID *string `json:"id,omitempty"`
	// Name - The name of the resource group.
	Name       *string          `json:"name,omitempty"`
	Properties *GroupProperties `json:"properties,omitempty"`
	// Location - The location of the resource group. It cannot be changed after the resource group has been created. It must be one of the supported Azure locations.
	Location *string `json:"location,omitempty"`
	// ManagedBy - The ID of the resource that manages this resource group.
	ManagedBy *string `json:"managedBy,omitempty"`
	// Tags - The tags attached to the resource group.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Group.
func (g Group) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if g.ID != nil {
		objectMap["id"] = g.ID
	}
	if g.Name != nil {
		objectMap["name"] = g.Name
	}
	if g.Properties != nil {
		objectMap["properties"] = g.Properties
	}
	if g.Location != nil {
		objectMap["location"] = g.Location
	}
	if g.ManagedBy != nil {
		objectMap["managedBy"] = g.ManagedBy
	}
	if g.Tags != nil {
		objectMap["tags"] = g.Tags
	}
	return json.Marshal(objectMap)
}

// GroupExportResult resource group export result.
type GroupExportResult struct {
	autorest.Response `json:"-"`
	// Template - The template content.
	Template interface{} `json:"template,omitempty"`
	// Error - The error.
	Error *ManagementErrorWithDetails `json:"error,omitempty"`
}

// GroupFilter resource group filter.
type GroupFilter struct {
	// TagName - The tag name.
	TagName *string `json:"tagName,omitempty"`
	// TagValue - The tag value.
	TagValue *string `json:"tagValue,omitempty"`
}

// GroupListResult list of resource groups.
type GroupListResult struct {
	autorest.Response `json:"-"`
	// Value - An array of resource groups.
	Value *[]Group `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// GroupListResultIterator provides access to a complete listing of Group values.
type GroupListResultIterator struct {
	i    int
	page GroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *GroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *GroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter GroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter GroupListResultIterator) Response() GroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter GroupListResultIterator) Value() Group {
	if !iter.page.NotDone() {
		return Group{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the GroupListResultIterator type.
func NewGroupListResultIterator(page GroupListResultPage) GroupListResultIterator {
	return GroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (glr GroupListResult) IsEmpty() bool {
	return glr.Value == nil || len(*glr.Value) == 0
}

// groupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (glr GroupListResult) groupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if glr.NextLink == nil || len(to.String(glr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(glr.NextLink)))
}

// GroupListResultPage contains a page of Group values.
type GroupListResultPage struct {
	fn  func(context.Context, GroupListResult) (GroupListResult, error)
	glr GroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *GroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.glr)
	if err != nil {
		return err
	}
	page.glr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *GroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page GroupListResultPage) NotDone() bool {
	return !page.glr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page GroupListResultPage) Response() GroupListResult {
	return page.glr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page GroupListResultPage) Values() []Group {
	if page.glr.IsEmpty() {
		return nil
	}
	return *page.glr.Value
}

// Creates a new instance of the GroupListResultPage type.
func NewGroupListResultPage(getNextPage func(context.Context, GroupListResult) (GroupListResult, error)) GroupListResultPage {
	return GroupListResultPage{fn: getNextPage}
}

// GroupPatchable resource group information.
type GroupPatchable struct {
	// Name - The name of the resource group.
	Name       *string          `json:"name,omitempty"`
	Properties *GroupProperties `json:"properties,omitempty"`
	// ManagedBy - The ID of the resource that manages this resource group.
	ManagedBy *string `json:"managedBy,omitempty"`
	// Tags - The tags attached to the resource group.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for GroupPatchable.
func (gp GroupPatchable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gp.Name != nil {
		objectMap["name"] = gp.Name
	}
	if gp.Properties != nil {
		objectMap["properties"] = gp.Properties
	}
	if gp.ManagedBy != nil {
		objectMap["managedBy"] = gp.ManagedBy
	}
	if gp.Tags != nil {
		objectMap["tags"] = gp.Tags
	}
	return json.Marshal(objectMap)
}

// GroupProperties the resource group properties.
type GroupProperties struct {
	// ProvisioningState - The provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// GroupsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type GroupsDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *GroupsDeleteFuture) Result(client GroupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.GroupsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("resources.GroupsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// HTTPMessage HTTP message.
type HTTPMessage struct {
	// Content - HTTP message content.
	Content interface{} `json:"content,omitempty"`
}

// Identity identity for the resource.
type Identity struct {
	// PrincipalID - The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The identity type. Possible values include: 'SystemAssigned'
	Type ResourceIdentityType `json:"type,omitempty"`
}

// ListResult list of resource groups.
type ListResult struct {
	autorest.Response `json:"-"`
	// Value - An array of resources.
	Value *[]GenericResource `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListResultIterator provides access to a complete listing of GenericResource values.
type ListResultIterator struct {
	i    int
	page ListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListResultIterator) Response() ListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListResultIterator) Value() GenericResource {
	if !iter.page.NotDone() {
		return GenericResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListResultIterator type.
func NewListResultIterator(page ListResultPage) ListResultIterator {
	return ListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lr ListResult) IsEmpty() bool {
	return lr.Value == nil || len(*lr.Value) == 0
}

// listResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lr ListResult) listResultPreparer(ctx context.Context) (*http.Request, error) {
	if lr.NextLink == nil || len(to.String(lr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lr.NextLink)))
}

// ListResultPage contains a page of GenericResource values.
type ListResultPage struct {
	fn func(context.Context, ListResult) (ListResult, error)
	lr ListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.lr)
	if err != nil {
		return err
	}
	page.lr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListResultPage) NotDone() bool {
	return !page.lr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListResultPage) Response() ListResult {
	return page.lr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListResultPage) Values() []GenericResource {
	if page.lr.IsEmpty() {
		return nil
	}
	return *page.lr.Value
}

// Creates a new instance of the ListResultPage type.
func NewListResultPage(getNextPage func(context.Context, ListResult) (ListResult, error)) ListResultPage {
	return ListResultPage{fn: getNextPage}
}

// ManagementErrorWithDetails the detailed error message of resource management.
type ManagementErrorWithDetails struct {
	// Code - The error code returned when exporting the template.
	Code *string `json:"code,omitempty"`
	// Message - The error message describing the export error.
	Message *string `json:"message,omitempty"`
	// Target - The target of the error.
	Target *string `json:"target,omitempty"`
	// Details - Validation error.
	Details *[]ManagementErrorWithDetails `json:"details,omitempty"`
}

// MoveInfo parameters of move resources.
type MoveInfo struct {
	// ResourcesProperty - The IDs of the resources.
	ResourcesProperty *[]string `json:"resources,omitempty"`
	// TargetResourceGroup - The target resource group.
	TargetResourceGroup *string `json:"targetResourceGroup,omitempty"`
}

// MoveResourcesFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type MoveResourcesFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *MoveResourcesFuture) Result(client Client) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.MoveResourcesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("resources.MoveResourcesFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ParametersLink entity representing the reference to the deployment paramaters.
type ParametersLink struct {
	// URI - The URI of the parameters file.
	URI *string `json:"uri,omitempty"`
	// ContentVersion - If included, must match the ContentVersion in the template.
	ContentVersion *string `json:"contentVersion,omitempty"`
}

// Plan plan for the resource.
type Plan struct {
	// Name - The plan ID.
	Name *string `json:"name,omitempty"`
	// Publisher - The publisher ID.
	Publisher *string `json:"publisher,omitempty"`
	// Product - The offer ID.
	Product *string `json:"product,omitempty"`
	// PromotionCode - The promotion code.
	PromotionCode *string `json:"promotionCode,omitempty"`
	// Version - The plan's version.
	Version *string `json:"version,omitempty"`
}

// Provider resource provider information.
type Provider struct {
	autorest.Response `json:"-"`
	// ID - The provider ID.
	ID *string `json:"id,omitempty"`
	// Namespace - The namespace of the resource provider.
	Namespace *string `json:"namespace,omitempty"`
	// RegistrationState - The registration state of the provider.
	RegistrationState *string `json:"registrationState,omitempty"`
	// ResourceTypes - The collection of provider resource types.
	ResourceTypes *[]ProviderResourceType `json:"resourceTypes,omitempty"`
}

// ProviderListResult list of resource providers.
type ProviderListResult struct {
	autorest.Response `json:"-"`
	// Value - An array of resource providers.
	Value *[]Provider `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProviderListResultIterator provides access to a complete listing of Provider values.
type ProviderListResultIterator struct {
	i    int
	page ProviderListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProviderListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProviderListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProviderListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProviderListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProviderListResultIterator) Response() ProviderListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProviderListResultIterator) Value() Provider {
	if !iter.page.NotDone() {
		return Provider{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProviderListResultIterator type.
func NewProviderListResultIterator(page ProviderListResultPage) ProviderListResultIterator {
	return ProviderListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (plr ProviderListResult) IsEmpty() bool {
	return plr.Value == nil || len(*plr.Value) == 0
}

// providerListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plr ProviderListResult) providerListResultPreparer(ctx context.Context) (*http.Request, error) {
	if plr.NextLink == nil || len(to.String(plr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plr.NextLink)))
}

// ProviderListResultPage contains a page of Provider values.
type ProviderListResultPage struct {
	fn  func(context.Context, ProviderListResult) (ProviderListResult, error)
	plr ProviderListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProviderListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProviderListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.plr)
	if err != nil {
		return err
	}
	page.plr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProviderListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProviderListResultPage) NotDone() bool {
	return !page.plr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProviderListResultPage) Response() ProviderListResult {
	return page.plr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProviderListResultPage) Values() []Provider {
	if page.plr.IsEmpty() {
		return nil
	}
	return *page.plr.Value
}

// Creates a new instance of the ProviderListResultPage type.
func NewProviderListResultPage(getNextPage func(context.Context, ProviderListResult) (ProviderListResult, error)) ProviderListResultPage {
	return ProviderListResultPage{fn: getNextPage}
}

// ProviderOperationDisplayProperties resource provider operation's display properties.
type ProviderOperationDisplayProperties struct {
	// Publisher - Operation description.
	Publisher *string `json:"publisher,omitempty"`
	// Provider - Operation provider.
	Provider *string `json:"provider,omitempty"`
	// Resource - Operation resource.
	Resource *string `json:"resource,omitempty"`
	// Operation - The operation name.
	Operation *string `json:"operation,omitempty"`
	// Description - Operation description.
	Description *string `json:"description,omitempty"`
}

// ProviderResourceType resource type managed by the resource provider.
type ProviderResourceType struct {
	// ResourceType - The resource type.
	ResourceType *string `json:"resourceType,omitempty"`
	// Locations - The collection of locations where this resource type can be created.
	Locations *[]string `json:"locations,omitempty"`
	// Aliases - The aliases that are supported by this resource type.
	Aliases *[]AliasType `json:"aliases,omitempty"`
	// APIVersions - The API version.
	APIVersions *[]string `json:"apiVersions,omitempty"`
	// Properties - The properties.
	Properties map[string]*string `json:"properties"`
}

// MarshalJSON is the custom marshaler for ProviderResourceType.
func (prt ProviderResourceType) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if prt.ResourceType != nil {
		objectMap["resourceType"] = prt.ResourceType
	}
	if prt.Locations != nil {
		objectMap["locations"] = prt.Locations
	}
	if prt.Aliases != nil {
		objectMap["aliases"] = prt.Aliases
	}
	if prt.APIVersions != nil {
		objectMap["apiVersions"] = prt.APIVersions
	}
	if prt.Properties != nil {
		objectMap["properties"] = prt.Properties
	}
	return json.Marshal(objectMap)
}

// Resource basic set of the resource properties.
type Resource struct {
	// ID - Resource ID
	ID *string `json:"id,omitempty"`
	// Name - Resource name
	Name *string `json:"name,omitempty"`
	// Type - Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.Type != nil {
		objectMap["type"] = r.Type
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// Sku SKU for the resource.
type Sku struct {
	// Name - The SKU name.
	Name *string `json:"name,omitempty"`
	// Tier - The SKU tier.
	Tier *string `json:"tier,omitempty"`
	// Size - The SKU size.
	Size *string `json:"size,omitempty"`
	// Family - The SKU family.
	Family *string `json:"family,omitempty"`
	// Model - The SKU model.
	Model *string `json:"model,omitempty"`
	// Capacity - The SKU capacity.
	Capacity *int32 `json:"capacity,omitempty"`
}

// SubResource sub-resource.
type SubResource struct {
	// ID - Resource ID
	ID *string `json:"id,omitempty"`
}

// TagCount tag count.
type TagCount struct {
	// Type - Type of count.
	Type *string `json:"type,omitempty"`
	// Value - Value of count.
	Value *int32 `json:"value,omitempty"`
}

// TagDetails tag details.
type TagDetails struct {
	autorest.Response `json:"-"`
	// ID - The tag ID.
	ID *string `json:"id,omitempty"`
	// TagName - The tag name.
	TagName *string `json:"tagName,omitempty"`
	// Count - The total number of resources that use the resource tag. When a tag is initially created and has no associated resources, the value is 0.
	Count *TagCount `json:"count,omitempty"`
	// Values - The list of tag values.
	Values *[]TagValue `json:"values,omitempty"`
}

// TagsListResult list of subscription tags.
type TagsListResult struct {
	autorest.Response `json:"-"`
	// Value - An array of tags.
	Value *[]TagDetails `json:"value,omitempty"`
	// NextLink - The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// TagsListResultIterator provides access to a complete listing of TagDetails values.
type TagsListResultIterator struct {
	i    int
	page TagsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TagsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TagsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TagsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TagsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TagsListResultIterator) Response() TagsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TagsListResultIterator) Value() TagDetails {
	if !iter.page.NotDone() {
		return TagDetails{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TagsListResultIterator type.
func NewTagsListResultIterator(page TagsListResultPage) TagsListResultIterator {
	return TagsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tlr TagsListResult) IsEmpty() bool {
	return tlr.Value == nil || len(*tlr.Value) == 0
}

// tagsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tlr TagsListResult) tagsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if tlr.NextLink == nil || len(to.String(tlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tlr.NextLink)))
}

// TagsListResultPage contains a page of TagDetails values.
type TagsListResultPage struct {
	fn  func(context.Context, TagsListResult) (TagsListResult, error)
	tlr TagsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TagsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TagsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.tlr)
	if err != nil {
		return err
	}
	page.tlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TagsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TagsListResultPage) NotDone() bool {
	return !page.tlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TagsListResultPage) Response() TagsListResult {
	return page.tlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TagsListResultPage) Values() []TagDetails {
	if page.tlr.IsEmpty() {
		return nil
	}
	return *page.tlr.Value
}

// Creates a new instance of the TagsListResultPage type.
func NewTagsListResultPage(getNextPage func(context.Context, TagsListResult) (TagsListResult, error)) TagsListResultPage {
	return TagsListResultPage{fn: getNextPage}
}

// TagValue tag information.
type TagValue struct {
	autorest.Response `json:"-"`
	// ID - The tag ID.
	ID *string `json:"id,omitempty"`
	// TagValue - The tag value.
	TagValue *string `json:"tagValue,omitempty"`
	// Count - The tag value count.
	Count *TagCount `json:"count,omitempty"`
}

// TargetResource target resource.
type TargetResource struct {
	// ID - The ID of the resource.
	ID *string `json:"id,omitempty"`
	// ResourceName - The name of the resource.
	ResourceName *string `json:"resourceName,omitempty"`
	// ResourceType - The type of the resource.
	ResourceType *string `json:"resourceType,omitempty"`
}

// TemplateLink entity representing the reference to the template.
type TemplateLink struct {
	// URI - The URI of the template to deploy.
	URI *string `json:"uri,omitempty"`
	// ContentVersion - If included, must match the ContentVersion in the template.
	ContentVersion *string `json:"contentVersion,omitempty"`
}

// UpdateByIDFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type UpdateByIDFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *UpdateByIDFuture) Result(client Client) (gr GenericResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.UpdateByIDFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("resources.UpdateByIDFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if gr.Response.Response, err = future.GetResult(sender); err == nil && gr.Response.Response.StatusCode != http.StatusNoContent {
		gr, err = client.UpdateByIDResponder(gr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resources.UpdateByIDFuture", "Result", gr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// UpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type UpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *UpdateFuture) Result(client Client) (gr GenericResource, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.UpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("resources.UpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if gr.Response.Response, err = future.GetResult(sender); err == nil && gr.Response.Response.StatusCode != http.StatusNoContent {
		gr, err = client.UpdateResponder(gr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resources.UpdateFuture", "Result", gr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ValidateMoveResourcesFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ValidateMoveResourcesFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *ValidateMoveResourcesFuture) Result(client Client) (ar autorest.Response, err error) {
	var done bool
	done, err = future.Done(client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.ValidateMoveResourcesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("resources.ValidateMoveResourcesFuture")
		return
	}
	ar.Response = future.Response()
	return
}
