package servicefabric

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// ClusterHealthsClient is the client for the ClusterHealths methods of the Servicefabric service.
type ClusterHealthsClient struct {
	BaseClient
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// NewClusterHealthsClient creates an instance of the ClusterHealthsClient client.
func NewClusterHealthsClient(timeout *int32) ClusterHealthsClient {
	return NewClusterHealthsClientWithBaseURI(DefaultBaseURI, timeout)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// NewClusterHealthsClientWithBaseURI creates an instance of the ClusterHealthsClient client.
func NewClusterHealthsClientWithBaseURI(baseURI string, timeout *int32) ClusterHealthsClient {
	return ClusterHealthsClient{NewWithBaseURI(baseURI, timeout)}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// Get get cluster healths
// Parameters:
// eventsHealthStateFilter - the filter of the events health state
// nodesHealthStateFilter - the filter of the nodes health state
// applicationsHealthStateFilter - the filter of the applications health state
func (client ClusterHealthsClient) Get(ctx context.Context, eventsHealthStateFilter string, nodesHealthStateFilter string, applicationsHealthStateFilter string) (result ClusterHealth, err error) {
	req, err := client.GetPreparer(ctx, eventsHealthStateFilter, nodesHealthStateFilter, applicationsHealthStateFilter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ClusterHealthsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "servicefabric.ClusterHealthsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ClusterHealthsClient", "Get", resp, "Failure responding to request")
	}

	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// GetPreparer prepares the Get request.
func (client ClusterHealthsClient) GetPreparer(ctx context.Context, eventsHealthStateFilter string, nodesHealthStateFilter string, applicationsHealthStateFilter string) (*http.Request, error) {
	const APIVersion = "1.0.0"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(eventsHealthStateFilter) > 0 {
		queryParameters["EventsHealthStateFilter"] = autorest.Encode("query", eventsHealthStateFilter)
	}
	if len(nodesHealthStateFilter) > 0 {
		queryParameters["NodesHealthStateFilter"] = autorest.Encode("query", nodesHealthStateFilter)
	}
	if len(applicationsHealthStateFilter) > 0 {
		queryParameters["ApplicationsHealthStateFilter"] = autorest.Encode("query", applicationsHealthStateFilter)
	}
	if client.Timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *client.Timeout)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/$/GetClusterHealth"),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client ClusterHealthsClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client ClusterHealthsClient) GetResponder(resp *http.Response) (result ClusterHealth, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// Send report cluster healths
// Parameters:
// clusterHealthReport - the report of the cluster health
func (client ClusterHealthsClient) Send(ctx context.Context, clusterHealthReport ClusterHealthReport) (result String, err error) {
	req, err := client.SendPreparer(ctx, clusterHealthReport)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ClusterHealthsClient", "Send", nil, "Failure preparing request")
		return
	}

	resp, err := client.SendSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "servicefabric.ClusterHealthsClient", "Send", resp, "Failure sending request")
		return
	}

	result, err = client.SendResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabric.ClusterHealthsClient", "Send", resp, "Failure responding to request")
	}

	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// SendPreparer prepares the Send request.
func (client ClusterHealthsClient) SendPreparer(ctx context.Context, clusterHealthReport ClusterHealthReport) (*http.Request, error) {
	const APIVersion = "1.0.0"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if client.Timeout != nil {
		queryParameters["timeout"] = autorest.Encode("query", *client.Timeout)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPath("/$/ReportClusterHealth"),
		autorest.WithJSON(clusterHealthReport),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// SendSender sends the Send request. The method will close the
// http.Response Body if it receives an error.
func (client ClusterHealthsClient) SendSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/servicefabric/6.2/servicefabric instead
// SendResponder handles the response to the Send request. The method always
// closes the http.Response Body.
func (client ClusterHealthsClient) SendResponder(resp *http.Response) (result String, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
