# Windows Machine Config Bootstrapper

Bootstrapper is the entity responsible for bootstrapping a Windows node. The current scope of this component is to
perform an one shot configuration of the Windows node to ensure that it can be become a worker node. Following are the
jobs that the bootstrapper does:
- Parse the worker ignition file to get the bootstrap kubeconfig
- Ensures that the kubelet gets the correct kubelet config
- Perform CNI configuration
- Run the kubelet as a windows service

Once the bootstrapper has been run and the CSR associated with the Windows node is approved, the Windows 
node will have a taint called `os=Windows:NoSchedule`, only the pods with matching toleration can 
be scheduled onto the Windows node. An example pod spec with the toleration would be:

```
tolerations:
  - key: "os"
    operator: "Equal"
    value: "Windows"
    effect: "NoSchedule"
```

This will be remotely invoked from a Ansible script or can be run locally

## Requirements

- Must be run on Windows server 2019
- Must be run as administrator
- A worker ignition file generated by the cluster must be on disk
- The kubelet you wish to use must be on disk. Currently we support v1.16.2
- If running on AWS, the Windows instance must have the same tags as the other worker nodes in the cluster
- For CNI, the following is required:
  * HNS overlay network has been created
  * A directory with all the [CNI binaries](https://github.com/containernetworking/plugins/releases/download/v0.8.2/cni-plugins-windows-amd64-v0.8.2.tgz)
  * A [CNI v2 or v3 configuration file](https://github.com/containernetworking/cni/blob/master/SPEC.md#network-configuration)

## Usage
```
make build
```

```
wmcb initialize-kubelet --ignition-file $IGNITION_FILE_PATH --kubelet-path $KUBELET_PATH
wmcb configure-cni --cni-dir $CNI_BIN_DIR --cni-config $CNI_CONFIG
```

`configure-cni` needs to be executed only after `initialize-kubelet` is executed. If `initialize-kubelet` is executed
after `configure-cni` is executed, all the CNI options will be removed. This is to give the user a chance to change
network configuration to something other than CNI after the initial setup.

## Testing

### Windows Machine Config Bootstrapper

#### End to end testing
The following environment variables need to be set for running the end to end tests:
- ARTIFACT_DIR
  - This can be set to any directory
- AWS_SHARED_CREDENTIALS_FILE
  - Set this to point to your AWS credentials file
- KUBE_SSH_KEY_PATH
  - The ssh key used to bring up the VM
- WMCB_IMAGE
  - Registry url for remote WMCB image that needs to be tested. eg. quay.io/<USERNAME>/<IMAGE>:<TAG>

To build the WMCB image, execute:
```
podman build -f Dockerfile.tools -t quay.io/<USERNAME>/<IMAGE>:<TAG> .
``` 
The WMCB image needs to be pushed to a remote repository:
```
podman push quay.io/<USERNAME>/<IMAGE>:<TAG>
```

Once the above variables are set, you can run the unit and end to end tests by executing:
```shell script
$ hack/run-wmcb-ci-e2e-test.sh
```

Inorder to skip MachineSet setup, add `-skipVMSetup` argument to `args` field in `internal/test/wmcb/deploy/job.yaml`.
A MachineSet with label `machine.openshift.io/os-id=Windows` needs to be created, and the Machine should be in `Provisioned` 
state in order to use `-skipVMSetup`. Test suite will use the mounted private key to access the Machine created. 
Using an already `Provisioned` VM would reduce the wait time to run the test from 12 minute to just 1 minute.
