import { SourceMap } from 'magic-string';
import Module from './Module';
import { OutputOptions } from './rollup/index';
import Graph from './Graph';
import ExternalModule from './ExternalModule';
import Variable from './ast/variables/Variable';
import { Addons } from './utils/addons';
export interface ModuleDeclarations {
    exports: ChunkExports;
    dependencies: ModuleDeclarationDependency[];
}
export interface ModuleDeclarationDependency {
    id: string;
    name: string;
    globalName: string;
    isChunk: boolean;
    exportsDefault: boolean;
    exportsNames: boolean;
    exportsNamespace: boolean;
    reexports?: ReexportSpecifier[];
    imports?: ImportSpecifier[];
}
export declare type ChunkDependencies = ModuleDeclarationDependency[];
export declare type ChunkExports = {
    local: string;
    exported: string;
    hoisted: boolean;
}[];
export interface ReexportSpecifier {
    reexported: string;
    imported: string;
}
export interface ImportSpecifier {
    local: string;
    imported: string;
}
export interface DynamicImportMechanism {
    left: string;
    right: string;
    interopLeft?: string;
    interopRight?: string;
}
export default class Chunk {
    hasDynamicImport: boolean;
    indentString: string;
    usedModules: Module[];
    id: string;
    name: string;
    graph: Graph;
    private orderedModules;
    private imports;
    private exports;
    private exportNames;
    private dependencies;
    entryModule: Module;
    isEntryModuleFacade: boolean;
    isManualChunk: boolean;
    private renderedHash;
    private renderedModuleSources;
    private renderedSource;
    private renderedSourceLength;
    private renderedDeclarations;
    constructor(graph: Graph, orderedModules: Module[]);
    getImportIds(): string[];
    getExportNames(): string[];
    getModuleIds(): string[];
    private inlineDeepModuleDependencies();
    linkFacade(entryFacade: Module): void;
    link(): void;
    populateEntryExports(preserveModules: boolean): void;
    private traceImport(exportName, module);
    traceExport(name: string, module: Module | ExternalModule): {
        variable: Variable;
        module: Module | ExternalModule;
    };
    getVariableExportName(variable: Variable): string;
    generateInternalExports(options: OutputOptions): void;
    private prepareDynamicImports({format});
    private finaliseDynamicImports();
    private setIdentifierRenderResolutions(options);
    private getChunkDependencyDeclarations(options);
    private getChunkExportDeclarations();
    getRenderedHash(): string;
    postVisitChunkDependencies(visitor: (dep: Chunk | ExternalModule) => any): boolean;
    private computeFullHash(addons, options);
    preRender(options: OutputOptions): void;
    getRenderedSourceLength(): number;
    merge(chunk: Chunk, chunkList: Chunk[], options: OutputOptions): void;
    generateNamePreserveModules(preserveModulesRelativeDir: string): string;
    generateName(pattern: string, addons: Addons, options: OutputOptions, existingNames?: {
        [name: string]: boolean;
    }): void;
    render(options: OutputOptions, addons: Addons): Promise<{
        code: string;
        map: SourceMap;
    }>;
}
