// Code generated by golang.org/x/tools/cmd/bundle. DO NOT EDIT.
//   $ bundle -pkg godo -prefix  ./dev/dist/godo

package godo

import ()

// AppDatabaseSpec struct for AppDatabaseSpec
type AppDatabaseSpec struct {
	Name        string                `json:"name"`
	Engine      AppDatabaseSpecEngine `json:"engine,omitempty"`
	Version     string                `json:"version,omitempty"`
	Size        string                `json:"size,omitempty"`
	NumNodes    int64                 `json:"num_nodes,omitempty"`
	Production  bool                  `json:"production,omitempty"`
	ClusterName string                `json:"cluster_name,omitempty"`
	DbName      string                `json:"db_name,omitempty"`
	DbUser      string                `json:"db_user,omitempty"`
}

// AppDatabaseSpecEngine the model 'AppDatabaseSpecEngine'
type AppDatabaseSpecEngine string

// List of AppDatabaseSpecEngine
const (
	APPDATABASESPECENGINE_UNSET AppDatabaseSpecEngine = "UNSET"
	APPDATABASESPECENGINE_MYSQL AppDatabaseSpecEngine = "MYSQL"
	APPDATABASESPECENGINE_PG    AppDatabaseSpecEngine = "PG"
	APPDATABASESPECENGINE_REDIS AppDatabaseSpecEngine = "REDIS"
)

// AppDomainSpec struct for AppDomainSpec
type AppDomainSpec struct {
	Domain string            `json:"domain"`
	Type   AppDomainSpecType `json:"type,omitempty"`
}

// AppDomainSpecType the model 'AppDomainSpecType'
type AppDomainSpecType string

// List of AppDomainSpecType
const (
	APPDOMAINSPECTYPE_UNSPECIFIED AppDomainSpecType = "UNSPECIFIED"
	APPDOMAINSPECTYPE_DEFAULT     AppDomainSpecType = "DEFAULT"
	APPDOMAINSPECTYPE_PRIMARY     AppDomainSpecType = "PRIMARY"
	APPDOMAINSPECTYPE_ALIAS       AppDomainSpecType = "ALIAS"
)

// AppJobSpec struct for AppJobSpec
type AppJobSpec struct {
	Name             string                  `json:"name"`
	RunCommand       string                  `json:"run_command,omitempty"`
	BuildCommand     string                  `json:"build_command,omitempty"`
	DockerfilePath   string                  `json:"dockerfile_path,omitempty"`
	Git              GitSourceSpec           `json:"git,omitempty"`
	GitHub           GitHubSourceSpec        `json:"github,omitempty"`
	Envs             []AppVariableDefinition `json:"envs,omitempty"`
	InstanceSizeSlug string                  `json:"instance_size_slug,omitempty"`
	InstanceCount    int64                   `json:"instance_count,omitempty"`
	SourceDir        string                  `json:"source_dir,omitempty"`
	EnvironmentSlug  string                  `json:"environment_slug,omitempty"`
}

// AppRouteSpec AppRouteSpec describes a criteria for routing HTTP traffic to the component.
type AppRouteSpec struct {
	// Path specifies an route by HTTP path prefix. Paths must start with / and must be unique within the app.
	Path string `json:"path,omitempty"`
}

// AppServiceSpec struct for AppServiceSpec
type AppServiceSpec struct {
	Name             string                    `json:"name"`
	RunCommand       string                    `json:"run_command,omitempty"`
	BuildCommand     string                    `json:"build_command,omitempty"`
	HTTPPort         int64                     `json:"http_port,omitempty"`
	DockerfilePath   string                    `json:"dockerfile_path,omitempty"`
	Git              GitSourceSpec             `json:"git,omitempty"`
	GitHub           GitHubSourceSpec          `json:"github,omitempty"`
	Envs             []AppVariableDefinition   `json:"envs,omitempty"`
	InstanceSizeSlug string                    `json:"instance_size_slug,omitempty"`
	InstanceCount    int64                     `json:"instance_count,omitempty"`
	Routes           []AppRouteSpec            `json:"routes,omitempty"`
	SourceDir        string                    `json:"source_dir,omitempty"`
	EnvironmentSlug  string                    `json:"environment_slug,omitempty"`
	HealthCheck      AppServiceSpecHealthCheck `json:"health_check,omitempty"`
}

// AppServiceSpecHealthCheck struct for AppServiceSpecHealthCheck
type AppServiceSpecHealthCheck struct {
	// Path is the route path used for the HTTP health check ping.
	Path string `json:"path,omitempty"`
}

// AppSpec AppSpec declares the desired configuration of an application.
type AppSpec struct {
	// Services describe workloads which expose an HTTP service.
	Services []AppServiceSpec `json:"services,omitempty"`
	// Static sites describe content which can be rendered to static web assets.
	StaticSites []AppStaticSiteSpec `json:"static_sites,omitempty"`
	// Databases provide database instances which can provide persistence to workloads within the application.
	Databases []AppDatabaseSpec `json:"databases,omitempty"`
	// Workers describe workloads which do not expose HTTP routes publicly.
	Workers []AppWorkerSpec `json:"workers,omitempty"`
	Region  string          `json:"region,omitempty"`
	Name    string          `json:"name"`
	// Domains provides a set of hostnames where the application will be available.
	Domains []AppDomainSpec `json:"domains,omitempty"`
	// Jobs describe one-time or recurring workloads which do not expose HTTP routes publicly.
	Jobs []AppJobSpec `json:"jobs,omitempty"`
}

// AppStaticSiteSpec struct for AppStaticSiteSpec
type AppStaticSiteSpec struct {
	Name            string                  `json:"name"`
	DockerfilePath  string                  `json:"dockerfile_path,omitempty"`
	BuildCommand    string                  `json:"build_command,omitempty"`
	Git             GitSourceSpec           `json:"git,omitempty"`
	GitHub          GitHubSourceSpec        `json:"github,omitempty"`
	Envs            []AppVariableDefinition `json:"envs,omitempty"`
	Routes          []AppRouteSpec          `json:"routes,omitempty"`
	SourceDir       string                  `json:"source_dir,omitempty"`
	OutputDir       string                  `json:"output_dir,omitempty"`
	EnvironmentSlug string                  `json:"environment_slug,omitempty"`
	IndexDocument   string                  `json:"index_document,omitempty"`
	ErrorDocument   string                  `json:"error_document,omitempty"`
}

// AppVariableDefinition struct for AppVariableDefinition
type AppVariableDefinition struct {
	Value string        `json:"value,omitempty"`
	Scope VariableScope `json:"scope,omitempty"`
	//
	Key  string       `json:"key"`
	Type VariableType `json:"type,omitempty"`
}

// AppWorkerSpec struct for AppWorkerSpec
type AppWorkerSpec struct {
	Name             string                  `json:"name"`
	RunCommand       string                  `json:"run_command,omitempty"`
	BuildCommand     string                  `json:"build_command,omitempty"`
	DockerfilePath   string                  `json:"dockerfile_path,omitempty"`
	Git              GitSourceSpec           `json:"git,omitempty"`
	GitHub           GitHubSourceSpec        `json:"github,omitempty"`
	Envs             []AppVariableDefinition `json:"envs,omitempty"`
	InstanceSizeSlug string                  `json:"instance_size_slug,omitempty"`
	InstanceCount    int64                   `json:"instance_count,omitempty"`
	SourceDir        string                  `json:"source_dir,omitempty"`
	EnvironmentSlug  string                  `json:"environment_slug,omitempty"`
}

// GitHubSourceSpec struct for GitHubSourceSpec
type GitHubSourceSpec struct {
	Repo         string `json:"repo"`
	Branch       string `json:"branch"`
	DeployOnPush bool   `json:"deploy_on_push,omitempty"`
}

// GitSourceSpec struct for GitSourceSpec
type GitSourceSpec struct {
	Repo         string `json:"repo,omitempty"`
	RequiresAuth bool   `json:"requires_auth,omitempty"`
	Branch       string `json:"branch,omitempty"`
	RepoCloneURL string `json:"repo_clone_url,omitempty"`
}

// VariableScope the model 'VariableScope'
type VariableScope string

// List of VariableScope
const (
	VARIABLESCOPE_UNSET              VariableScope = "UNSET"
	VARIABLESCOPE_RUN_TIME           VariableScope = "RUN_TIME"
	VARIABLESCOPE_BUILD_TIME         VariableScope = "BUILD_TIME"
	VARIABLESCOPE_RUN_AND_BUILD_TIME VariableScope = "RUN_AND_BUILD_TIME"
)

// VariableType the model 'VariableType'
type VariableType string

// List of VariableType
const (
	VARIABLETYPE_GENERAL VariableType = "GENERAL"
	VARIABLETYPE_SECRET  VariableType = "SECRET"
)
