// Copyright Red Hat

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	scheme "github.com/identitatem/idp-client-api/api/client/clientset/versioned/scheme"
	v1alpha1 "github.com/identitatem/idp-client-api/api/identitatem/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ClusterOAuthsGetter has a method to return a ClusterOAuthInterface.
// A group's client should implement this interface.
type ClusterOAuthsGetter interface {
	ClusterOAuths(namespace string) ClusterOAuthInterface
}

// ClusterOAuthInterface has methods to work with ClusterOAuth resources.
type ClusterOAuthInterface interface {
	Create(ctx context.Context, clusterOAuth *v1alpha1.ClusterOAuth, opts v1.CreateOptions) (*v1alpha1.ClusterOAuth, error)
	Update(ctx context.Context, clusterOAuth *v1alpha1.ClusterOAuth, opts v1.UpdateOptions) (*v1alpha1.ClusterOAuth, error)
	UpdateStatus(ctx context.Context, clusterOAuth *v1alpha1.ClusterOAuth, opts v1.UpdateOptions) (*v1alpha1.ClusterOAuth, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.ClusterOAuth, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.ClusterOAuthList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.ClusterOAuth, err error)
	ClusterOAuthExpansion
}

// clusterOAuths implements ClusterOAuthInterface
type clusterOAuths struct {
	client rest.Interface
	ns     string
}

// newClusterOAuths returns a ClusterOAuths
func newClusterOAuths(c *IdentityconfigV1alpha1Client, namespace string) *clusterOAuths {
	return &clusterOAuths{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the clusterOAuth, and returns the corresponding clusterOAuth object, and an error if there is any.
func (c *clusterOAuths) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.ClusterOAuth, err error) {
	result = &v1alpha1.ClusterOAuth{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("clusteroauths").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ClusterOAuths that match those selectors.
func (c *clusterOAuths) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.ClusterOAuthList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.ClusterOAuthList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("clusteroauths").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested clusterOAuths.
func (c *clusterOAuths) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("clusteroauths").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a clusterOAuth and creates it.  Returns the server's representation of the clusterOAuth, and an error, if there is any.
func (c *clusterOAuths) Create(ctx context.Context, clusterOAuth *v1alpha1.ClusterOAuth, opts v1.CreateOptions) (result *v1alpha1.ClusterOAuth, err error) {
	result = &v1alpha1.ClusterOAuth{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("clusteroauths").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(clusterOAuth).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a clusterOAuth and updates it. Returns the server's representation of the clusterOAuth, and an error, if there is any.
func (c *clusterOAuths) Update(ctx context.Context, clusterOAuth *v1alpha1.ClusterOAuth, opts v1.UpdateOptions) (result *v1alpha1.ClusterOAuth, err error) {
	result = &v1alpha1.ClusterOAuth{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("clusteroauths").
		Name(clusterOAuth.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(clusterOAuth).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *clusterOAuths) UpdateStatus(ctx context.Context, clusterOAuth *v1alpha1.ClusterOAuth, opts v1.UpdateOptions) (result *v1alpha1.ClusterOAuth, err error) {
	result = &v1alpha1.ClusterOAuth{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("clusteroauths").
		Name(clusterOAuth.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(clusterOAuth).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the clusterOAuth and deletes it. Returns an error if one occurs.
func (c *clusterOAuths) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("clusteroauths").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *clusterOAuths) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("clusteroauths").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched clusterOAuth.
func (c *clusterOAuths) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.ClusterOAuth, err error) {
	result = &v1alpha1.ClusterOAuth{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("clusteroauths").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
