// Copyright Red Hat

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/identitatem/idp-client-api/api/identitatem/v1alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// AuthRealmLister helps list AuthRealms.
// All objects returned here must be treated as read-only.
type AuthRealmLister interface {
	// List lists all AuthRealms in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha1.AuthRealm, err error)
	// AuthRealms returns an object that can list and get AuthRealms.
	AuthRealms(namespace string) AuthRealmNamespaceLister
	AuthRealmListerExpansion
}

// authRealmLister implements the AuthRealmLister interface.
type authRealmLister struct {
	indexer cache.Indexer
}

// NewAuthRealmLister returns a new AuthRealmLister.
func NewAuthRealmLister(indexer cache.Indexer) AuthRealmLister {
	return &authRealmLister{indexer: indexer}
}

// List lists all AuthRealms in the indexer.
func (s *authRealmLister) List(selector labels.Selector) (ret []*v1alpha1.AuthRealm, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.AuthRealm))
	})
	return ret, err
}

// AuthRealms returns an object that can list and get AuthRealms.
func (s *authRealmLister) AuthRealms(namespace string) AuthRealmNamespaceLister {
	return authRealmNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// AuthRealmNamespaceLister helps list and get AuthRealms.
// All objects returned here must be treated as read-only.
type AuthRealmNamespaceLister interface {
	// List lists all AuthRealms in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha1.AuthRealm, err error)
	// Get retrieves the AuthRealm from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1alpha1.AuthRealm, error)
	AuthRealmNamespaceListerExpansion
}

// authRealmNamespaceLister implements the AuthRealmNamespaceLister
// interface.
type authRealmNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all AuthRealms in the indexer for a given namespace.
func (s authRealmNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.AuthRealm, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.AuthRealm))
	})
	return ret, err
}

// Get retrieves the AuthRealm from the indexer for a given namespace and name.
func (s authRealmNamespaceLister) Get(name string) (*v1alpha1.AuthRealm, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("authrealm"), name)
	}
	return obj.(*v1alpha1.AuthRealm), nil
}
