import * as webpack from 'webpack';
import { ConsolePackageJSON } from '../schema/plugin-package';
export declare const validatePackageFileSchema: (pkg: ConsolePackageJSON, description?: string) => import("../validation/ValidationResult").ValidationResult;
/**
 * Generates Console dynamic plugin remote container and related assets.
 *
 * All modules shared between the Console application and its dynamic plugins are treated as singletons.
 * Plugins won't bring their own fallback version of shared modules; Console is responsible for providing
 * all shared modules to all of its plugins.
 *
 * If you're facing issues related to `ExtensionValidator`, pass `CONSOLE_PLUGIN_SKIP_EXT_VALIDATOR=true`
 * env. variable to your webpack command.
 */
export declare class ConsoleRemotePlugin {
    private readonly pkg;
    constructor();
    apply(compiler: webpack.Compiler): void;
}
