import { Extension, ExtensionDeclaration, CodeRef } from '../types';
import { WatchK8sResourcesGeneric } from './console-types';
import { CreateConnectionGetter, RelationshipProviderCreate, RelationshipProviderProvides, TopologyApplyDisplayOptions, TopologyDataModelDepicted, TopologyDataModelGetter, TopologyDataModelReconciler, TopologyDecoratorGetter, TopologyDecoratorQuadrant, TopologyDisplayOption, ViewComponentFactory } from './topology-types';
/** Getter for a ViewComponentFactory */
export declare type TopologyComponentFactory = ExtensionDeclaration<'console.topology/component/factory', {
    /** Getter for a ViewComponentFactory */
    getFactory: CodeRef<ViewComponentFactory>;
}>;
/** Getter for the create connector function */
export declare type TopologyCreateConnector = ExtensionDeclaration<'console.topology/create/connector', {
    /** Getter for the create connector function */
    getCreateConnector: CodeRef<CreateConnectionGetter>;
}>;
/** Topology Data Model Factory Extension */
export declare type TopologyDataModelFactory = ExtensionDeclaration<'console.topology/data/factory', {
    /** Unique ID for the factory. */
    id: string;
    /** Priority for the factory */
    priority: number;
    /** Resources to be fetched from useK8sWatchResources hook. */
    resources?: WatchK8sResourcesGeneric;
    /** Keys in resources containing workloads. */
    workloadKeys?: string[];
    /** Getter for the data model factory */
    getDataModel?: CodeRef<TopologyDataModelGetter>;
    /** Getter for function to determine if a resource is depicted by this model factory */
    isResourceDepicted?: CodeRef<TopologyDataModelDepicted>;
    /** Getter for function to reconcile data model after all extensions' models have loaded */
    getDataModelReconciler?: CodeRef<TopologyDataModelReconciler>;
}>;
/** Topology Display Filters Extension */
export declare type TopologyDisplayFilters = ExtensionDeclaration<'console.topology/display/filters', {
    getTopologyFilters: CodeRef<() => TopologyDisplayOption[]>;
    applyDisplayOptions: CodeRef<TopologyApplyDisplayOptions>;
}>;
/** Topology Decorator Provider Extension */
export declare type TopologyDecoratorProvider = ExtensionDeclaration<'console.topology/decorator/provider', {
    id: string;
    priority: number;
    quadrant: TopologyDecoratorQuadrant;
    decorator: CodeRef<TopologyDecoratorGetter>;
}>;
/** Topology relationship provider connector extension */
export declare type TopologyRelationshipProvider = ExtensionDeclaration<'console.topology/relationship/provider', {
    provides: CodeRef<RelationshipProviderProvides>;
    tooltip: string;
    create: CodeRef<RelationshipProviderCreate>;
    priority: number;
}>;
export declare const isTopologyComponentFactory: (e: Extension<any>) => e is ExtensionDeclaration<"console.topology/component/factory", {
    /** Getter for a ViewComponentFactory */
    getFactory: CodeRef<ViewComponentFactory>;
}>;
export declare const isTopologyCreateConnector: (e: Extension<any>) => e is ExtensionDeclaration<"console.topology/create/connector", {
    /** Getter for the create connector function */
    getCreateConnector: CodeRef<CreateConnectionGetter>;
}>;
export declare const isTopologyDataModelFactory: (e: Extension<any>) => e is ExtensionDeclaration<"console.topology/data/factory", {
    /** Unique ID for the factory. */
    id: string;
    /** Priority for the factory */
    priority: number;
    /** Resources to be fetched from useK8sWatchResources hook. */
    resources?: WatchK8sResourcesGeneric;
    /** Keys in resources containing workloads. */
    workloadKeys?: string[];
    /** Getter for the data model factory */
    getDataModel?: CodeRef<TopologyDataModelGetter>;
    /** Getter for function to determine if a resource is depicted by this model factory */
    isResourceDepicted?: CodeRef<TopologyDataModelDepicted>;
    /** Getter for function to reconcile data model after all extensions' models have loaded */
    getDataModelReconciler?: CodeRef<TopologyDataModelReconciler>;
}>;
export declare const isTopologyDisplayFilters: (e: Extension<any>) => e is ExtensionDeclaration<"console.topology/display/filters", {
    getTopologyFilters: CodeRef<() => TopologyDisplayOption[]>;
    applyDisplayOptions: CodeRef<TopologyApplyDisplayOptions>;
}>;
export declare const isTopologyDecoratorProvider: (e: Extension<any>) => e is ExtensionDeclaration<"console.topology/decorator/provider", {
    id: string;
    priority: number;
    quadrant: TopologyDecoratorQuadrant;
    decorator: CodeRef<TopologyDecoratorGetter>;
}>;
export declare const isTopologyRelationshipProvider: (e: Extension<any>) => e is ExtensionDeclaration<"console.topology/relationship/provider", {
    provides: CodeRef<RelationshipProviderProvides>;
    tooltip: string;
    create: CodeRef<RelationshipProviderCreate>;
    priority: number;
}>;
