import * as React from 'react';
import hoistNonReactStatics from 'hoist-non-react-statics';
import { VictoryScatter } from 'victory-scatter';
import { getPrimaryDotMeasureData } from './utils';
import { ChartContainer } from '../ChartContainer';
import { ChartScatter } from '../ChartScatter';
import { ChartBulletStyles } from '../ChartTheme';
import { ChartTooltip } from '../ChartTooltip';
import { getBulletPrimaryDotMeasureTheme } from '../ChartUtils';
export const ChartBulletPrimaryDotMeasure = ({ allowTooltip = true, ariaDesc, ariaTitle, constrainToVisibleArea = false, data, domain, horizontal = true, invert = false, labels, measureComponent = React.createElement(ChartScatter, null), padding, size = ChartBulletStyles.primaryDotMeasureSize, standalone = true, themeColor, themeVariant, y, y0, 
// destructure last
theme = getBulletPrimaryDotMeasureTheme(themeColor, themeVariant), labelComponent = React.createElement(ChartTooltip, null), height = theme.group.height, width = theme.group.width }) => {
    const computedData = getPrimaryDotMeasureData({
        data,
        invert,
        theme,
        y,
        y0
    });
    // Label component
    //
    // Note: SVG height and width are provided by ChartBullet as a workaround to support constrainToVisibleArea
    const tooltip = React.cloneElement(labelComponent, Object.assign({ constrainToVisibleArea, dx: 0, dy: horizontal ? -size : 0, orientation: 'top' }, labelComponent.props));
    const measure = computedData.map((dataPoint, index) => React.cloneElement(measureComponent, Object.assign({ data: [Object.assign({}, dataPoint)], domain,
        height,
        horizontal, key: `pf-chart-bullet-primary-dot-measure-${index}`, labelComponent: allowTooltip ? tooltip : undefined, labels,
        padding,
        size, standalone: false, style: {
            data: {
                fill: dataPoint._color
            }
        }, theme,
        width }, measureComponent.props)));
    return standalone ? (React.createElement(ChartContainer, { desc: ariaDesc, height: height, title: ariaTitle, width: width }, measure)) : (React.createElement(React.Fragment, null, measure));
};
ChartBulletPrimaryDotMeasure.displayName = 'ChartBulletPrimaryDotMeasure';
// Note: VictoryBar.role must be hoisted
hoistNonReactStatics(ChartBulletPrimaryDotMeasure, VictoryScatter);
//# sourceMappingURL=ChartBulletPrimaryDotMeasure.js.map