import * as React from 'react';
import hoistNonReactStatics from 'hoist-non-react-statics';
import { VictoryBar } from 'victory-bar';
import { getQualitativeRangeData } from './utils';
import { ChartBar } from '../ChartBar';
import { ChartContainer } from '../ChartContainer';
import { ChartBulletStyles } from '../ChartTheme';
import { ChartTooltip } from '../ChartTooltip';
import { getBulletQualitativeRangeTheme } from '../ChartUtils';
export const ChartBulletQualitativeRange = ({ allowTooltip = true, ariaDesc, ariaTitle, barWidth = ChartBulletStyles.qualitativeRangeWidth, constrainToVisibleArea = false, data, domain, horizontal = true, invert = false, labels, measureComponent = React.createElement(ChartBar, null), padding, standalone = true, themeColor, themeVariant, y, y0, 
// destructure last
theme = getBulletQualitativeRangeTheme(themeColor, themeVariant), height = theme.group.height, width = theme.group.width, labelComponent = React.createElement(ChartTooltip, null) }) => {
    const computedData = getQualitativeRangeData({
        data,
        invert,
        theme,
        y,
        y0
    });
    // Label component
    //
    // The x and y calculations below ensure that the tooltip appears above the bar, instead of vertically centered.
    // Having the tooltip vertically centered is visually confusing with comparative measures.
    //
    // Note: SVG height and width are provided by ChartBullet as a workaround to support constrainToVisibleArea
    const tooltip = React.cloneElement(labelComponent, Object.assign({ constrainToVisibleArea, dx: () => {
            if (horizontal) {
                return 0;
            }
            const result = typeof barWidth === 'function' ? barWidth(data) : barWidth;
            return result / 2;
        }, dy: () => {
            if (!horizontal) {
                return 0;
            }
            const result = typeof barWidth === 'function' ? barWidth(data) : barWidth;
            return -(result / 2);
        }, orientation: 'top' }, labelComponent.props));
    const measure = computedData.map((dataPoint, index) => React.cloneElement(measureComponent, Object.assign({ barWidth, data: [Object.assign({}, dataPoint)], domain,
        height,
        horizontal, key: `pf-chart-bullet-qualitative-range-${index}`, labelComponent: allowTooltip ? tooltip : undefined, labels,
        padding, standalone: false, style: {
            data: {
                fill: dataPoint._color
            }
        }, theme,
        width }, measureComponent.props)));
    return standalone ? (React.createElement(ChartContainer, { desc: ariaDesc, height: height, title: ariaTitle, width: width }, measure)) : (React.createElement(React.Fragment, null, measure));
};
ChartBulletQualitativeRange.displayName = 'ChartBulletQualitativeRange';
// Note: VictoryBar.role must be hoisted
hoistNonReactStatics(ChartBulletQualitativeRange, VictoryBar);
//# sourceMappingURL=ChartBulletQualitativeRange.js.map