var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
/**
 * Vendor modules shared between Console application and its dynamic plugins.
 */
export const sharedVendorModules = [
    '@openshift-console/dynamic-plugin-sdk',
    '@openshift-console/dynamic-plugin-sdk/lib/api/internal-api',
    'react',
    'react-helmet',
    'react-i18next',
    'react-router',
    'react-router-dom',
];
/**
 * At runtime, Console will override (i.e. enforce Console-bundled implementation of) shared
 * modules for each dynamic plugin, before loading any of the modules exposed by that plugin.
 *
 * This way, a single version of React etc. is used by the Console application.
 */
export const overrideSharedModules = (entryModule) => {
    entryModule.override({
        '@openshift-console/dynamic-plugin-sdk': () => __awaiter(void 0, void 0, void 0, function* () {
            return () => require('@console/dynamic-plugin-sdk/src/index-lib');
        }),
        '@openshift-console/dynamic-plugin-sdk/lib/api/internal-api': () => __awaiter(void 0, void 0, void 0, function* () {
            return () => require('@console/dynamic-plugin-sdk/src/api/internal-api');
        }),
        react: () => __awaiter(void 0, void 0, void 0, function* () { return () => require('react'); }),
        'react-helmet': () => __awaiter(void 0, void 0, void 0, function* () { return () => require('react-helmet'); }),
        'react-i18next': () => __awaiter(void 0, void 0, void 0, function* () { return () => require('react-i18next'); }),
        'react-router': () => __awaiter(void 0, void 0, void 0, function* () { return () => require('react-router'); }),
        'react-router-dom': () => __awaiter(void 0, void 0, void 0, function* () { return () => require('react-router-dom'); }),
    });
};
//# sourceMappingURL=shared-modules.js.map