"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const _ = require("lodash");
const isPlainNonReactObject = (obj) => _.isPlainObject(obj) && !obj.$$typeof;
/**
 * Recursive equivalent of `_.forOwn` function that traverses plain objects and arrays.
 */
exports.deepForOwn = (obj, predicate, valueCallback) => {
    const visitValue = (value, key, container) => {
        if (predicate(value)) {
            valueCallback(value, key, container);
        }
        else if (isPlainNonReactObject(value)) {
            exports.deepForOwn(value, predicate, valueCallback);
        }
    };
    _.forOwn(obj, (value, key, container) => {
        if (Array.isArray(value)) {
            value.forEach((arrayElement, index) => {
                visitValue(arrayElement, index.toString(), value);
            });
        }
        else {
            visitValue(value, key, container);
        }
    });
};
//# sourceMappingURL=object.js.map