# Copyright 2021 The csi-addons Authors. All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

SHELL:=/bin/bash

PROTOC_VERSION := 3.14.0
PROTOC_GEN_GO_VERSION := 1.25.0
PROTOC_GEN_GO_GRPC_VERSION := 1.1.0

PROTOC_FOUND := $(shell ../bin/protoc --version 2> /dev/null)
PROTOC_GEN_GO_FOUND := $(shell ../bin/protoc-gen-go --version 2>&1 | grep protoc-gen-go)
PROTOC_GEN_GO_GRPC_FOUND := $(shell ../bin/protoc-gen-go-grpc --version 2> /dev/null)

CSI_SPEC_VERSION := v1.5.0

ifeq ("${PROTOC_FOUND}","libprotoc ${PROTOC_VERSION}")
	HAVE_PROTOC = "yes"
endif

ifeq ("${PROTOC_GEN_GO_FOUND}","protoc-gen-go v${PROTOC_GEN_GO_VERSION}")
	HAVE_PROTOC_GEN_GO = "yes"
endif

ifeq ("${PROTOC_GEN_GO_GRPC_FOUND}","protoc-gen-go-grpc ${PROTOC_GEN_GO_GRPC_VERSION}")
	HAVE_PROTOC_GEN_GO_GRPC = "yes"
endif


install-deps:
	mkdir -p ../bin ../dist ../google/protobuf ../github.com/container-storage-interface/spec/lib/go/csi
ifndef HAVE_PROTOC
	# download protoc
	wget -P ../dist/ --backups=1 \
		https://github.com/protocolbuffers/protobuf/releases/download/v${PROTOC_VERSION}/protoc-${PROTOC_VERSION}-linux-x86_64.zip
	unzip -jod ../bin ../dist/protoc-${PROTOC_VERSION}-linux-x86_64.zip bin/protoc

	# extract descriptor.proto, timestamp.proto and wrappers.proto
	unzip -jod ../google/protobuf ../dist/protoc-${PROTOC_VERSION}-linux-x86_64.zip \
		include/google/protobuf/descriptor.proto \
		include/google/protobuf/timestamp.proto \
		include/google/protobuf/wrappers.proto

	# fetch csi.proto, place is in the right Go package dir
	wget -O ../github.com/container-storage-interface/spec/lib/go/csi/csi.proto https://raw.githubusercontent.com/container-storage-interface/spec/${CSI_SPEC_VERSION}/csi.proto
endif

ifndef HAVE_PROTOC_GEN_GO
	# download protoc-gen-go
	wget -P ../dist/ --backups=1 \
		https://github.com/protocolbuffers/protobuf-go/releases/download/v${PROTOC_GEN_GO_VERSION}/protoc-gen-go.v${PROTOC_GEN_GO_VERSION}.linux.386.tar.gz
	tar -C ../bin -zxvf ../dist/protoc-gen-go.v${PROTOC_GEN_GO_VERSION}.linux.386.tar.gz protoc-gen-go
endif

ifndef HAVE_PROTOC_GEN_GO_GRPC
	# download protoc-gen-go-grpc
	wget -P ../dist/ --backups=1 \
		https://github.com/grpc/grpc-go/releases/download/cmd%2Fprotoc-gen-go-grpc%2Fv${PROTOC_GEN_GO_GRPC_VERSION}/protoc-gen-go-grpc.v${PROTOC_GEN_GO_GRPC_VERSION}.linux.386.tar.gz
	tar -C ../bin -zxvf ../dist/protoc-gen-go-grpc.v${PROTOC_GEN_GO_GRPC_VERSION}.linux.386.tar.gz ./protoc-gen-go-grpc
endif


build: OPERATION = $(shell basename $(PROTO) .proto)
build: install-deps
	# generate libs
	cd .. && ./bin/protoc --go_out=lib/go --go_opt=paths=source_relative --plugin=./bin/protoc-gen-go $(OPERATION)/$(OPERATION).proto
	cd .. && ./bin/protoc --go-grpc_out=lib/go --go-grpc_opt=paths=source_relative --plugin=./bin/protoc-gen-go-grpc $(OPERATION)/$(OPERATION).proto

$(PROTO).tmp: $(PROTO_SOURCE)
	echo "// Code generated by make; DO NOT EDIT." > "$(PROTO).tmp"
	cat $(PROTO_SOURCE) | sed -n -e '/```protobuf$$/,/^```$$/ p' | sed '/^```/d' >> "$(PROTO).tmp"

# This is the target for building the CSI protobuf file.
$(PROTO): $(PROTO).tmp
	diff "$(PROTO)" "$(PROTO).tmp" > /dev/null 2>&1 || cp -f "$(PROTO).tmp" "$(PROTO)"
