#
# For future consideration, this list could be automatically generated
# via the AWS SDK service list.
#

variable "service_labels" {
  default = [
    "accessanalyzer",
    "acm",
    "acmpca",
    "alexaforbusiness",
    "amplify",
    "apigateway",
    "apigatewaymanagementapi",
    "apigatewayv2",
    "appconfig",
    "applicationautoscaling",
    "applicationdiscoveryservice",
    "applicationinsights",
    "appmesh",
    "appstream",
    "appsync",
    "athena",
    "autoscaling",
    "autoscalingplans",
    "backup",
    "batch",
    "budgets",
    "chime",
    "cloud9",
    "clouddirectory",
    "cloudformation",
    "cloudfront",
    "cloudhsm",
    "cloudhsmv2",
    "cloudsearch",
    "cloudtrail",
    "cloudwatch",
    "cloudwatchevents",
    "cloudwatchlogs",
    "codeartifact",
    "codebuild",
    "codecommit",
    "codedeploy",
    "codeguruprofiler",
    "codegurureviewer",
    "codepipeline",
    "codestar",
    "codestarconnections",
    "codestarnotifications",
    "cognito",
    "comprehend",
    "comprehendmedical",
    "computeoptimizer",
    "configservice",
    "connect",
    "costandusagereportservice",
    "costexplorer",
    "databasemigrationservice",
    "dataexchange",
    "datapipeline",
    "datasync",
    "dax",
    "detective",
    "devicefarm",
    "directconnect",
    "directoryservice",
    "dlm",
    "docdb",
    "dynamodb",
    "ec2-classic",
    "ec2",
    "ecr",
    "ecs",
    "efs",
    "eks",
    "elastic-transcoder",
    "elasticache",
    "elasticbeanstalk",
    "elasticinference",
    "elasticsearch",
    "elb",
    "elbv2",
    "emr",
    "eventbridge",
    "firehose",
    "fms",
    "forecastservice",
    "frauddetector",
    "fsx",
    "gamelift",
    "glacier",
    "globalaccelerator",
    "glue",
    "greengrass",
    "groundstation",
    "guardduty",
    "iam",
    "imagebuilder",
    "inspector",
    "iot",
    "iotanalytics",
    "iotevents",
    "iotsecuretunneling",
    "iotsitewise",
    "iotthingsgraph",
    "kafka",
    "kendra",
    "kinesis",
    "kinesisanalytics",
    "kinesisanalyticsv2",
    "kinesisvideo",
    "kms",
    "lakeformation",
    "lambda",
    "lexmodelbuildingservice",
    "licensemanager",
    "lightsail",
    "machinelearning",
    "macie",
    "managedblockchain",
    "marketplacecatalog",
    "mediaconnect",
    "mediaconvert",
    "medialive",
    "mediapackage",
    "mediapackagevod",
    "mediastore",
    "mediatailor",
    "meteringmarketplace",
    "mobile",
    "mq",
    "neptune",
    "networkmanager",
    "opsworks",
    "organizations",
    "outposts",
    "personalize",
    "pi",
    "pinpoint",
    "pinpointemail",
    "pinpointsmsvoice",
    "polly",
    "pricing",
    "qldb",
    "quicksight",
    "ram",
    "rds",
    "redshift",
    "resourcegroups",
    "robomaker",
    "route53",
    "route53domains",
    "route53resolver",
    "s3",
    "s3control",
    "sagemaker",
    "savingsplans",
    "secretsmanager",
    "securityhub",
    "serverlessapplicationrepository",
    "servicecatalog",
    "servicediscovery",
    "servicequotas",
    "ses",
    "sesv2",
    "sfn",
    "shield",
    "simpledb",
    "sms",
    "snowball",
    "sns",
    "sqs",
    "ssm",
    "storagegateway",
    "sts",
    "support",
    "swf",
    "synthetics",
    "textract",
    "transcribeservice",
    "transfer",
    "translate",
    "waf",
    "wafv2",
    "workdocs",
    "worklink",
    "workmail",
    "workspaces",
    "xray",
  ]
  description = "Set of AWS Go SDK service labels"
  type        = set(string)
}

resource "github_issue_label" "service" {
  for_each = var.service_labels

  repository = "terraform-provider-aws"
  name       = "service/${each.value}"
  color      = "bfd4f2"
}
