package common

import (
	"hash/fnv"
)

/*
	fnv64a is a 64-bit non-cryptographic hash algorithm with a low collision and a high distribution rate.
	https://en.wikipedia.org/wiki/Fowler%E2%80%93Noll%E2%80%93Vo_hash_function
*/
func FnvHash(s string) uint32 {
	h := fnv.New32a()
	_, err := h.Write([]byte(s))
	if err != nil {
		return 0
	}
	return h.Sum32()
}
