/*
Copyright 2018 Openstorage.org

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/libopenstorage/stork/pkg/apis/stork/v1alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// BackupLocationLister helps list BackupLocations.
type BackupLocationLister interface {
	// List lists all BackupLocations in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.BackupLocation, err error)
	// BackupLocations returns an object that can list and get BackupLocations.
	BackupLocations(namespace string) BackupLocationNamespaceLister
	BackupLocationListerExpansion
}

// backupLocationLister implements the BackupLocationLister interface.
type backupLocationLister struct {
	indexer cache.Indexer
}

// NewBackupLocationLister returns a new BackupLocationLister.
func NewBackupLocationLister(indexer cache.Indexer) BackupLocationLister {
	return &backupLocationLister{indexer: indexer}
}

// List lists all BackupLocations in the indexer.
func (s *backupLocationLister) List(selector labels.Selector) (ret []*v1alpha1.BackupLocation, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.BackupLocation))
	})
	return ret, err
}

// BackupLocations returns an object that can list and get BackupLocations.
func (s *backupLocationLister) BackupLocations(namespace string) BackupLocationNamespaceLister {
	return backupLocationNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// BackupLocationNamespaceLister helps list and get BackupLocations.
type BackupLocationNamespaceLister interface {
	// List lists all BackupLocations in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1alpha1.BackupLocation, err error)
	// Get retrieves the BackupLocation from the indexer for a given namespace and name.
	Get(name string) (*v1alpha1.BackupLocation, error)
	BackupLocationNamespaceListerExpansion
}

// backupLocationNamespaceLister implements the BackupLocationNamespaceLister
// interface.
type backupLocationNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all BackupLocations in the indexer for a given namespace.
func (s backupLocationNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.BackupLocation, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.BackupLocation))
	})
	return ret, err
}

// Get retrieves the BackupLocation from the indexer for a given namespace and name.
func (s backupLocationNamespaceLister) Get(name string) (*v1alpha1.BackupLocation, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("backuplocation"), name)
	}
	return obj.(*v1alpha1.BackupLocation), nil
}
