/*
Copyright 2018 Openstorage.org

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/libopenstorage/stork/pkg/apis/stork/v1alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ClusterDomainsStatusLister helps list ClusterDomainsStatuses.
type ClusterDomainsStatusLister interface {
	// List lists all ClusterDomainsStatuses in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.ClusterDomainsStatus, err error)
	// Get retrieves the ClusterDomainsStatus from the index for a given name.
	Get(name string) (*v1alpha1.ClusterDomainsStatus, error)
	ClusterDomainsStatusListerExpansion
}

// clusterDomainsStatusLister implements the ClusterDomainsStatusLister interface.
type clusterDomainsStatusLister struct {
	indexer cache.Indexer
}

// NewClusterDomainsStatusLister returns a new ClusterDomainsStatusLister.
func NewClusterDomainsStatusLister(indexer cache.Indexer) ClusterDomainsStatusLister {
	return &clusterDomainsStatusLister{indexer: indexer}
}

// List lists all ClusterDomainsStatuses in the indexer.
func (s *clusterDomainsStatusLister) List(selector labels.Selector) (ret []*v1alpha1.ClusterDomainsStatus, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.ClusterDomainsStatus))
	})
	return ret, err
}

// Get retrieves the ClusterDomainsStatus from the index for a given name.
func (s *clusterDomainsStatusLister) Get(name string) (*v1alpha1.ClusterDomainsStatus, error) {
	obj, exists, err := s.indexer.GetByKey(name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("clusterdomainsstatus"), name)
	}
	return obj.(*v1alpha1.ClusterDomainsStatus), nil
}
