package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAgentInstallStatus invokes the aegis.DescribeAgentInstallStatus API synchronously
// api document: https://help.aliyun.com/api/aegis/describeagentinstallstatus.html
func (client *Client) DescribeAgentInstallStatus(request *DescribeAgentInstallStatusRequest) (response *DescribeAgentInstallStatusResponse, err error) {
	response = CreateDescribeAgentInstallStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAgentInstallStatusWithChan invokes the aegis.DescribeAgentInstallStatus API asynchronously
// api document: https://help.aliyun.com/api/aegis/describeagentinstallstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAgentInstallStatusWithChan(request *DescribeAgentInstallStatusRequest) (<-chan *DescribeAgentInstallStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeAgentInstallStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAgentInstallStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAgentInstallStatusWithCallback invokes the aegis.DescribeAgentInstallStatus API asynchronously
// api document: https://help.aliyun.com/api/aegis/describeagentinstallstatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAgentInstallStatusWithCallback(request *DescribeAgentInstallStatusRequest, callback func(response *DescribeAgentInstallStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAgentInstallStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeAgentInstallStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAgentInstallStatusRequest is the request struct for api DescribeAgentInstallStatus
type DescribeAgentInstallStatusRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Lang     string `position:"Query" name:"Lang"`
	Uuids    string `position:"Query" name:"Uuids"`
}

// DescribeAgentInstallStatusResponse is the response struct for api DescribeAgentInstallStatus
type DescribeAgentInstallStatusResponse struct {
	*responses.BaseResponse
	RequestId                           string                            `json:"RequestId" xml:"RequestId"`
	AegisClientInvokeStatusResponseList []AegisClientInvokeStatusResponse `json:"AegisClientInvokeStatusResponseList" xml:"AegisClientInvokeStatusResponseList"`
}

// CreateDescribeAgentInstallStatusRequest creates a request to invoke DescribeAgentInstallStatus API
func CreateDescribeAgentInstallStatusRequest() (request *DescribeAgentInstallStatusRequest) {
	request = &DescribeAgentInstallStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeAgentInstallStatus", "vipaegis", "openAPI")
	return
}

// CreateDescribeAgentInstallStatusResponse creates a response to parse from DescribeAgentInstallStatus response
func CreateDescribeAgentInstallStatusResponse() (response *DescribeAgentInstallStatusResponse) {
	response = &DescribeAgentInstallStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
