package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteNote invokes the emr.DeleteNote API synchronously
// api document: https://help.aliyun.com/api/emr/deletenote.html
func (client *Client) DeleteNote(request *DeleteNoteRequest) (response *DeleteNoteResponse, err error) {
	response = CreateDeleteNoteResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteNoteWithChan invokes the emr.DeleteNote API asynchronously
// api document: https://help.aliyun.com/api/emr/deletenote.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteNoteWithChan(request *DeleteNoteRequest) (<-chan *DeleteNoteResponse, <-chan error) {
	responseChan := make(chan *DeleteNoteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteNote(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteNoteWithCallback invokes the emr.DeleteNote API asynchronously
// api document: https://help.aliyun.com/api/emr/deletenote.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteNoteWithCallback(request *DeleteNoteRequest, callback func(response *DeleteNoteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteNoteResponse
		var err error
		defer close(result)
		response, err = client.DeleteNote(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteNoteRequest is the request struct for api DeleteNote
type DeleteNoteRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Id              string           `position:"Query" name:"Id"`
}

// DeleteNoteResponse is the response struct for api DeleteNote
type DeleteNoteResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteNoteRequest creates a request to invoke DeleteNote API
func CreateDeleteNoteRequest() (request *DeleteNoteRequest) {
	request = &DeleteNoteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DeleteNote", "emr", "openAPI")
	return
}

// CreateDeleteNoteResponse creates a response to parse from DeleteNote response
func CreateDeleteNoteResponse() (response *DeleteNoteResponse) {
	response = &DeleteNoteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
