/*
Copyright 2019 Openstorage.org

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"time"

	v1alpha1 "github.com/libopenstorage/autopilot-api/pkg/apis/autopilot/v1alpha1"
	scheme "github.com/libopenstorage/autopilot-api/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// AutopilotRuleObjectsGetter has a method to return a AutopilotRuleObjectInterface.
// A group's client should implement this interface.
type AutopilotRuleObjectsGetter interface {
	AutopilotRuleObjects(namespace string) AutopilotRuleObjectInterface
}

// AutopilotRuleObjectInterface has methods to work with AutopilotRuleObject resources.
type AutopilotRuleObjectInterface interface {
	Create(*v1alpha1.AutopilotRuleObject) (*v1alpha1.AutopilotRuleObject, error)
	Update(*v1alpha1.AutopilotRuleObject) (*v1alpha1.AutopilotRuleObject, error)
	UpdateStatus(*v1alpha1.AutopilotRuleObject) (*v1alpha1.AutopilotRuleObject, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1alpha1.AutopilotRuleObject, error)
	List(opts v1.ListOptions) (*v1alpha1.AutopilotRuleObjectList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.AutopilotRuleObject, err error)
	AutopilotRuleObjectExpansion
}

// autopilotRuleObjects implements AutopilotRuleObjectInterface
type autopilotRuleObjects struct {
	client rest.Interface
	ns     string
}

// newAutopilotRuleObjects returns a AutopilotRuleObjects
func newAutopilotRuleObjects(c *AutopilotV1alpha1Client, namespace string) *autopilotRuleObjects {
	return &autopilotRuleObjects{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the autopilotRuleObject, and returns the corresponding autopilotRuleObject object, and an error if there is any.
func (c *autopilotRuleObjects) Get(name string, options v1.GetOptions) (result *v1alpha1.AutopilotRuleObject, err error) {
	result = &v1alpha1.AutopilotRuleObject{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("autopilotruleobjects").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of AutopilotRuleObjects that match those selectors.
func (c *autopilotRuleObjects) List(opts v1.ListOptions) (result *v1alpha1.AutopilotRuleObjectList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.AutopilotRuleObjectList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("autopilotruleobjects").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested autopilotRuleObjects.
func (c *autopilotRuleObjects) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("autopilotruleobjects").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a autopilotRuleObject and creates it.  Returns the server's representation of the autopilotRuleObject, and an error, if there is any.
func (c *autopilotRuleObjects) Create(autopilotRuleObject *v1alpha1.AutopilotRuleObject) (result *v1alpha1.AutopilotRuleObject, err error) {
	result = &v1alpha1.AutopilotRuleObject{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("autopilotruleobjects").
		Body(autopilotRuleObject).
		Do().
		Into(result)
	return
}

// Update takes the representation of a autopilotRuleObject and updates it. Returns the server's representation of the autopilotRuleObject, and an error, if there is any.
func (c *autopilotRuleObjects) Update(autopilotRuleObject *v1alpha1.AutopilotRuleObject) (result *v1alpha1.AutopilotRuleObject, err error) {
	result = &v1alpha1.AutopilotRuleObject{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("autopilotruleobjects").
		Name(autopilotRuleObject.Name).
		Body(autopilotRuleObject).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *autopilotRuleObjects) UpdateStatus(autopilotRuleObject *v1alpha1.AutopilotRuleObject) (result *v1alpha1.AutopilotRuleObject, err error) {
	result = &v1alpha1.AutopilotRuleObject{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("autopilotruleobjects").
		Name(autopilotRuleObject.Name).
		SubResource("status").
		Body(autopilotRuleObject).
		Do().
		Into(result)
	return
}

// Delete takes name of the autopilotRuleObject and deletes it. Returns an error if one occurs.
func (c *autopilotRuleObjects) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("autopilotruleobjects").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *autopilotRuleObjects) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("autopilotruleobjects").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched autopilotRuleObject.
func (c *autopilotRuleObjects) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.AutopilotRuleObject, err error) {
	result = &v1alpha1.AutopilotRuleObject{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("autopilotruleobjects").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
