package ons

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OnsTopicDelete invokes the ons.OnsTopicDelete API synchronously
// api document: https://help.aliyun.com/api/ons/onstopicdelete.html
func (client *Client) OnsTopicDelete(request *OnsTopicDeleteRequest) (response *OnsTopicDeleteResponse, err error) {
	response = CreateOnsTopicDeleteResponse()
	err = client.DoAction(request, response)
	return
}

// OnsTopicDeleteWithChan invokes the ons.OnsTopicDelete API asynchronously
// api document: https://help.aliyun.com/api/ons/onstopicdelete.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OnsTopicDeleteWithChan(request *OnsTopicDeleteRequest) (<-chan *OnsTopicDeleteResponse, <-chan error) {
	responseChan := make(chan *OnsTopicDeleteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OnsTopicDelete(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OnsTopicDeleteWithCallback invokes the ons.OnsTopicDelete API asynchronously
// api document: https://help.aliyun.com/api/ons/onstopicdelete.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OnsTopicDeleteWithCallback(request *OnsTopicDeleteRequest, callback func(response *OnsTopicDeleteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OnsTopicDeleteResponse
		var err error
		defer close(result)
		response, err = client.OnsTopicDelete(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OnsTopicDeleteRequest is the request struct for api OnsTopicDelete
type OnsTopicDeleteRequest struct {
	*requests.RpcRequest
	PreventCache requests.Integer `position:"Query" name:"PreventCache"`
	InstanceId   string           `position:"Query" name:"InstanceId"`
	Topic        string           `position:"Query" name:"Topic"`
}

// OnsTopicDeleteResponse is the response struct for api OnsTopicDelete
type OnsTopicDeleteResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	HelpUrl   string `json:"HelpUrl" xml:"HelpUrl"`
}

// CreateOnsTopicDeleteRequest creates a request to invoke OnsTopicDelete API
func CreateOnsTopicDeleteRequest() (request *OnsTopicDeleteRequest) {
	request = &OnsTopicDeleteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ons", "2019-02-14", "OnsTopicDelete", "ons", "openAPI")
	return
}

// CreateOnsTopicDeleteResponse creates a response to parse from OnsTopicDelete response
func CreateOnsTopicDeleteResponse() (response *OnsTopicDeleteResponse) {
	response = &OnsTopicDeleteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
