package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyVpnRouteEntryWeight invokes the vpc.ModifyVpnRouteEntryWeight API synchronously
// api document: https://help.aliyun.com/api/vpc/modifyvpnrouteentryweight.html
func (client *Client) ModifyVpnRouteEntryWeight(request *ModifyVpnRouteEntryWeightRequest) (response *ModifyVpnRouteEntryWeightResponse, err error) {
	response = CreateModifyVpnRouteEntryWeightResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyVpnRouteEntryWeightWithChan invokes the vpc.ModifyVpnRouteEntryWeight API asynchronously
// api document: https://help.aliyun.com/api/vpc/modifyvpnrouteentryweight.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyVpnRouteEntryWeightWithChan(request *ModifyVpnRouteEntryWeightRequest) (<-chan *ModifyVpnRouteEntryWeightResponse, <-chan error) {
	responseChan := make(chan *ModifyVpnRouteEntryWeightResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyVpnRouteEntryWeight(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyVpnRouteEntryWeightWithCallback invokes the vpc.ModifyVpnRouteEntryWeight API asynchronously
// api document: https://help.aliyun.com/api/vpc/modifyvpnrouteentryweight.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyVpnRouteEntryWeightWithCallback(request *ModifyVpnRouteEntryWeightRequest, callback func(response *ModifyVpnRouteEntryWeightResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyVpnRouteEntryWeightResponse
		var err error
		defer close(result)
		response, err = client.ModifyVpnRouteEntryWeight(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyVpnRouteEntryWeightRequest is the request struct for api ModifyVpnRouteEntryWeight
type ModifyVpnRouteEntryWeightRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	Weight               requests.Integer `position:"Query" name:"Weight"`
	VpnGatewayId         string           `position:"Query" name:"VpnGatewayId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	NewWeight            requests.Integer `position:"Query" name:"NewWeight"`
	RouteDest            string           `position:"Query" name:"RouteDest"`
	NextHop              string           `position:"Query" name:"NextHop"`
}

// ModifyVpnRouteEntryWeightResponse is the response struct for api ModifyVpnRouteEntryWeight
type ModifyVpnRouteEntryWeightResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyVpnRouteEntryWeightRequest creates a request to invoke ModifyVpnRouteEntryWeight API
func CreateModifyVpnRouteEntryWeightRequest() (request *ModifyVpnRouteEntryWeightRequest) {
	request = &ModifyVpnRouteEntryWeightRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ModifyVpnRouteEntryWeight", "vpc", "openAPI")
	return
}

// CreateModifyVpnRouteEntryWeightResponse creates a response to parse from ModifyVpnRouteEntryWeight response
func CreateModifyVpnRouteEntryWeightResponse() (response *ModifyVpnRouteEntryWeightResponse) {
	response = &ModifyVpnRouteEntryWeightResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
