package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RejectUser invokes the baas.RejectUser API synchronously
// api document: https://help.aliyun.com/api/baas/rejectuser.html
func (client *Client) RejectUser(request *RejectUserRequest) (response *RejectUserResponse, err error) {
	response = CreateRejectUserResponse()
	err = client.DoAction(request, response)
	return
}

// RejectUserWithChan invokes the baas.RejectUser API asynchronously
// api document: https://help.aliyun.com/api/baas/rejectuser.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RejectUserWithChan(request *RejectUserRequest) (<-chan *RejectUserResponse, <-chan error) {
	responseChan := make(chan *RejectUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RejectUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RejectUserWithCallback invokes the baas.RejectUser API asynchronously
// api document: https://help.aliyun.com/api/baas/rejectuser.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RejectUserWithCallback(request *RejectUserRequest, callback func(response *RejectUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RejectUserResponse
		var err error
		defer close(result)
		response, err = client.RejectUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RejectUserRequest is the request struct for api RejectUser
type RejectUserRequest struct {
	*requests.RpcRequest
	Reason   string `position:"Body" name:"Reason"`
	Bizid    string `position:"Body" name:"Bizid"`
	Bid      string `position:"Body" name:"Bid"`
	UserName string `position:"Body" name:"UserName"`
}

// RejectUserResponse is the response struct for api RejectUser
type RejectUserResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    string `json:"Result" xml:"Result"`
}

// CreateRejectUserRequest creates a request to invoke RejectUser API
func CreateRejectUserRequest() (request *RejectUserRequest) {
	request = &RejectUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "RejectUser", "", "")
	return
}

// CreateRejectUserResponse creates a response to parse from RejectUser response
func CreateRejectUserResponse() (response *RejectUserResponse) {
	response = &RejectUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
