/*
Copyright 2018 Openstorage.org

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"time"

	v1alpha1 "github.com/libopenstorage/stork/pkg/apis/stork/v1alpha1"
	scheme "github.com/libopenstorage/stork/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// BackupLocationsGetter has a method to return a BackupLocationInterface.
// A group's client should implement this interface.
type BackupLocationsGetter interface {
	BackupLocations(namespace string) BackupLocationInterface
}

// BackupLocationInterface has methods to work with BackupLocation resources.
type BackupLocationInterface interface {
	Create(*v1alpha1.BackupLocation) (*v1alpha1.BackupLocation, error)
	Update(*v1alpha1.BackupLocation) (*v1alpha1.BackupLocation, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1alpha1.BackupLocation, error)
	List(opts v1.ListOptions) (*v1alpha1.BackupLocationList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.BackupLocation, err error)
	BackupLocationExpansion
}

// backupLocations implements BackupLocationInterface
type backupLocations struct {
	client rest.Interface
	ns     string
}

// newBackupLocations returns a BackupLocations
func newBackupLocations(c *StorkV1alpha1Client, namespace string) *backupLocations {
	return &backupLocations{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the backupLocation, and returns the corresponding backupLocation object, and an error if there is any.
func (c *backupLocations) Get(name string, options v1.GetOptions) (result *v1alpha1.BackupLocation, err error) {
	result = &v1alpha1.BackupLocation{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("backuplocations").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of BackupLocations that match those selectors.
func (c *backupLocations) List(opts v1.ListOptions) (result *v1alpha1.BackupLocationList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.BackupLocationList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("backuplocations").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested backupLocations.
func (c *backupLocations) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("backuplocations").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a backupLocation and creates it.  Returns the server's representation of the backupLocation, and an error, if there is any.
func (c *backupLocations) Create(backupLocation *v1alpha1.BackupLocation) (result *v1alpha1.BackupLocation, err error) {
	result = &v1alpha1.BackupLocation{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("backuplocations").
		Body(backupLocation).
		Do().
		Into(result)
	return
}

// Update takes the representation of a backupLocation and updates it. Returns the server's representation of the backupLocation, and an error, if there is any.
func (c *backupLocations) Update(backupLocation *v1alpha1.BackupLocation) (result *v1alpha1.BackupLocation, err error) {
	result = &v1alpha1.BackupLocation{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("backuplocations").
		Name(backupLocation.Name).
		Body(backupLocation).
		Do().
		Into(result)
	return
}

// Delete takes name of the backupLocation and deletes it. Returns an error if one occurs.
func (c *backupLocations) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("backuplocations").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *backupLocations) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("backuplocations").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched backupLocation.
func (c *backupLocations) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.BackupLocation, err error) {
	result = &v1alpha1.BackupLocation{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("backuplocations").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
