/*
Copyright 2018 Openstorage.org

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"time"

	v1alpha1 "github.com/libopenstorage/stork/pkg/apis/stork/v1alpha1"
	scheme "github.com/libopenstorage/stork/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ClusterDomainUpdatesGetter has a method to return a ClusterDomainUpdateInterface.
// A group's client should implement this interface.
type ClusterDomainUpdatesGetter interface {
	ClusterDomainUpdates() ClusterDomainUpdateInterface
}

// ClusterDomainUpdateInterface has methods to work with ClusterDomainUpdate resources.
type ClusterDomainUpdateInterface interface {
	Create(*v1alpha1.ClusterDomainUpdate) (*v1alpha1.ClusterDomainUpdate, error)
	Update(*v1alpha1.ClusterDomainUpdate) (*v1alpha1.ClusterDomainUpdate, error)
	UpdateStatus(*v1alpha1.ClusterDomainUpdate) (*v1alpha1.ClusterDomainUpdate, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1alpha1.ClusterDomainUpdate, error)
	List(opts v1.ListOptions) (*v1alpha1.ClusterDomainUpdateList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.ClusterDomainUpdate, err error)
	ClusterDomainUpdateExpansion
}

// clusterDomainUpdates implements ClusterDomainUpdateInterface
type clusterDomainUpdates struct {
	client rest.Interface
}

// newClusterDomainUpdates returns a ClusterDomainUpdates
func newClusterDomainUpdates(c *StorkV1alpha1Client) *clusterDomainUpdates {
	return &clusterDomainUpdates{
		client: c.RESTClient(),
	}
}

// Get takes name of the clusterDomainUpdate, and returns the corresponding clusterDomainUpdate object, and an error if there is any.
func (c *clusterDomainUpdates) Get(name string, options v1.GetOptions) (result *v1alpha1.ClusterDomainUpdate, err error) {
	result = &v1alpha1.ClusterDomainUpdate{}
	err = c.client.Get().
		Resource("clusterdomainupdates").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ClusterDomainUpdates that match those selectors.
func (c *clusterDomainUpdates) List(opts v1.ListOptions) (result *v1alpha1.ClusterDomainUpdateList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.ClusterDomainUpdateList{}
	err = c.client.Get().
		Resource("clusterdomainupdates").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested clusterDomainUpdates.
func (c *clusterDomainUpdates) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("clusterdomainupdates").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a clusterDomainUpdate and creates it.  Returns the server's representation of the clusterDomainUpdate, and an error, if there is any.
func (c *clusterDomainUpdates) Create(clusterDomainUpdate *v1alpha1.ClusterDomainUpdate) (result *v1alpha1.ClusterDomainUpdate, err error) {
	result = &v1alpha1.ClusterDomainUpdate{}
	err = c.client.Post().
		Resource("clusterdomainupdates").
		Body(clusterDomainUpdate).
		Do().
		Into(result)
	return
}

// Update takes the representation of a clusterDomainUpdate and updates it. Returns the server's representation of the clusterDomainUpdate, and an error, if there is any.
func (c *clusterDomainUpdates) Update(clusterDomainUpdate *v1alpha1.ClusterDomainUpdate) (result *v1alpha1.ClusterDomainUpdate, err error) {
	result = &v1alpha1.ClusterDomainUpdate{}
	err = c.client.Put().
		Resource("clusterdomainupdates").
		Name(clusterDomainUpdate.Name).
		Body(clusterDomainUpdate).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *clusterDomainUpdates) UpdateStatus(clusterDomainUpdate *v1alpha1.ClusterDomainUpdate) (result *v1alpha1.ClusterDomainUpdate, err error) {
	result = &v1alpha1.ClusterDomainUpdate{}
	err = c.client.Put().
		Resource("clusterdomainupdates").
		Name(clusterDomainUpdate.Name).
		SubResource("status").
		Body(clusterDomainUpdate).
		Do().
		Into(result)
	return
}

// Delete takes name of the clusterDomainUpdate and deletes it. Returns an error if one occurs.
func (c *clusterDomainUpdates) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("clusterdomainupdates").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *clusterDomainUpdates) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("clusterdomainupdates").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched clusterDomainUpdate.
func (c *clusterDomainUpdates) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.ClusterDomainUpdate, err error) {
	result = &v1alpha1.ClusterDomainUpdate{}
	err = c.client.Patch(pt).
		Resource("clusterdomainupdates").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
