/*
Copyright 2018 Openstorage.org

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"time"

	v1alpha1 "github.com/libopenstorage/stork/pkg/apis/stork/v1alpha1"
	scheme "github.com/libopenstorage/stork/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// MigrationsGetter has a method to return a MigrationInterface.
// A group's client should implement this interface.
type MigrationsGetter interface {
	Migrations(namespace string) MigrationInterface
}

// MigrationInterface has methods to work with Migration resources.
type MigrationInterface interface {
	Create(*v1alpha1.Migration) (*v1alpha1.Migration, error)
	Update(*v1alpha1.Migration) (*v1alpha1.Migration, error)
	UpdateStatus(*v1alpha1.Migration) (*v1alpha1.Migration, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1alpha1.Migration, error)
	List(opts v1.ListOptions) (*v1alpha1.MigrationList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.Migration, err error)
	MigrationExpansion
}

// migrations implements MigrationInterface
type migrations struct {
	client rest.Interface
	ns     string
}

// newMigrations returns a Migrations
func newMigrations(c *StorkV1alpha1Client, namespace string) *migrations {
	return &migrations{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the migration, and returns the corresponding migration object, and an error if there is any.
func (c *migrations) Get(name string, options v1.GetOptions) (result *v1alpha1.Migration, err error) {
	result = &v1alpha1.Migration{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("migrations").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of Migrations that match those selectors.
func (c *migrations) List(opts v1.ListOptions) (result *v1alpha1.MigrationList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.MigrationList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("migrations").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested migrations.
func (c *migrations) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("migrations").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a migration and creates it.  Returns the server's representation of the migration, and an error, if there is any.
func (c *migrations) Create(migration *v1alpha1.Migration) (result *v1alpha1.Migration, err error) {
	result = &v1alpha1.Migration{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("migrations").
		Body(migration).
		Do().
		Into(result)
	return
}

// Update takes the representation of a migration and updates it. Returns the server's representation of the migration, and an error, if there is any.
func (c *migrations) Update(migration *v1alpha1.Migration) (result *v1alpha1.Migration, err error) {
	result = &v1alpha1.Migration{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("migrations").
		Name(migration.Name).
		Body(migration).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *migrations) UpdateStatus(migration *v1alpha1.Migration) (result *v1alpha1.Migration, err error) {
	result = &v1alpha1.Migration{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("migrations").
		Name(migration.Name).
		SubResource("status").
		Body(migration).
		Do().
		Into(result)
	return
}

// Delete takes name of the migration and deletes it. Returns an error if one occurs.
func (c *migrations) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("migrations").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *migrations) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("migrations").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched migration.
func (c *migrations) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1alpha1.Migration, err error) {
	result = &v1alpha1.Migration{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("migrations").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
