/*
Copyright 2018 Openstorage.org

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/libopenstorage/stork/pkg/apis/stork/v1alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// MigrationLister helps list Migrations.
type MigrationLister interface {
	// List lists all Migrations in the indexer.
	List(selector labels.Selector) (ret []*v1alpha1.Migration, err error)
	// Migrations returns an object that can list and get Migrations.
	Migrations(namespace string) MigrationNamespaceLister
	MigrationListerExpansion
}

// migrationLister implements the MigrationLister interface.
type migrationLister struct {
	indexer cache.Indexer
}

// NewMigrationLister returns a new MigrationLister.
func NewMigrationLister(indexer cache.Indexer) MigrationLister {
	return &migrationLister{indexer: indexer}
}

// List lists all Migrations in the indexer.
func (s *migrationLister) List(selector labels.Selector) (ret []*v1alpha1.Migration, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.Migration))
	})
	return ret, err
}

// Migrations returns an object that can list and get Migrations.
func (s *migrationLister) Migrations(namespace string) MigrationNamespaceLister {
	return migrationNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// MigrationNamespaceLister helps list and get Migrations.
type MigrationNamespaceLister interface {
	// List lists all Migrations in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1alpha1.Migration, err error)
	// Get retrieves the Migration from the indexer for a given namespace and name.
	Get(name string) (*v1alpha1.Migration, error)
	MigrationNamespaceListerExpansion
}

// migrationNamespaceLister implements the MigrationNamespaceLister
// interface.
type migrationNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all Migrations in the indexer for a given namespace.
func (s migrationNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.Migration, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.Migration))
	})
	return ret, err
}

// Get retrieves the Migration from the indexer for a given namespace and name.
func (s migrationNamespaceLister) Get(name string) (*v1alpha1.Migration, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("migration"), name)
	}
	return obj.(*v1alpha1.Migration), nil
}
