/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package v1

import (
	internalinterfaces "github.com/rook/rook/pkg/client/informers/externalversions/internalinterfaces"
)

// Interface provides access to all the informers in this group version.
type Interface interface {
	// CephBlockPools returns a CephBlockPoolInformer.
	CephBlockPools() CephBlockPoolInformer
	// CephBucketNotifications returns a CephBucketNotificationInformer.
	CephBucketNotifications() CephBucketNotificationInformer
	// CephBucketTopics returns a CephBucketTopicInformer.
	CephBucketTopics() CephBucketTopicInformer
	// CephClients returns a CephClientInformer.
	CephClients() CephClientInformer
	// CephClusters returns a CephClusterInformer.
	CephClusters() CephClusterInformer
	// CephFilesystems returns a CephFilesystemInformer.
	CephFilesystems() CephFilesystemInformer
	// CephFilesystemMirrors returns a CephFilesystemMirrorInformer.
	CephFilesystemMirrors() CephFilesystemMirrorInformer
	// CephFilesystemSubVolumeGroups returns a CephFilesystemSubVolumeGroupInformer.
	CephFilesystemSubVolumeGroups() CephFilesystemSubVolumeGroupInformer
	// CephNFSes returns a CephNFSInformer.
	CephNFSes() CephNFSInformer
	// CephObjectRealms returns a CephObjectRealmInformer.
	CephObjectRealms() CephObjectRealmInformer
	// CephObjectStores returns a CephObjectStoreInformer.
	CephObjectStores() CephObjectStoreInformer
	// CephObjectStoreUsers returns a CephObjectStoreUserInformer.
	CephObjectStoreUsers() CephObjectStoreUserInformer
	// CephObjectZones returns a CephObjectZoneInformer.
	CephObjectZones() CephObjectZoneInformer
	// CephObjectZoneGroups returns a CephObjectZoneGroupInformer.
	CephObjectZoneGroups() CephObjectZoneGroupInformer
	// CephRBDMirrors returns a CephRBDMirrorInformer.
	CephRBDMirrors() CephRBDMirrorInformer
}

type version struct {
	factory          internalinterfaces.SharedInformerFactory
	namespace        string
	tweakListOptions internalinterfaces.TweakListOptionsFunc
}

// New returns a new Interface.
func New(f internalinterfaces.SharedInformerFactory, namespace string, tweakListOptions internalinterfaces.TweakListOptionsFunc) Interface {
	return &version{factory: f, namespace: namespace, tweakListOptions: tweakListOptions}
}

// CephBlockPools returns a CephBlockPoolInformer.
func (v *version) CephBlockPools() CephBlockPoolInformer {
	return &cephBlockPoolInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// CephBucketNotifications returns a CephBucketNotificationInformer.
func (v *version) CephBucketNotifications() CephBucketNotificationInformer {
	return &cephBucketNotificationInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// CephBucketTopics returns a CephBucketTopicInformer.
func (v *version) CephBucketTopics() CephBucketTopicInformer {
	return &cephBucketTopicInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// CephClients returns a CephClientInformer.
func (v *version) CephClients() CephClientInformer {
	return &cephClientInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// CephClusters returns a CephClusterInformer.
func (v *version) CephClusters() CephClusterInformer {
	return &cephClusterInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// CephFilesystems returns a CephFilesystemInformer.
func (v *version) CephFilesystems() CephFilesystemInformer {
	return &cephFilesystemInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// CephFilesystemMirrors returns a CephFilesystemMirrorInformer.
func (v *version) CephFilesystemMirrors() CephFilesystemMirrorInformer {
	return &cephFilesystemMirrorInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// CephFilesystemSubVolumeGroups returns a CephFilesystemSubVolumeGroupInformer.
func (v *version) CephFilesystemSubVolumeGroups() CephFilesystemSubVolumeGroupInformer {
	return &cephFilesystemSubVolumeGroupInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// CephNFSes returns a CephNFSInformer.
func (v *version) CephNFSes() CephNFSInformer {
	return &cephNFSInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// CephObjectRealms returns a CephObjectRealmInformer.
func (v *version) CephObjectRealms() CephObjectRealmInformer {
	return &cephObjectRealmInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// CephObjectStores returns a CephObjectStoreInformer.
func (v *version) CephObjectStores() CephObjectStoreInformer {
	return &cephObjectStoreInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// CephObjectStoreUsers returns a CephObjectStoreUserInformer.
func (v *version) CephObjectStoreUsers() CephObjectStoreUserInformer {
	return &cephObjectStoreUserInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// CephObjectZones returns a CephObjectZoneInformer.
func (v *version) CephObjectZones() CephObjectZoneInformer {
	return &cephObjectZoneInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// CephObjectZoneGroups returns a CephObjectZoneGroupInformer.
func (v *version) CephObjectZoneGroups() CephObjectZoneGroupInformer {
	return &cephObjectZoneGroupInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}

// CephRBDMirrors returns a CephRBDMirrorInformer.
func (v *version) CephRBDMirrors() CephRBDMirrorInformer {
	return &cephRBDMirrorInformer{factory: v.factory, namespace: v.namespace, tweakListOptions: v.tweakListOptions}
}
