﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#include <aws/resourcegroupstaggingapi/model/Summary.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace ResourceGroupsTaggingAPI
{
namespace Model
{

Summary::Summary() : 
    m_lastUpdatedHasBeenSet(false),
    m_targetIdHasBeenSet(false),
    m_regionHasBeenSet(false),
    m_resourceTypeHasBeenSet(false),
    m_nonCompliantResources(0),
    m_nonCompliantResourcesHasBeenSet(false)
{
}

Summary::Summary(JsonView jsonValue) : 
    m_lastUpdatedHasBeenSet(false),
    m_targetIdHasBeenSet(false),
    m_regionHasBeenSet(false),
    m_resourceTypeHasBeenSet(false),
    m_nonCompliantResources(0),
    m_nonCompliantResourcesHasBeenSet(false)
{
  *this = jsonValue;
}

Summary& Summary::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("LastUpdated"))
  {
    m_lastUpdated = jsonValue.GetString("LastUpdated");

    m_lastUpdatedHasBeenSet = true;
  }

  if(jsonValue.ValueExists("TargetId"))
  {
    m_targetId = jsonValue.GetString("TargetId");

    m_targetIdHasBeenSet = true;
  }

  if(jsonValue.ValueExists("Region"))
  {
    m_region = jsonValue.GetString("Region");

    m_regionHasBeenSet = true;
  }

  if(jsonValue.ValueExists("ResourceType"))
  {
    m_resourceType = jsonValue.GetString("ResourceType");

    m_resourceTypeHasBeenSet = true;
  }

  if(jsonValue.ValueExists("NonCompliantResources"))
  {
    m_nonCompliantResources = jsonValue.GetInt64("NonCompliantResources");

    m_nonCompliantResourcesHasBeenSet = true;
  }

  return *this;
}

JsonValue Summary::Jsonize() const
{
  JsonValue payload;

  if(m_lastUpdatedHasBeenSet)
  {
   payload.WithString("LastUpdated", m_lastUpdated.ToGmtString(DateFormat::ISO_8601));
  }

  if(m_targetIdHasBeenSet)
  {
   payload.WithString("TargetId", m_targetId);

  }

  if(m_regionHasBeenSet)
  {
   payload.WithString("Region", m_region);

  }

  if(m_resourceTypeHasBeenSet)
  {
   payload.WithString("ResourceType", m_resourceType);

  }

  if(m_nonCompliantResourcesHasBeenSet)
  {
   payload.WithInt64("NonCompliantResources", m_nonCompliantResources);

  }

  return payload;
}

} // namespace Model
} // namespace ResourceGroupsTaggingAPI
} // namespace Aws
