﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#include <aws/robomaker/model/SimulationApplicationSummary.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace RoboMaker
{
namespace Model
{

SimulationApplicationSummary::SimulationApplicationSummary() : 
    m_nameHasBeenSet(false),
    m_arnHasBeenSet(false),
    m_versionHasBeenSet(false),
    m_lastUpdatedAtHasBeenSet(false),
    m_robotSoftwareSuiteHasBeenSet(false),
    m_simulationSoftwareSuiteHasBeenSet(false)
{
}

SimulationApplicationSummary::SimulationApplicationSummary(JsonView jsonValue) : 
    m_nameHasBeenSet(false),
    m_arnHasBeenSet(false),
    m_versionHasBeenSet(false),
    m_lastUpdatedAtHasBeenSet(false),
    m_robotSoftwareSuiteHasBeenSet(false),
    m_simulationSoftwareSuiteHasBeenSet(false)
{
  *this = jsonValue;
}

SimulationApplicationSummary& SimulationApplicationSummary::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("name"))
  {
    m_name = jsonValue.GetString("name");

    m_nameHasBeenSet = true;
  }

  if(jsonValue.ValueExists("arn"))
  {
    m_arn = jsonValue.GetString("arn");

    m_arnHasBeenSet = true;
  }

  if(jsonValue.ValueExists("version"))
  {
    m_version = jsonValue.GetString("version");

    m_versionHasBeenSet = true;
  }

  if(jsonValue.ValueExists("lastUpdatedAt"))
  {
    m_lastUpdatedAt = jsonValue.GetDouble("lastUpdatedAt");

    m_lastUpdatedAtHasBeenSet = true;
  }

  if(jsonValue.ValueExists("robotSoftwareSuite"))
  {
    m_robotSoftwareSuite = jsonValue.GetObject("robotSoftwareSuite");

    m_robotSoftwareSuiteHasBeenSet = true;
  }

  if(jsonValue.ValueExists("simulationSoftwareSuite"))
  {
    m_simulationSoftwareSuite = jsonValue.GetObject("simulationSoftwareSuite");

    m_simulationSoftwareSuiteHasBeenSet = true;
  }

  return *this;
}

JsonValue SimulationApplicationSummary::Jsonize() const
{
  JsonValue payload;

  if(m_nameHasBeenSet)
  {
   payload.WithString("name", m_name);

  }

  if(m_arnHasBeenSet)
  {
   payload.WithString("arn", m_arn);

  }

  if(m_versionHasBeenSet)
  {
   payload.WithString("version", m_version);

  }

  if(m_lastUpdatedAtHasBeenSet)
  {
   payload.WithDouble("lastUpdatedAt", m_lastUpdatedAt.SecondsWithMSPrecision());
  }

  if(m_robotSoftwareSuiteHasBeenSet)
  {
   payload.WithObject("robotSoftwareSuite", m_robotSoftwareSuite.Jsonize());

  }

  if(m_simulationSoftwareSuiteHasBeenSet)
  {
   payload.WithObject("simulationSoftwareSuite", m_simulationSoftwareSuite.Jsonize());

  }

  return payload;
}

} // namespace Model
} // namespace RoboMaker
} // namespace Aws
