# - Try to find LibXML2 headers and libraries.
#
# Usage of this module as follows:
#
#     find_package(LibXML2)
#
# Variables used by this module, they can change the default behaviour and need
# to be set before calling find_package:
#
#  LibXML2_ROOT_DIR  Set this variable to the root installation of
#                    LibXML2 if the module has problems finding
#                    the proper installation path.
#
# Variables defined by this module:
#
#  LIBXML2_FOUND              System has LibXML2 libs/headers
#  LibXML2_LIBRARY          The LibXML2 libraries
#  LibXML2_INCLUDE_DIR        The location of LibXML2 headers

include(LibFindMacros)

# Use pkg-config to get hints about paths
libfind_pkg_check_modules(LibXML2_PKGCONF libxml2)

find_path(LibXML2_ROOT_DIR
    NAMES include/libxml2/libxml/tree.h
)

find_library(LibXML2_LIBRARY
    NAMES xml2
    HINTS ${LibXML2_ROOT_DIR}/lib
)

find_path(LibXML2_INCLUDE_DIR
    NAMES libxml/tree.h
    HINTS ${LibXML2_ROOT_DIR}/include/libxml2
)

set(LibXML2_PROCESS_LIBS LibXML2_LIBRARY)
set(LibXML2_PROCESS_INCLUDES LibXML2_INCLUDE_DIR)

libfind_process(LibXML2)
