// -----------------------------------------------------------------------------------------
// <copyright file="main.cpp" company="Microsoft">
//    Copyright 2019 Microsoft Corporation
//
//    Licensed under the Apache License, Version 2.0 (the "License");
//    you may not use this file except in compliance with the License.
//    You may obtain a copy of the License at
//      http://www.apache.org/licenses/LICENSE-2.0
//
//    Unless required by applicable law or agreed to in writing, software
//    distributed under the License is distributed on an "AS IS" BASIS,
//    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//    See the License for the specific language governing permissions and
//    limitations under the License.
// </copyright>
// -----------------------------------------------------------------------------------------

#include "samples_common.h"


int main(int argc, char** argv)
{
    if (argc != 2)
    {
        printf("Usage: %s <sample name>\n", argv[0]);
    }
    else
    {
        auto ite = Sample::samples().find(argv[1]);
        if (ite == Sample::samples().end())
        {
            printf("Cannot find sample %s\n", argv[1]);
        }
        else
        {
            auto func = ite->second;
            func();
            return 0;
        }
    }

    printf("\nAvailable sample names:\n");
    for (const auto& i : Sample::samples())
    {
        printf("    %s\n", i.first.data());
    }
    return 1;
}