# OpenVINO™ Ecosystem Overview {#openvino_ecosystem}


OpenVINO™ is not just one tool. It is an expansive ecosystem of utilities, providing a comprehensive workflow for deep learning solution development. Learn more about each of them to reach the full potential of OpenVINO™ Toolkit.

### OpenVINO™ Model Server (OVMS)	   
OpenVINO Model Server is a scalable, high-performance solution for serving deep learning models optimized for Intel® architectures. The server uses Inference Engine libraries as a backend and exposes gRPC and HTTP/REST interfaces for inference that are fully compatible with TensorFlow Serving.

More resources:
* [OpenVINO documentation](https://docs.openvino.ai/latest/openvino_docs_ovms.html)
* [Docker Hub](https://hub.docker.com/r/openvino/model_server)
* [GitHub](https://github.com/openvinotoolkit/model_server)
* [Red Hat Ecosystem Catalog](https://catalog.redhat.com/software/container-stacks/detail/60649e41ccfb383fe395a167)

### Neural Network Compression Framework (NNCF)
A suite of advanced algorithms for Neural Network inference optimization with minimal accuracy drop. NNCF applies quantization, filter pruning, binarization and sparsity algorithms to PyTorch and TensorFlow models during training.

More resources:
* [Documentation](@ref docs_nncf_introduction)
* [GitHub](https://github.com/openvinotoolkit/nncf)
* [PyPI](https://pypi.org/project/nncf/)

### OpenVINO™ Security Add-on	 
A solution for Model Developers and Independent Software Vendors to use secure packaging and secure model execution.	 

More resources:
* [documentation](https://docs.openvino.ai/latest/ovsa_get_started.html)
* [GitHub]https://github.com/openvinotoolkit/security_addon)


### OpenVINO™ integration with TensorFlow (OVTF)
A solution empowering TensorFlow developers with OpenVINO's optimization capabilities. With just two lines of code in your application, you can offload inference to OpenVINO, while keeping the TensorFlow API.

More resources:
* [documentation](https://github.com/openvinotoolkit/openvino_tensorflow)	 
* [PyPI](https://pypi.org/project/openvino-tensorflow/) 
* [GitHub](https://github.com/openvinotoolkit/openvino_tensorflow)

### DL Streamer		
A streaming media analytics framework, based on the GStreamer multimedia framework, for creating complex media analytics pipelines.

More resources:
* [documentation on GitHub](https://openvinotoolkit.github.io/dlstreamer_gst/)
* [installation Guide on GitHub](https://github.com/openvinotoolkit/dlstreamer_gst/wiki/Install-Guide)

### DL Workbench
A web-based tool for deploying deep learning models. Built on the core of OpenVINO and equipped with a graphics user interface, DL Workbench is a great way to explore the possibilities of the OpenVINO workflow, import, analyze, optimize, and build your pre-trained models. You can do all that by visiting [Intel® DevCloud for the Edge](https://software.intel.com/content/www/us/en/develop/tools/devcloud.html) and launching DL Workbench on-line.

More resources:
* [documentation](dl_workbench_overview.md)
* [Docker Hub](https://hub.docker.com/r/openvino/workbench)
* [PyPI](https://pypi.org/project/openvino-workbench/)

### OpenVINO™ Training Extensions (OTE)
A convenient environment to train Deep Learning models and convert them using the OpenVINO™ toolkit for optimized inference.

More resources:
* [GitHub](https://github.com/openvinotoolkit/training_extensions)

### Computer Vision Annotation Tool (CVAT)
An online, interactive video and image annotation tool for computer vision purposes.

More resources:
* [documentation on GitHub](https://openvinotoolkit.github.io/cvat/docs/)	
* [web application](https://cvat.org/) 
* [Docker Hub](https://hub.docker.com/r/openvino/cvat_server) 
* [GitHub](https://github.com/openvinotoolkit/cvat)

### Dataset Management Framework (Datumaro)
A framework and CLI tool to build, transform, and analyze datasets.

More resources:
* [documentation on GitHub](https://openvinotoolkit.github.io/datumaro/docs/)
* [PyPI](https://pypi.org/project/datumaro/)
* [GitHub](https://github.com/openvinotoolkit/datumaro)

