# OpenVINO™ and TensorFlow Comparison on Select Networks and Platforms

This page presents the results of comparing OpenVINO™ and TensorFlow executing benchmarking on the same hardware platforms, and using neural network models based on the same original source models. All models were converted using the processes and conversion tools native to each framework. The hardware platforms represent a broad performance range, covering Intel® Celeron®, Intel® Core™, and  Intel® Xeon® Scalable based platforms. (Refer to [System Description](https://docs.openvino.ai/resources/benchmark_files/system_configurations_2022.1.html) for further details).

## deeplabv3

@sphinxdirective
.. raw:: html

    <div class="chart-block-tf-ov" data-loadcsv="csv/deeplabv3-ovino-vs-tf.csv"></div>

@endsphinxdirective

## densenet-121

@sphinxdirective
.. raw:: html

    <div class="chart-block-tf-ov" data-loadcsv="csv/densenet-121-ovino-vs-tf.csv"></div>

@endsphinxdirective

## facenet-20180408-102900

@sphinxdirective
.. raw:: html

    <div class="chart-block-tf-ov" data-loadcsv="csv/facenet-20180408-102900-ovino-vs-tf.csv"></div>

@endsphinxdirective

## faster_rcnn_resnet50_coco

@sphinxdirective
.. raw:: html

    <div class="chart-block-tf-ov" data-loadcsv="csv/faster_rcnn_resnet50_coco-ovino-vs-tf.csv"></div>

@endsphinxdirective

## inception-v3

@sphinxdirective
.. raw:: html

    <div class="chart-block-tf-ov" data-loadcsv="csv/inception-v3-ovino-vs-tf.csv"></div>

@endsphinxdirective

## inception-v4

@sphinxdirective
.. raw:: html

    <div class="chart-block-tf-ov" data-loadcsv="csv/inception-v4-ovino-vs-tf.csv"></div>

@endsphinxdirective

## resnet-50

@sphinxdirective
.. raw:: html

    <div class="chart-block-tf-ov" data-loadcsv="csv/resnet-50-ovino-vs-tf.csv"></div>

@endsphinxdirective

## ssd_mobilenet_v1_coco

@sphinxdirective
.. raw:: html

    <div class="chart-block-tf-ov" data-loadcsv="csv/ssd_mobilenet_v1_coco-ovino-vs-tf.csv"></div>

@endsphinxdirective

## ssd_resnet34_1200x1200

@sphinxdirective
.. raw:: html

    <div class="chart-block-tf-ov" data-loadcsv="csv/ssd_resnet34_1200x1200-ovino-vs-tf.csv"></div>

@endsphinxdirective

## yolo-v3-tiny

@sphinxdirective
.. raw:: html

    <div class="chart-block-tf-ov" data-loadcsv="csv/yolo-v3-tiny-ovino-vs-tf.csv"></div>

@endsphinxdirective

## YOLOv4

@sphinxdirective
.. raw:: html

    <div class="chart-block-tf-ov" data-loadcsv="csv/YOLOv4-ovino-vs-tf.csv"></div>

@endsphinxdirective