# Model Zoo {#model_zoo}


@sphinxdirective

.. _model zoo:

.. toctree::
   :maxdepth: 1
   :hidden:
   :caption: Pre-Trained Models
   
   omz_models_group_intel
   omz_models_group_public

.. toctree::
   :maxdepth: 1
   :hidden:
   :caption: Demo Applications

   omz_demos

.. toctree::
   :maxdepth: 1
   :hidden:
   :caption: Model API

   omz_model_api_ovms_adapter

   
@endsphinxdirective

Open Model Zoo for OpenVINO™ toolkit delivers a wide variety of free, pre-trained deep learning models and demo applications that provide full application templates to help you implement deep learning in Python, C++, or OpenCV Graph API (G-API). Models and demos are avalable in the [Open Model Zoo GitHub repo](https://github.com/openvinotoolkit/open_model_zoo) and licensed under Apache License Version 2.0. 

Browse through over 200 neural network models, both [public](@ref omz_models_group_public) and from [Intel](@ref omz_models_group_intel), and pick the right one for your solution. Types include object detection, classification, image segmentation, handwriting recognition, text to speech, pose estimation, and others. The Intel models have already been converted to work with OpenVINO™ toolkit, while public models can easily be converted using the [Model Optimizer](@ref openvino_docs_MO_DG_Deep_Learning_Model_Optimizer_DevGuide) utility.

Get started with simple [step-by-step procedures](get_started/get_started_demos.md) to learn how to build and run demo applications or discover the [full set of demos](@ref omz_demos) and adapt them for implementing specific deep learning scenarios in your applications.