# Available Operations Sets {#openvino_docs_ops_opset}

@sphinxdirective

.. toctree::
   :maxdepth: 1
   :hidden:

   openvino_docs_ops_opset9
   openvino_docs_ops_opset8
   openvino_docs_ops_opset7
   openvino_docs_ops_opset6
   openvino_docs_ops_opset5
   openvino_docs_ops_opset4
   openvino_docs_ops_opset3
   openvino_docs_ops_opset2
   openvino_docs_ops_opset1

@endsphinxdirective

According to capabilities of supported deep learning frameworks and hardware capabilities of a target inference device, all operations are combined into operations sets each fully supported in a specific version of OpenVINO™ toolkit.

This topic provides a complete list of available sets of operations supported in different versions of OpenVINO™ toolkit. Use the relevant version of the operations set for a particular release. For a list of operations included into an operations set, click a link in the table.

| OpenVINO™ Version | Actual Operations Set            |
| :---------------- | :------------------------------- |
| 2022.2            | [opset9](opset9.md)   |
| 2022.1            | [opset8](opset8.md)   |
| 2021.4            | [opset7](opset7.md)   |
| 2021.3            | [opset6](opset6.md)   |
| 2021.2            | [opset5](opset5.md)   |
| 2021.1            | [opset4](opset4.md)   |
| 2020.4            | [opset3](opset3.md)   |
| 2020.3            | [opset2](opset2.md)   |
| 2020.2            | [opset2](opset2.md)   |
| 2020.1            | [opset1](opset1.md)   |

## See Also
[Deep Learning Network Intermediate Representation and Operations Sets in OpenVINO™](../MO_DG/IR_and_opsets.md)
