// Copyright (C) 2018-2022 Intel Corporation
// SPDX-License-Identifier: Apache-2.0
//

#pragma once

#include <ngraph/op/op.hpp>
#include "load.hpp"

namespace ngraph {
namespace snippets {
namespace op {

/**
 * @interface ScalarLoad
 * @brief Generated by Canonicalization for a scalar value load to vector register
 * @ingroup snippets
 */
class ScalarLoad : public Load {
public:
    OPENVINO_OP("ScalarLoad", "SnippetsOpset", ngraph::snippets::op::Load);

    ScalarLoad(const Output<Node>& x);
    ScalarLoad() = default;

    std::shared_ptr<Node> clone_with_new_inputs(const OutputVector& new_args) const override {
        check_new_args_count(this, new_args);
        return std::make_shared<ScalarLoad>(new_args.at(0));
    }
};

} // namespace op
} // namespace snippets
} // namespace ngraph