# Copyright (C) 2018-2022 Intel Corporation
# SPDX-License-Identifier: Apache-2.0

from openvino.tools.mo.front.extractor import FrontExtractorOp
from openvino.tools.mo.ops.activation_ops import SoftSign


class SoftSignExtractor(FrontExtractorOp):
    op = 'softsign'
    enabled = True

    @classmethod
    def extract(cls, node):
        SoftSign.update_node_stat(node, {})
        return cls.enabled
