# Copyright (C) 2018-2022 Intel Corporation
# SPDX-License-Identifier: Apache-2.0

from openvino.tools.mo.ops.einsum import Einsum
from openvino.tools.mo.front.extractor import FrontExtractorOp
from openvino.tools.mo.front.onnx.extractors.utils import onnx_attr


class EinsumExtractor(FrontExtractorOp):
    op = 'Einsum'
    enabled = True

    @classmethod
    def extract(cls, einsum_node):
        einsum_name = einsum_node.soft_get('name', einsum_node.id)
        equation = onnx_attr(einsum_node, 'equation', 's').decode(encoding="utf-8")
        normalized_equation = Einsum.normalize_equation(einsum_name, equation)
        Einsum.update_node_stat(einsum_node, {'equation': normalized_equation})
        return cls.enabled
