/**
 * 
 */
package com.amentra.metamatrix.solr;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Properties;

import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;

import com.metamatrix.data.api.Connection;
import com.metamatrix.data.api.ConnectorCapabilities;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.api.ConnectorMetadata;
import com.metamatrix.data.api.Execution;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import com.metamatrix.data.pool.ConnectionPool;
import com.metamatrix.data.pool.SourceConnection;

/**
 * @author Michael Walker
 *
 */
public class SolrConnection implements Connection, SourceConnection {
	private ConnectorLogger logger;
	private CommonsHttpSolrServer server;
	private boolean useLowerCase;
	private ConnectionPool pool;
	private int maxInCriteriaSize;
	/**
	 * 
	 */
	public SolrConnection(ConnectorLogger logger, Properties props) {
		this.logger = logger;
		String url = props.getProperty("SolrServerURL");
		String soTimeout = props.getProperty("SoTimeout", null);
		String connTimeout = props.getProperty("ConnectionTimeout", null);
		String maxConns = props.getProperty("DefaultMaxConnectionsPerHost", null);
		String allowCompression = props.getProperty("AllowCompression", "true");
		String maxRetries = props.getProperty("MaxRetries", "0");
		useLowerCase = new Boolean(props.getProperty("LowerCaseSearch", "true"));
		maxInCriteriaSize = new Integer(props.getProperty("MaxInCriteriaSize", "1000"));
		
		try {
			server = new CommonsHttpSolrServer(url);
			if(soTimeout != null) {
				server.setSoTimeout(new Integer(soTimeout));
			}
			if(connTimeout != null) {
				server.setConnectionTimeout(new Integer(connTimeout));
			}
			if(maxConns != null) {
				server.setMaxTotalConnections(new Integer(maxConns));
			}
			if(allowCompression != null) {
				server.setAllowCompression(new Boolean(allowCompression));
			}
			if(maxRetries != null) {
				server.setMaxRetries(new Integer(maxRetries));
			}

			
			
		} catch (MalformedURLException e) {
			e.printStackTrace();
		} catch (NumberFormatException ne) {
			logger.logError("Property could not be converted to integer. Please check the binding properties.", ne);
		}

	}
	
	public void setConnectionPool(ConnectionPool pool) {
		this.pool = pool;
	}

	/* (non-Javadoc)
	 * @see com.metamatrix.data.api.Connection#createExecution(int, com.metamatrix.data.api.ExecutionContext, com.metamatrix.data.metadata.runtime.RuntimeMetadata)
	 */
	
	public Execution createExecution(int executionMode,
			ExecutionContext executionContext, RuntimeMetadata md)
			throws ConnectorException {
		// TODO Auto-generated method stub
		switch(executionMode) { 
			case ConnectorCapabilities.EXECUTION_MODE.SYNCH_QUERY:
			{
				return new SyncQueryExecution(md, server, logger, useLowerCase);
			}
			default:
			{
				throw new ConnectorException("LDAPConnector does not support requested execution mode.");
			}
		}
	}

	/* (non-Javadoc)
	 * @see com.metamatrix.data.api.Connection#getCapabilities()
	 */
	
	public ConnectorCapabilities getCapabilities() {
		SolrCapabilities caps = new SolrCapabilities();
		caps.setMaxInCriteria(maxInCriteriaSize);
		return caps;
	}

	/* (non-Javadoc)
	 * @see com.metamatrix.data.api.Connection#getMetadata()
	 */
	
	public ConnectorMetadata getMetadata() {
		// TODO Auto-generated method stub
		return null;
	}

	/* (non-Javadoc)
	 * @see com.metamatrix.data.api.Connection#release()
	 */

	
	public void release() {
		pool.release(this);
	}


	/**
	/* Does nothing -- don't see a way to close the server connection here, based on the SolrJ API.
	 */
	public void closeSource() throws ConnectorException {
		// TODO Auto-generated method stub
		
	}


	public boolean isAlive() {
		// TODO Auto-generated method stub
		try {
			server.ping();
		} catch (SolrServerException e) {
			e.printStackTrace();
			return false;
		} catch (IOException e) {
			e.printStackTrace();
			return false;
		}
		return true;
	}


	public boolean isFailed() {
		// TODO Auto-generated method stub
		return false;
	}

}
