/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.base;

import com.metamatrix.connector.xml.XMLConnectorState;
import com.metamatrix.connector.xml.base.Messages;
import com.metamatrix.connector.xml.base.StatefulConnector;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.exception.ConnectorException;
import java.util.Properties;

public abstract class LoggingConnector
implements StatefulConnector {
    private static ConnectorLogger m_logger;
    private ConnectorEnvironment m_environment;
    protected XMLConnectorState m_state;

    public void initialize(ConnectorEnvironment environment) throws ConnectorException {
        try {
            m_logger = environment.getLogger();
            this.m_environment = environment;
            this.m_state = this.createState(this.m_environment.getProperties());
            this.m_state.checkLicense();
        }
        catch (RuntimeException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    public ConnectorLogger getLogger() {
        return m_logger;
    }

    public ConnectorEnvironment getEnvironment() {
        return this.m_environment;
    }

    public XMLConnectorState getState() {
        return this.m_state;
    }

    private XMLConnectorState createState(Properties props) throws ConnectorException {
        String stateClassName = props.getProperty("ConnectorStateClass");
        XMLConnectorState state = null;
        try {
            state = (XMLConnectorState)Class.forName(stateClassName).newInstance();
            state.setLogger(this.getLogger());
            state.setState(props);
        }
        catch (Exception e) {
            ConnectorException ce = new ConnectorException(Messages.getString("XMLConnector.could.not.create.state") + stateClassName);
            ce.initCause((Throwable)e);
            throw ce;
        }
        return state;
    }
}

