/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.types;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.types.InvalidReferenceException;
import com.metamatrix.common.types.Streamable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public final class BlobType
implements Streamable,
Blob {
    transient Blob srcBlob;
    String streamId;
    String persistentId;
    long length = -1L;

    BlobType() {
    }

    public BlobType(Blob blob) {
        if (blob == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("BlobValue.isNUll"));
        }
        this.srcBlob = blob;
        try {
            this.length = blob.length();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public String getReferenceStreamId() {
        return this.streamId;
    }

    public void setReferenceStreamId(String id) {
        this.streamId = id;
    }

    public String getPersistenceStreamId() {
        return this.persistentId;
    }

    public void setPersistenceStreamId(String id) {
        this.persistentId = id;
    }

    public InputStream getBinaryStream() throws SQLException {
        this.checkReference();
        return this.srcBlob.getBinaryStream();
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        this.checkReference();
        return this.srcBlob.getBytes(pos, length);
    }

    public long length() throws SQLException {
        if (this.length != -1L) {
            return this.length;
        }
        this.checkReference();
        return this.srcBlob.length();
    }

    public long position(Blob pattern, long start) throws SQLException {
        this.checkReference();
        return this.srcBlob.position(pattern, start);
    }

    public long position(byte[] pattern, long start) throws SQLException {
        this.checkReference();
        return this.srcBlob.position(pattern, start);
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        this.checkReference();
        return this.srcBlob.setBinaryStream(pos);
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        this.checkReference();
        return this.srcBlob.setBytes(pos, bytes, offset, len);
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        this.checkReference();
        return this.srcBlob.setBytes(pos, bytes);
    }

    public void truncate(long len) throws SQLException {
        this.checkReference();
        this.srcBlob.truncate(len);
    }

    public boolean equals(Object o) {
        this.checkReference();
        return this.srcBlob.equals(o);
    }

    public String toString() {
        this.checkReference();
        return this.srcBlob.toString();
    }

    private void checkReference() {
        if (this.srcBlob == null) {
            throw new InvalidReferenceException(CommonPlugin.Util.getString("BlobValue.InvalidReference"));
        }
    }

    public static byte[] getByteArray(Blob blob) throws SQLException, IOException {
        InputStream reader = blob.getBinaryStream();
        ByteArrayOutputStream writer = new ByteArrayOutputStream();
        int c = reader.read();
        while (c != -1) {
            writer.write((byte)c);
            c = reader.read();
        }
        reader.close();
        byte[] data = writer.toByteArray();
        writer.close();
        return data;
    }
}

