/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.informix.sqli;

import com.metamatrix.jdbc.informix.InformixImplStatement;
import com.metamatrix.jdbc.informix.sqli.InformixSQLICommunication;
import com.metamatrix.jdbc.informix.sqli.InformixSQLIRequest;
import com.metamatrix.util.UtilException;
import java.sql.SQLException;

public class InformixSQLICursorRequest
extends InformixSQLIRequest {
    private static String footprint = "$Revision:   3.2.1.0  $";
    protected String cursorName = null;
    private int resultSetType;
    private int resultSetConcurrency;

    public InformixSQLICursorRequest(InformixSQLICommunication informixSQLICommunication, InformixImplStatement informixImplStatement, String string, int n, int n2) {
        super(informixSQLICommunication, informixImplStatement);
        this.sql = string;
        this.resultSetType = n;
        this.resultSetConcurrency = n2;
    }

    public void openPreparedCursor() throws SQLException {
        try {
            this.cursorName = "_ifx_" + this.comm.getImplConnection().getNextCursorId();
            this.writePacket(4);
            this.writePacket(3);
            if (this.numInputs > 0) {
                this.writePacket(5);
            }
            this.writePacket(6);
            this.writePacket(12);
            this.writer.send();
            this.processReply();
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public void openCursor() throws SQLException {
        try {
            this.writePacket(1);
            this.writePacket(22);
            this.writePacket(49);
            this.writePacket(12);
            this.submitRequest();
            this.processReply();
            if (this.getNumberOfColumns() > 0) {
                this.cursorName = "_ifx_" + this.comm.getImplConnection().getNextCursorId();
                this.writePacket(4);
                this.writePacket(3);
                this.writePacket(43);
                this.writePacket(6);
                this.writePacket(12);
                this.writer.send();
                this.processReply();
            } else {
                this.writePacket(7);
                this.writePacket(12);
                this.writer.send();
                this.processReply();
            }
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public void closeCursor() throws SQLException {
        if (this.cursorName == null) {
            return;
        }
        try {
            this.writePacket(4);
            this.writePacket(10);
            this.writePacket(12);
            this.writer.send();
            this.processReply();
            this.cursorName = null;
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException((Exception)((Object)utilException));
        }
        this.cursorName = null;
    }

    public void writePacket(int n) throws SQLException, UtilException {
        switch (n) {
            case 3: {
                this.writer.writeInt16(n);
                this.comm.writeString(this.cursorName);
                break;
            }
            default: {
                super.writePacket(n);
            }
        }
    }

    public boolean absolute(int n) throws SQLException, UtilException {
        this.isDone = false;
        this.writer.writeInt16(23);
        this.writer.writeInt16(6);
        this.writer.writeInt32(n);
        this.writer.writeInt16(this.tupleBufferSize);
        this.writePacket(12);
        this.submitRequest();
        this.processReply();
        return !this.isDone;
    }

    public boolean last() throws SQLException, UtilException {
        this.isDone = false;
        this.writer.writeInt16(23);
        this.writer.writeInt16(4);
        this.writer.writeInt32(0);
        this.writer.writeInt16(this.tupleBufferSize);
        this.writePacket(12);
        this.submitRequest();
        this.processReply();
        return !this.isDone;
    }

    public boolean previous() throws SQLException, UtilException {
        this.isDone = false;
        this.writer.writeInt16(23);
        this.writer.writeInt16(2);
        this.writer.writeInt32(1);
        this.writer.writeInt16(this.tupleBufferSize);
        this.writePacket(12);
        this.submitRequest();
        this.processReply();
        return !this.isDone;
    }
}

