/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle.net8;

import com.metamatrix.jdbc.base.BaseColumn;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.oracle.OracleColumn;
import com.metamatrix.jdbc.oracle.OracleImplConnection;
import com.metamatrix.jdbc.oracle.OracleInternalParameter;
import com.metamatrix.jdbc.oracle.OracleInternalParameterSet;
import com.metamatrix.jdbc.oracle.net8.OracleDataConsumer;
import com.metamatrix.jdbc.oracle.net8.OracleDataProvider;
import com.metamatrix.jdbc.oracle.net8.TTIDCBDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIDataPacket;
import com.metamatrix.util.UtilException;
import java.sql.SQLException;

public class TTIRXDDataPacket
extends TTIDataPacket {
    private static String footprint = "$Revision:   3.38.1.6  $";
    private BaseColumn[] cols;
    private int nrOfCols;
    private byte[][] CurrentRow;
    private int[] CurrentLen;
    private int Offset;
    private byte[][] TmpBuf = new byte[1][];
    private int[] TmpLen = new int[1];
    private OracleInternalParameterSet m_parameters;
    private BaseExceptions baseexcepts;
    private OracleImplConnection myImplConn = null;
    private OracleDataConsumer writerInUse = null;
    private OracleDataProvider readerInUse = null;
    private static byte[] nullValue = new byte[0];
    private int[] returnedLength = new int[1];
    private byte[] vnuBuffer = null;
    private byte[] timeStampWithTZBuff = null;
    public byte[] m_sentMask = null;
    private boolean useOAll7;
    private boolean bIsProcParameters = false;
    static byte[] s_base64CharMap = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};

    public TTIRXDDataPacket(OracleImplConnection oracleImplConnection, boolean bl) {
        this.myImplConn = oracleImplConnection;
        this.cols = null;
        this.nrOfCols = 0;
        this.m_parameters = null;
        this.TTCCode = 7;
        this.useOAll7 = bl;
    }

    public TTIRXDDataPacket(int n, OracleImplConnection oracleImplConnection, boolean bl) {
        this.myImplConn = oracleImplConnection;
        this.cols = null;
        this.nrOfCols = 0;
        this.m_parameters = null;
        this.TTCCode = n;
        this.useOAll7 = bl;
    }

    public TTIRXDDataPacket(OracleInternalParameterSet oracleInternalParameterSet, OracleImplConnection oracleImplConnection, boolean bl) {
        this.myImplConn = oracleImplConnection;
        this.cols = null;
        this.nrOfCols = 0;
        this.m_parameters = oracleInternalParameterSet;
        this.TTCCode = 7;
        this.useOAll7 = bl;
    }

    public OracleDataProvider getReader() {
        return this.readerInUse;
    }

    public TTIRXDDataPacket(BaseColumn[] baseColumnArray, OracleImplConnection oracleImplConnection, boolean bl) {
        this.myImplConn = oracleImplConnection;
        this.nrOfCols = baseColumnArray.length;
        this.cols = baseColumnArray;
        this.m_parameters = null;
        this.TTCCode = 7;
        this.CurrentRow = null;
        this.useOAll7 = bl;
    }

    public void setCurrentRow(byte[][] byArray, int[] nArray, int n) {
        this.CurrentRow = byArray;
        this.CurrentLen = nArray;
        this.Offset = n;
    }

    public void reset(BaseColumn[] baseColumnArray) {
        this.nrOfCols = baseColumnArray.length;
        this.cols = baseColumnArray;
        this.m_parameters = null;
        this.TTCCode = 7;
    }

    public TTIRXDDataPacket(OracleInternalParameterSet oracleInternalParameterSet, OracleImplConnection oracleImplConnection, boolean bl, boolean bl2) {
        this.myImplConn = oracleImplConnection;
        this.m_parameters = oracleInternalParameterSet;
        this.cols = null;
        this.nrOfCols = 0;
        this.TTCCode = 7;
        this.bIsProcParameters = bl;
        this.useOAll7 = bl2;
    }

    public void setParameters(OracleInternalParameterSet oracleInternalParameterSet) {
        this.m_parameters = oracleInternalParameterSet;
    }

    public void reset(OracleInternalParameterSet oracleInternalParameterSet, int n, OracleImplConnection oracleImplConnection, boolean bl) {
        this.myImplConn = oracleImplConnection;
        this.m_parameters = oracleInternalParameterSet;
        this.cols = null;
        this.nrOfCols = 0;
        this.TTCCode = 7;
        this.bIsProcParameters = bl;
    }

    public void setBaseExceptions(BaseExceptions baseExceptions) {
        this.baseexcepts = baseExceptions;
    }

    public int readRXDDataInBuffer(byte[] byArray, int n, BaseExceptions baseExceptions) throws SQLException {
        int n2;
        try {
            n2 = this.readerInUse.readCLRInBuf(byArray, n, byArray.length - n);
        }
        catch (UtilException utilException) {
            throw baseExceptions.getException((Exception)((Object)utilException));
        }
        return n2;
    }

    public int readRXDDataInBuffer(byte[] byArray, BaseExceptions baseExceptions) throws SQLException {
        int n;
        try {
            n = this.readerInUse.readCLRInBuf(byArray, 0, byArray.length);
        }
        catch (UtilException utilException) {
            throw baseExceptions.getException((Exception)((Object)utilException));
        }
        return n;
    }

    public int readExtraLongLen(BaseExceptions baseExceptions) throws SQLException {
        int n = 0;
        try {
            n = this.readerInUse.readB4();
        }
        catch (UtilException utilException) {
            throw baseExceptions.getException((Exception)((Object)utilException));
        }
        return n;
    }

    public byte[] readRXDData(int n, BaseExceptions baseExceptions) throws SQLException {
        byte[] byArray = null;
        try {
            byArray = this.readerInUse.readCLR(n);
            if (this.readerInUse.readB2() != 0) {
                byArray = null;
            }
        }
        catch (UtilException utilException) {
            throw baseExceptions.getException((Exception)((Object)utilException));
        }
        return byArray;
    }

    public byte[] readRXDDataWithoutIndicator(int n, BaseExceptions baseExceptions) throws SQLException {
        byte[] byArray = null;
        try {
            byArray = this.readerInUse.readCLR(n);
        }
        catch (UtilException utilException) {
            throw baseExceptions.getException((Exception)((Object)utilException));
        }
        return byArray;
    }

    public void streamOut(OracleDataConsumer oracleDataConsumer) throws UtilException, SQLException {
        if (this.m_parameters != null) {
            OracleInternalParameter oracleInternalParameter;
            boolean bl = false;
            int n = this.m_parameters.getNumParams();
            int n2 = 0;
            while (n2 < n) {
                oracleInternalParameter = this.m_parameters.paramSet[n2];
                if ((oracleInternalParameter.m_direction & 0x20) != 0) {
                    if (oracleInternalParameter.m_writeDataAtEndOfRXD) {
                        bl = true;
                    } else {
                        if (oracleInternalParameter.m_nativeBindType == 112 || oracleInternalParameter.m_nativeBindType == 113) {
                            oracleDataConsumer.writeB4(86);
                        }
                        if (oracleInternalParameter.m_nativeDataIn == null) {
                            oracleDataConsumer.writeByte((byte)0);
                        } else {
                            oracleDataConsumer.writeCLR(oracleInternalParameter.m_nativeDataIn, oracleInternalParameter.m_nativeDataInOffset, oracleInternalParameter.m_nativeDataInLength);
                        }
                    }
                } else {
                    oracleDataConsumer.writeByte((byte)0);
                }
                ++n2;
            }
            if (bl) {
                int n3 = 0;
                while (n3 < n) {
                    oracleInternalParameter = this.m_parameters.paramSet[n3];
                    if ((oracleInternalParameter.m_direction & 0x20) != 0 && oracleInternalParameter.m_writeDataAtEndOfRXD) {
                        oracleInternalParameter.writeData(oracleDataConsumer);
                    }
                    ++n3;
                }
            }
        }
    }

    private boolean skipValue(int n) {
        if (this.m_sentMask == null) {
            return false;
        }
        int n2 = 1 << n % 8;
        byte by = this.m_sentMask[n / 8];
        return (n2 & by) == 0;
    }

    public void streamIn(OracleDataProvider oracleDataProvider) throws UtilException, SQLException {
        block45: {
            block44: {
                this.readerInUse = oracleDataProvider;
                if (this.cols == null) break block44;
                int n = 0;
                while (n < this.nrOfCols) {
                    OracleColumn oracleColumn = (OracleColumn)this.cols[n];
                    if (this.skipValue(n)) {
                        if (this.CurrentRow != null) {
                            if (oracleColumn.indicator != 0) {
                                this.CurrentLen[this.Offset + n] = -1;
                            } else {
                                this.CurrentLen[this.Offset + n] = oracleColumn.len;
                                if (oracleColumn.data != null) {
                                    if (this.CurrentRow[this.Offset + n] == null || this.CurrentRow[this.Offset + n].length < oracleColumn.data.length) {
                                        this.CurrentRow[this.Offset + n] = new byte[oracleColumn.data.length];
                                    }
                                    System.arraycopy(oracleColumn.data, 0, this.CurrentRow[this.Offset + n], 0, oracleColumn.data.length);
                                    oracleColumn.data = this.CurrentRow[this.Offset + n];
                                }
                            }
                        }
                    } else {
                        oracleColumn.indicator = 0;
                        if (!this.useOAll7 && oracleColumn.isAlwaysNull) {
                            oracleColumn.indicator = -1;
                        } else {
                            int n2 = Math.min(oracleColumn.precision, 4000);
                            if (oracleColumn.OCINativeType == 109) {
                                int n3 = oracleDataProvider.readB4();
                                if (n3 > 0) {
                                    oracleDataProvider.readCLR(n3);
                                }
                                if ((n3 = oracleDataProvider.readB4()) > 0) {
                                    oracleDataProvider.readCLR(n3);
                                }
                                if ((n3 = oracleDataProvider.readB4()) > 0) {
                                    oracleDataProvider.readCLR(n3);
                                }
                                n3 = oracleDataProvider.readB2();
                                int n4 = oracleDataProvider.readB4();
                                n3 = oracleDataProvider.readB2();
                                if (n4 > 0) {
                                    oracleColumn.data = oracleDataProvider.readCLR(n4);
                                    byte[] byArray = new byte[n4 - 8];
                                    System.arraycopy(oracleColumn.data, 8, byArray, 0, n4 - 8);
                                    oracleColumn.data = byArray;
                                    oracleColumn.len = byArray.length;
                                } else {
                                    oracleColumn.data = nullValue;
                                    oracleColumn.indicator = -1;
                                }
                            } else if (oracleColumn.OCINativeType == 11) {
                                long l = 0L;
                                long l2 = 0L;
                                long l3 = 0L;
                                long l4 = 0L;
                                byte by = oracleDataProvider.readByte();
                                if (by != 0) {
                                    l = oracleDataProvider.readSB4();
                                    l2 = oracleDataProvider.readB4();
                                    oracleDataProvider.readByte();
                                    l3 = oracleDataProvider.readSB4();
                                    l4 = oracleDataProvider.readB4();
                                }
                                if (l == 0L && l2 == 0L && l3 == 0L && l4 == 0L) {
                                    oracleColumn.len = -1;
                                } else {
                                    oracleColumn.data = new byte[18];
                                    oracleColumn.len = TTIRXDDataPacket.ConvertRowidSegmentsToBase64Ascii(l, l2, l3, l4, oracleColumn.data, 0);
                                }
                            } else if (oracleColumn.OCINativeType == 112 || oracleColumn.OCINativeType == 113 || oracleColumn.OCINativeType == 114) {
                                n2 = oracleDataProvider.readB4();
                                if (n2 > 0) {
                                    oracleColumn.data = oracleDataProvider.readCLR(n2);
                                    oracleColumn.len = oracleColumn.data.length;
                                } else {
                                    oracleColumn.indicator = -1;
                                }
                            } else if (this.CurrentRow != null) {
                                this.TmpBuf[0] = this.CurrentRow[this.Offset + n];
                                if (this.TmpBuf[0] == null) {
                                    this.TmpBuf[0] = oracleColumn.m_defineMaxLength <= 3000 ? new byte[oracleColumn.m_defineMaxLength + 1] : new byte[3000];
                                }
                                oracleColumn.len = oracleDataProvider.readCLR(this.TmpBuf);
                                oracleColumn.data = this.TmpBuf[0];
                            } else {
                                oracleColumn.data = oracleDataProvider.readCLR(n2);
                                oracleColumn.len = oracleColumn.data.length;
                            }
                        }
                        if (this.useOAll7) {
                            oracleColumn.indicator = oracleDataProvider.readB2();
                        } else if (this.myImplConn.oracleServerVersion < 902000000L || oracleColumn.OCINativeType == 8 || oracleColumn.OCINativeType == 24) {
                            oracleColumn.indicator = oracleDataProvider.readB2();
                            oracleDataProvider.skipB4();
                        }
                    }
                    if (this.CurrentRow != null) {
                        if (oracleColumn.indicator != 0) {
                            this.CurrentLen[this.Offset + n] = -1;
                        } else {
                            this.CurrentRow[this.Offset + n] = oracleColumn.data;
                            this.CurrentLen[this.Offset + n] = oracleColumn.len;
                        }
                    }
                    ++n;
                }
                break block45;
            }
            if (this.m_parameters == null || this.m_parameters.getNumParams() <= 0) break block45;
            boolean bl = true;
            boolean bl2 = false;
            int n = 0;
            while (n < this.m_parameters.getNumParams()) {
                OracleInternalParameter oracleInternalParameter = this.m_parameters.paramSet[n];
                if ((oracleInternalParameter.m_direction & 0x10) != 0) {
                    if (bl2) {
                        oracleDataProvider.readByte();
                    }
                    if (oracleInternalParameter.m_maxlen > 4000 && (this.useOAll7 || this.myImplConn.oracleServerVersion < 1000000000L)) {
                        if (!bl && !bl2) {
                            oracleDataProvider.readByte();
                        }
                        bl2 = true;
                    } else {
                        bl2 = false;
                    }
                    if (oracleInternalParameter.m_nativeBindType == 102) {
                        if (this.useOAll7) {
                            byte by = oracleDataProvider.readByte();
                        } else {
                            oracleDataProvider.readByte();
                            oracleDataProvider.readB2();
                            TTIDCBDataPacket tTIDCBDataPacket = new TTIDCBDataPacket(this.myImplConn);
                            tTIDCBDataPacket.ColumnsStreamIn(oracleDataProvider);
                            oracleInternalParameter.m_columnDescriptions = tTIDCBDataPacket.getColumns();
                        }
                    }
                    oracleInternalParameter.readData(oracleDataProvider);
                    bl = false;
                }
                ++n;
            }
        }
    }

    private static int ConvertUIntegerToBase64Ascii(byte[] byArray, long l, int n, int n2) {
        int n3 = n2 + n;
        while (n > 0) {
            byArray[n2 + n - 1] = s_base64CharMap[(int)l & 0x3F];
            l = l >> 6 & 0x3FFFFFFL;
            --n;
        }
        return n3;
    }

    static int ConvertRowidSegmentsToBase64Ascii(long l, long l2, long l3, long l4, byte[] byArray, int n) {
        n = TTIRXDDataPacket.ConvertUIntegerToBase64Ascii(byArray, l, 6, n);
        n = TTIRXDDataPacket.ConvertUIntegerToBase64Ascii(byArray, l2, 3, n);
        n = TTIRXDDataPacket.ConvertUIntegerToBase64Ascii(byArray, l3, 6, n);
        n = TTIRXDDataPacket.ConvertUIntegerToBase64Ascii(byArray, l4, 3, n);
        return 18;
    }
}

