/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.jdbc.metadata.impl;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.jdbc.JdbcException;
import com.metamatrix.modeler.jdbc.JdbcPlugin;
import com.metamatrix.modeler.jdbc.metadata.Capabilities;
import com.metamatrix.modeler.jdbc.metadata.DatabaseInfo;
import com.metamatrix.modeler.jdbc.metadata.Includes;
import com.metamatrix.modeler.jdbc.metadata.JdbcCatalog;
import com.metamatrix.modeler.jdbc.metadata.JdbcDatabase;
import com.metamatrix.modeler.jdbc.metadata.JdbcNode;
import com.metamatrix.modeler.jdbc.metadata.JdbcNodeVisitor;
import com.metamatrix.modeler.jdbc.metadata.JdbcSchema;
import com.metamatrix.modeler.jdbc.metadata.JdbcTableType;
import com.metamatrix.modeler.jdbc.metadata.impl.CapabilitiesImpl;
import com.metamatrix.modeler.jdbc.metadata.impl.DatabaseInfoImpl;
import com.metamatrix.modeler.jdbc.metadata.impl.IncludesImpl;
import com.metamatrix.modeler.jdbc.metadata.impl.InternalJdbcDatabase;
import com.metamatrix.modeler.jdbc.metadata.impl.JdbcCatalogImpl;
import com.metamatrix.modeler.jdbc.metadata.impl.JdbcNodeCache;
import com.metamatrix.modeler.jdbc.metadata.impl.JdbcNodeImpl;
import com.metamatrix.modeler.jdbc.metadata.impl.JdbcNodeSelections;
import com.metamatrix.modeler.jdbc.metadata.impl.JdbcProcedureTypeImpl;
import com.metamatrix.modeler.jdbc.metadata.impl.JdbcSchemaImpl;
import com.metamatrix.modeler.jdbc.metadata.impl.JdbcTableTypeImpl;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class JdbcDatabaseImpl
extends JdbcNodeImpl
implements JdbcDatabase,
InternalJdbcDatabase {
    private final Connection connection;
    private DatabaseMetaData metadata;
    private Capabilities capabilities;
    private DatabaseInfo databaseInfo;
    private final JdbcNodeCache cache;
    private final JdbcNodeSelections selections;
    private final IncludesImpl includes;
    private final Object capabilitiesLock = new Object();
    private final Object databaseInfoLock = new Object();

    public JdbcDatabaseImpl(Connection connection, String name) {
        this(connection, name, new JdbcNodeSelections());
    }

    public JdbcDatabaseImpl(Connection connection, String name, JdbcNodeSelections selections) {
        super(101, name, null);
        ArgCheck.isNotNull((Object)connection);
        this.connection = connection;
        this.includes = new IncludesImpl((JdbcDatabase)this);
        this.cache = new JdbcNodeCache();
        this.cache.put((JdbcNode)this);
        this.selections = selections;
        this.doSetSelectionMode(2);
    }

    public void accept(JdbcNodeVisitor theVisitor, int theDepth) throws JdbcException {
        if (theVisitor instanceof SelectSchemasAndCatalogs) {
            if (theDepth != 1) {
                super.accept(theVisitor, 1);
            }
            if (!((SelectSchemasAndCatalogs)theVisitor).foundMatch()) {
                super.accept(theVisitor, theDepth);
            }
        } else {
            super.accept(theVisitor, theDepth);
        }
    }

    public JdbcNodeSelections getJdbcNodeSelections() {
        return this.selections;
    }

    public IPath getPathInSource() {
        return null;
    }

    public IPath getPathInSource(boolean includeCatalog, boolean includeSchema) {
        return null;
    }

    public boolean isDatabaseObject() {
        return false;
    }

    public JdbcNode getParentDatabaseObject(boolean includeCatalog, boolean includeSchema) {
        return null;
    }

    public JdbcDatabase getJdbcDatabase() {
        return this;
    }

    public JdbcNodeCache getJdbcNodeCache() {
        return this.cache;
    }

    public JdbcNode findJdbcNode(IPath path) {
        return this.cache.get(path);
    }

    public JdbcNode findJdbcNode(String path) {
        return this.findJdbcNode((IPath)new Path(path));
    }

    public JdbcNode[] getSelectedChildren() throws JdbcException {
        ArrayList<JdbcNode> selectedNodes = new ArrayList<JdbcNode>();
        JdbcNode[] nodes = this.getChildren();
        int ndx = 0;
        while (ndx < nodes.length) {
            JdbcNode node = nodes[ndx];
            if (node.getSelectionMode() != 0) {
                selectedNodes.add(node);
            }
            ++ndx;
        }
        if (selectedNodes.size() > 0) {
            JdbcNode[] nodeArray = new JdbcNode[selectedNodes.size()];
            int iNode = 0;
            Iterator iter = selectedNodes.iterator();
            while (iter.hasNext()) {
                nodeArray[iNode] = (JdbcNode)iter.next();
                ++iNode;
            }
            return nodeArray;
        }
        return new JdbcNode[0];
    }

    public Connection getConnection() {
        return this.connection;
    }

    public DatabaseMetaData getDatabaseMetaData() throws JdbcException {
        if (this.metadata == null) {
            try {
                this.metadata = this.connection.getMetaData();
            }
            catch (SQLException e) {
                throw new JdbcException((Throwable)e, JdbcPlugin.Util.getString("JdbcDatabaseImpl.Error_while_getting_the_database_metadata_component"));
            }
        }
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Capabilities getCapabilities() throws JdbcException {
        if (this.capabilities == null) {
            Object object = this.capabilitiesLock;
            synchronized (object) {
                if (this.capabilities == null) {
                    this.capabilities = this.loadCapabilities(this.getDatabaseMetaData());
                }
            }
        }
        return this.capabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseInfo getDatabaseInfo() throws JdbcException {
        if (this.databaseInfo == null) {
            Object object = this.databaseInfoLock;
            synchronized (object) {
                if (this.databaseInfo == null) {
                    this.databaseInfo = this.loadDatabaseInfo(this.getDatabaseMetaData());
                }
            }
        }
        return this.databaseInfo;
    }

    public String getTypeName() {
        return JdbcPlugin.Util.getString("JdbcDatabaseImpl.DatabaseTypeName");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected JdbcNode[] computeChildren() throws JdbcException {
        block31: {
            block30: {
                capabilities = this.getCapabilities();
                supportsCatalogs = false;
                try {
                    supportsCatalogs = capabilities.supportsCatalogs();
                }
                catch (Throwable t) {
                    params = new Object[]{this.getConnection()};
                    msg = JdbcPlugin.Util.getString("JdbcDatabaseImpl.Unexpected_exception_while_discovering_support_for_catalogs", params);
                    JdbcPlugin.Util.log(2, t, msg);
                }
                supportsSchemas = false;
                try {
                    supportsSchemas = capabilities.supportsSchemas();
                }
                catch (Throwable t) {
                    params = new Object[]{this.getConnection()};
                    msg = JdbcPlugin.Util.getString("JdbcDatabaseImpl.Unexpected_exception_while_discovering_support_for_schemas", params);
                    JdbcPlugin.Util.log(2, t, msg);
                }
                metadata = this.getDatabaseMetaData();
                children = new ArrayList<Object>();
                if (!supportsCatalogs) break block30;
                resultSet = null;
                try {
                    try {
                        resultSet = metadata.getCatalogs();
                        while (resultSet.next()) {
                            catalogName = resultSet.getString(1);
                            children.add(new JdbcCatalogImpl((JdbcNode)this, catalogName));
                        }
                    }
                    catch (UnsupportedOperationException v0) {
                        supportsCatalogs = false;
                    }
                    catch (Throwable t) {
                        params = new Object[]{metadata.getClass().getName(), this.getConnection()};
                        msg = JdbcPlugin.Util.getString("JdbcDatabaseImpl.Unexpected_exception_while_calling_getCatalogs()_and_processing_results", params);
                        JdbcPlugin.Util.log(2, t, msg);
                        supportsCatalogs = false;
                    }
                }
                catch (Throwable var11_16) {
                    var10_18 = null;
                    if (resultSet == null) throw var11_16;
                    try {
                        resultSet.close();
                        throw var11_16;
                    }
                    catch (SQLException e) {
                        JdbcPlugin.Util.log((Throwable)e);
                    }
                    throw var11_16;
                }
                {
                    var10_19 = null;
                    if (resultSet == null) break block30;
                }
                ** try [egrp 4[TRYBLOCK] [6 : 266->276)] { 
lbl53:
                // 1 sources

                resultSet.close();
                break block30;
lbl55:
                // 1 sources

                catch (SQLException e) {
                    JdbcPlugin.Util.log((Throwable)e);
                }
            }
            if (!supportsSchemas || supportsCatalogs) break block31;
            resultSet = null;
            try {
                try {
                    resultSet = metadata.getSchemas();
                    while (resultSet.next()) {
                        catalogName = resultSet.getString(1);
                        children.add(new JdbcSchemaImpl((JdbcNode)this, catalogName));
                    }
                }
                catch (UnsupportedOperationException v1) {
                    supportsSchemas = false;
                }
                catch (Throwable t) {
                    params = new Object[]{metadata.getClass().getName(), this.getConnection()};
                    msg = JdbcPlugin.Util.getString("JdbcDatabaseImpl.Unexpected_exception_while_calling_getSchemas()_and_processing_results", params);
                    JdbcPlugin.Util.log(2, t, msg);
                    supportsSchemas = false;
                }
            }
            catch (Throwable var11_17) {
                var10_19 = null;
                if (resultSet == null) throw var11_17;
                try {
                    resultSet.close();
                    throw var11_17;
                }
                catch (SQLException e) {
                    JdbcPlugin.Util.log((Throwable)e);
                }
                throw var11_17;
            }
            {
                var10_19 = null;
                if (resultSet == null) break block31;
            }
            ** try [egrp 8[TRYBLOCK] [11 : 437->447)] { 
lbl91:
            // 1 sources

            resultSet.close();
            break block31;
lbl93:
            // 1 sources

            catch (SQLException e) {
                JdbcPlugin.Util.log((Throwable)e);
            }
        }
        if (supportsSchemas != false) return children.toArray(new JdbcNode[children.size()]);
        if (supportsCatalogs != false) return children.toArray(new JdbcNode[children.size()]);
        try {
            tableTypes = this.getJdbcDatabase().getIncludes().getIncludedTableTypes();
            if (tableTypes == null) {
                tableTypes = this.getJdbcDatabase().getCapabilities().getTableTypes();
            }
            i = 0;
            while (i < tableTypes.length) {
                children.add(new JdbcTableTypeImpl((JdbcNode)this, tableTypes[i]));
                ++i;
            }
        }
        catch (Throwable t) {
            params = new Object[]{metadata.getClass().getName(), this.getConnection()};
            msg = JdbcPlugin.Util.getString("JdbcDatabaseImpl.Unexpected_exception_while_calling_getTableTypes()_and_processing_results", params);
            JdbcPlugin.Util.log(2, t, msg);
        }
        if (this.getIncludes().includeProcedures() == false) return children.toArray(new JdbcNode[children.size()]);
        procTerm = null;
        try {
            procTerm = this.getCapabilities().getProcedureTerm();
        }
        catch (Throwable v2) {
            procTerm = JdbcPlugin.Util.getString("JdbcDatabaseImpl.ProcedureTypeName");
        }
        children.add(new JdbcProcedureTypeImpl((JdbcNode)this, procTerm));
        return children.toArray(new JdbcNode[children.size()]);
    }

    public String getFullyQualifiedName() {
        return "";
    }

    public Capabilities loadCapabilities(DatabaseMetaData metadata) throws JdbcException {
        return new CapabilitiesImpl(metadata);
    }

    public DatabaseInfo loadDatabaseInfo(DatabaseMetaData metadata) throws JdbcException {
        Status status;
        ArgCheck.isNotNull((Object)metadata);
        DatabaseInfoImpl obj = new DatabaseInfoImpl();
        ArrayList<Status> statuses = new ArrayList<Status>();
        try {
            obj.setProductName(metadata.getDatabaseProductName());
        }
        catch (SQLException e) {
            status = new Status(4, "com.metamatrix.modeler.jdbc", 0, JdbcPlugin.Util.getString("DatabaseInfoImpl.Unable_to_obtain_the_product_name", (Object)metadata), (Throwable)e);
            statuses.add(status);
        }
        try {
            obj.setProductVersion(metadata.getDatabaseProductVersion());
        }
        catch (SQLException e) {
            status = new Status(4, "com.metamatrix.modeler.jdbc", 0, JdbcPlugin.Util.getString("DatabaseInfoImpl.Unable_to_obtain_the_product_version", (Object)metadata), (Throwable)e);
            statuses.add(status);
        }
        obj.setDriverMajorVersion(metadata.getDriverMajorVersion());
        obj.setDriverMinorVersion(metadata.getDriverMinorVersion());
        try {
            obj.setDriverName(metadata.getDriverName());
        }
        catch (SQLException e) {
            status = new Status(4, "com.metamatrix.modeler.jdbc", 0, JdbcPlugin.Util.getString("DatabaseInfoImpl.Unable_to_obtain_the_driver_name", (Object)metadata), (Throwable)e);
            statuses.add(status);
        }
        try {
            obj.setDriverVersion(metadata.getDriverVersion());
        }
        catch (SQLException e) {
            status = new Status(4, "com.metamatrix.modeler.jdbc", 0, JdbcPlugin.Util.getString("DatabaseInfoImpl.Unable_to_obtain_the_driver_version", (Object)metadata), (Throwable)e);
            statuses.add(status);
        }
        try {
            obj.setDatabaseURL(metadata.getURL());
        }
        catch (SQLException e) {
            status = new Status(4, "com.metamatrix.modeler.jdbc", 0, JdbcPlugin.Util.getString("DatabaseInfoImpl.Unable_to_obtain_the_database_URL", (Object)metadata), (Throwable)e);
            statuses.add(status);
        }
        try {
            obj.setReadOnly(metadata.isReadOnly());
        }
        catch (SQLException e) {
            status = new Status(4, "com.metamatrix.modeler.jdbc", 0, JdbcPlugin.Util.getString("DatabaseInfoImpl.Unable_to_obtain_the_database_read-only_mode", (Object)metadata), (Throwable)e);
            statuses.add(status);
        }
        try {
            obj.setUserName(metadata.getUserName());
        }
        catch (SQLException e) {
            status = new Status(4, "com.metamatrix.modeler.jdbc", 0, JdbcPlugin.Util.getString("DatabaseInfoImpl.Unable_to_obtain_the_username", (Object)metadata), (Throwable)e);
            statuses.add(status);
        }
        if (statuses != null && statuses.size() != 0) {
            MultiStatus mstatus = new MultiStatus("com.metamatrix.modeler.jdbc", 0, JdbcPlugin.Util.getString("DatabaseInfoImpl.Error_while_processing_database_information", (Object)metadata), null);
            Iterator iter = statuses.iterator();
            while (iter.hasNext()) {
                IStatus status2 = (IStatus)iter.next();
                mstatus.add(status2);
            }
            throw new JdbcException((IStatus)mstatus);
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Object object;
        super.refresh();
        if (this.capabilities != null) {
            object = this.capabilitiesLock;
            synchronized (object) {
                this.capabilities = null;
            }
        }
        if (this.databaseInfo != null) {
            object = this.databaseInfoLock;
            synchronized (object) {
                this.databaseInfo = null;
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append(" - ");
        try {
            String url = this.connection.getMetaData().getURL();
            sb.append(url);
        }
        catch (SQLException sQLException) {}
        return super.toString();
    }

    public Includes getIncludes() {
        return this.includes;
    }

    public IStatus selectDefaultNodes() {
        try {
            String username = this.getDatabaseInfo().getUserName();
            boolean isExcel = false;
            String productName = this.getDatabaseInfo().getProductName();
            if (productName != null && productName.equalsIgnoreCase("excel")) {
                isExcel = true;
            }
            SelectSchemasAndCatalogs visitor = new SelectSchemasAndCatalogs(username, true, isExcel);
            this.accept(visitor, 2);
            if (!visitor.foundMatch()) {
                Object[] params = new Object[]{username};
                String msg = JdbcPlugin.Util.getString("JdbcDatabaseImpl.Unable_to_select_any_database_objects", params);
                return new Status(4, "com.metamatrix.modeler.jdbc", 3, msg, null);
            }
            Object[] params = new Object[]{new Integer(1)};
            String msg = JdbcPlugin.Util.getString("JdbcDatabaseImpl.Selected_database_objects", params);
            return new Status(0, "com.metamatrix.modeler.jdbc", 0, msg, null);
        }
        catch (JdbcException e) {
            String msg = JdbcPlugin.Util.getString("JdbcDatabaseImpl.Error_while_selecting_default_database_objects");
            return new Status(4, "com.metamatrix.modeler.jdbc", 0, msg, (Throwable)e);
        }
    }

    protected class SelectSchemasAndCatalogs
    implements JdbcNodeVisitor {
        private final String matchName;
        private final boolean ignoreCase;
        private final boolean isExcel;
        private boolean match = false;

        public SelectSchemasAndCatalogs(String matchName, boolean ignoreCase, boolean isExcel) {
            ArgCheck.isNotNull((Object)matchName);
            this.matchName = matchName;
            this.ignoreCase = ignoreCase;
            this.isExcel = isExcel;
        }

        public boolean foundMatch() {
            return this.match;
        }

        public boolean visit(JdbcNode node) throws JdbcException {
            if (this.foundMatch()) {
                return false;
            }
            if (node instanceof JdbcDatabase) {
                return true;
            }
            if (node instanceof JdbcCatalog || node instanceof JdbcSchema || this.isExcel && node instanceof JdbcTableType) {
                if (this.isExcel) {
                    this.match = true;
                } else {
                    String name = node.getName();
                    boolean bl = this.match = this.ignoreCase ? this.matchName.equalsIgnoreCase(name) : this.matchName.equals(name);
                }
                if (this.match) {
                    node.setSelected(true);
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

